/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.lang.reflect.Field;
import javax.annotation.PostConstruct;
import org.qubership.atp.ram.clients.api.dto.catalogue.BugTrackingSystemSynchronizationDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.BugTrackingSystemSynchronizationDtoDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SystemTypeEnumReplacer {
    private static final Logger log = LoggerFactory.getLogger(SystemTypeEnumReplacer.class);
    @Value(value="${internal.system-type.alias}")
    private String alias;

    @PostConstruct
    public void patch() {
        this.patchEnumValue(BugTrackingSystemSynchronizationDto.SystemTypeEnum.class, BugTrackingSystemSynchronizationDto.SystemTypeEnum.INTERNAL_JIRA);
        log.debug("BugTrackingSystemSynchronizationDto.SystemTypeEnum.INTERNAL_JIRA.getValue() = {}", (Object)BugTrackingSystemSynchronizationDto.SystemTypeEnum.INTERNAL_JIRA.getValue());
        this.patchEnumValue(BugTrackingSystemSynchronizationDtoDto.SystemTypeEnum.class, BugTrackingSystemSynchronizationDtoDto.SystemTypeEnum.INTERNAL_JIRA);
        log.debug("BugTrackingSystemSynchronizationDtoDto.SystemTypeEnum.INTERNAL_JIRA.getValue() = {}", (Object)BugTrackingSystemSynchronizationDtoDto.SystemTypeEnum.INTERNAL_JIRA.getValue());
    }

    private void patchEnumValue(Class<?> enumClass, Enum<?> systemTypeEnum) {
        try {
            Field field = enumClass.getDeclaredField("value");
            field.setAccessible(true);
            field.set(systemTypeEnum, this.alias);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to patch " + enumClass.getName() + "#" + systemTypeEnum, e);
        }
    }
}

