/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;

public class Utils {
    private static final SimpleFilterProvider filterProvider = new SimpleFilterProvider();

    public static String filterAllExceptFields(Object objectToConvert, String[] fields, ObjectMapper mapper, String filterId) throws JsonProcessingException {
        filterProvider.addFilter(filterId, fields != null ? SimpleBeanPropertyFilter.filterOutAllExcept((String[])fields) : SimpleBeanPropertyFilter.serializeAll());
        return mapper.writer((FilterProvider)filterProvider).withDefaultPrettyPrinter().writeValueAsString(objectToConvert);
    }

    public static String cleanXmlTags(String htmlString) {
        if (Objects.nonNull(htmlString)) {
            Source source = new Source((CharSequence)htmlString);
            Segment segment = new Segment(source, 0, source.length());
            return new TextExtractor(segment).toString();
        }
        return null;
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(Utils.getAllDeclaredFields(clazz.getSuperclass()));
        result.addAll(Arrays.stream(clazz.getDeclaredFields()).collect(Collectors.toList()));
        return result;
    }
}

