#!/usr/bin/env sh

if [ "${ATP_INTERNAL_GATEWAY_ENABLED:-false}" = "true" ]; then
  echo "Internal gateway integration is enabled."
  FEIGN_ATP_CATALOGUE_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_DATASETS_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_ORCHESTRATOR_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_MAILSENDER_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_USERS_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_ENVIRONMENTS_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_NOTIFICATION_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
  FEIGN_ATP_EI_NAME=${FEIGN_ATP_INTERNAL_GATEWAY_NAME}
else
  echo "Internal gateway integration is disabled."
  FEIGN_ATP_CATALOGUE_ROUTE=
  FEIGN_ATP_DATASETS_ROUTE=
  FEIGN_ATP_ORCHESTRATOR_ROUTE=
  FEIGN_ATP_MAILSENDER_ROUTE=
  FEIGN_ATP_USERS_ROUTE=
  FEIGN_ATP_ENVIRONMENTS_NAME=
  FEIGN_ATP_NOTIFICATION_ROUTE=
  FEIGN_ATP_EI_ROUTE=
fi

JAVA_OPTIONS="${JAVA_OPTIONS} -Dspring.devtools.add-properties=false"
JAVA_OPTIONS="${JAVA_OPTIONS} -XX:+PrintFlagsFinal"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dspring.config.location=${SPRING_CONFIG_LOCATION:-./config/application.properties}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dspring.cloud.bootstrap.location=./config/bootstrap.properties"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dlog.graylog.on=${GRAYLOG_ON:-false}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dlog.graylog.host=${GRAYLOG_HOST}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dlog.graylog.port=${GRAYLOG_PORT}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dei.gridfs.database=${EI_GRIDFS_DB:?}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dei.gridfs.host=${EI_GRIDFS_DB_ADDR:-$GRIDFS_DB_ADDR}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dei.gridfs.port=${EI_GRIDFS_DB_PORT:-$GRIDFS_DB_PORT}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dei.gridfs.user=${EI_GRIDFS_USER:?}"
JAVA_OPTIONS="${JAVA_OPTIONS} -Dei.gridfs.password=${EI_GRIDFS_PASSWORD:?}"
JAVA_OPTIONS="${JAVA_OPTIONS} --add-opens java.base/java.lang=ALL-UNNAMED"

# Profiler uses this path
/usr/bin/java -XX:MaxRAM=${MAX_RAM:-1024m} ${JAVA_OPTIONS} -cp "./config/:./lib/*" org.qubership.atp.ram.Main

