/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.services;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.logging.entities.requests.CreatedTestRunWithParentsRequest;
import org.qubership.atp.ram.logging.services.LogRecordLoggingService;
import org.qubership.atp.ram.logging.services.TestRunLoggingService;
import org.qubership.atp.ram.logging.utils.ObjectsFieldsUtils;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.utils.RateCalculator;
import org.qubership.atp.ram.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExecutionRequestLoggingService {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestLoggingService.class);
    private final ExecutionRequestRepository executionRequestRepository;
    private final ModelMapper modelMapper;
    private final RateCalculator rateCalculator;
    private final LogRecordLoggingService logRecordLoggingService;
    private final TestRunLoggingService testRunLoggingService;

    ExecutionRequest findOrCreateExecutionRequest(CreatedTestRunWithParentsRequest request, TestPlan testPlan) {
        UUID executionRequestId = request.getAtpExecutionRequestId();
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(executionRequestId);
        if (Objects.nonNull(executionRequest)) {
            log.debug("Execution request is exist {}", (Object)executionRequest.getUuid());
            return executionRequest;
        }
        return this.createNewExecutionRequest(request, testPlan);
    }

    private ExecutionRequest createNewExecutionRequest(CreatedTestRunWithParentsRequest request, TestPlan testPlan) {
        String executionRequestName = request.getExecutionRequestName();
        UUID executionRequestId = request.getAtpExecutionRequestId();
        String mail = request.getMailList();
        ExecutionRequest executionRequest = (ExecutionRequest)this.modelMapper.map((Object)request, ExecutionRequest.class);
        executionRequest.setUuid(executionRequestId);
        executionRequest.setName(executionRequestName);
        executionRequest.setTestPlanId(testPlan.getUuid());
        executionRequest.setProjectId(testPlan.getProjectId());
        executionRequest.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
        executionRequest.setStartDate(new Timestamp(System.currentTimeMillis()));
        executionRequest.setLegacyMailRecipients(mail);
        log.debug("Execution request will be creating. Name {}, ID {}", (Object)executionRequestName, (Object)executionRequestId);
        return (ExecutionRequest)this.executionRequestRepository.save((Object)executionRequest);
    }

    public void stop(UUID requestId) {
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(requestId);
        log.trace("Start stopping Execution Request: {}", (Object)executionRequest.getUuid());
        executionRequest.setFinishDate(new Timestamp(System.currentTimeMillis()));
        ExecutionStatuses currentExecutionStatus = executionRequest.getExecutionStatus();
        if (Objects.isNull(currentExecutionStatus) || currentExecutionStatus.getId() < ExecutionStatuses.FINISHED.getId()) {
            executionRequest.setExecutionStatus(ExecutionStatuses.FINISHED);
        }
        log.trace("Execution Request: {} status was changed from {} to {}", new Object[]{executionRequest.getUuid(), currentExecutionStatus, executionRequest.getExecutionStatus()});
        List<TestRun> testRuns = this.testRunLoggingService.findTestRunsByErId(executionRequest.getUuid());
        if (!testRuns.isEmpty()) {
            log.debug("Start calculate rates for ER {}", (Object)executionRequest.getUuid());
            this.rateCalculator.calculateRates(executionRequest, testRuns);
            log.debug("Start calculate count of screenshots for every TR in ER {}", (Object)executionRequest.getUuid());
            this.logRecordLoggingService.saveCountScreenshots(executionRequest.getUuid(), testRuns);
        }
        executionRequest.setDuration(TimeUtils.getDuration((Timestamp)executionRequest.getStartDate(), (Timestamp)executionRequest.getFinishDate()));
        this.executionRequestRepository.save((Object)executionRequest);
        log.debug("Execution Request: {} was finished and analyzed.", (Object)executionRequest.getUuid());
    }

    public void updateExecutionStatus(UUID id, ExecutionStatuses newExecutionStatus) {
        log.trace("Start updating execution status {} for ER {}", (Object)newExecutionStatus, (Object)id);
        if (ExecutionStatuses.FINISHED.equals((Object)newExecutionStatus)) {
            this.stop(id);
        } else {
            ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(id);
            ObjectsFieldsUtils.setField(arg_0 -> ((ExecutionRequest)executionRequest).setExecutionStatus(arg_0), Objects.nonNull(newExecutionStatus) ? newExecutionStatus : executionRequest.getExecutionStatus());
            this.executionRequestRepository.save((Object)executionRequest);
        }
        log.trace("Stop updating execution status for ER {}", (Object)id);
    }

    public ExecutionRequestLoggingService(ExecutionRequestRepository executionRequestRepository, ModelMapper modelMapper, RateCalculator rateCalculator, LogRecordLoggingService logRecordLoggingService, TestRunLoggingService testRunLoggingService) {
        this.executionRequestRepository = executionRequestRepository;
        this.modelMapper = modelMapper;
        this.rateCalculator = rateCalculator;
        this.logRecordLoggingService = logRecordLoggingService;
        this.testRunLoggingService = testRunLoggingService;
    }
}

