/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.services;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.logging.entities.requests.CreatedLogRecordRequest;
import org.qubership.atp.ram.logging.entities.requests.UpdateLogRecordStatusAndResponseRequest;
import org.qubership.atp.ram.logging.entities.responses.CreatedLogRecordResponse;
import org.qubership.atp.ram.logging.entities.responses.UploadScreenshotResponse;
import org.qubership.atp.ram.logging.utils.ImageUtils;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.logrecords.RestLogRecord;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.repositories.LogRecordRepository;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LogRecordLoggingService {
    private static final Logger log = LoggerFactory.getLogger(LogRecordLoggingService.class);
    private static final String CONTENT_TYPE = "image/png";
    private final GridFsService gridFsService;
    private final LogRecordRepository logRecordRepository;
    private final TestRunRepository testRunRepository;
    private final ExecutionRequestRepository executionRequestRepository;
    @Qualifier(value="mapperForLogging")
    private final ModelMapper modelMapper;

    public UploadScreenshotResponse upload(String contentType, UUID id, InputStream inputStream, String fileName, String snapshotSource) {
        log.trace("Start upload file for LR {}", (Object)id);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
            byte[] bytesImage = byteArrayOutputStream.toByteArray();
            String screenId = this.gridFsService.save("image", LocalDateTime.now().toString(), contentType, id, (InputStream)new ByteArrayInputStream(bytesImage), fileName, snapshotSource);
            String base64Preview = null;
            if (Objects.isNull(contentType) || contentType.equals(CONTENT_TYPE)) {
                base64Preview = ImageUtils.scaleAndConvertImageToBase64(new ByteArrayInputStream(bytesImage), id);
            }
            return new UploadScreenshotResponse(screenId, base64Preview);
        }
        catch (IOException ex) {
            log.error("Failed to save file for Log Record: [{}]", (Object)id, (Object)ex);
            return new UploadScreenshotResponse();
        }
    }

    public CreatedLogRecordResponse updateTestingStatusMessageAndRequestResponse(UUID logRecordId, UpdateLogRecordStatusAndResponseRequest request) {
        log.debug("Start update LR {}", (Object)logRecordId);
        LogRecord logRecord = this.logRecordRepository.findByUuid(logRecordId);
        logRecord.setMessage(request.getMessage());
        logRecord.setTestingStatus(request.getTestingStatus());
        TypeAction type = logRecord.getType();
        if (type.equals((Object)TypeAction.MIA) || type.equals((Object)TypeAction.ITF) || type.equals((Object)TypeAction.REST)) {
            ((RestLogRecord)logRecord).setRequest(request.getRequest());
            ((RestLogRecord)logRecord).setResponse(request.getResponse());
        }
        this.logRecordRepository.save((Object)logRecord);
        log.debug("LR {} updated. Testing status [{}], message [{}].", new Object[]{logRecordId, request.getTestingStatus(), request.getMessage()});
        return new CreatedLogRecordResponse(logRecord.getUuid());
    }

    void saveCountScreenshots(UUID executionRequestUuid, List<TestRun> testRuns) {
        if (!testRuns.isEmpty()) {
            int numberOfScreen = 0;
            HashMap<UUID, String> trIdAndNumberOfScreens = new HashMap<UUID, String>();
            for (TestRun testRun : testRuns) {
                UUID uuid = testRun.getUuid();
                try {
                    List logRecords = this.logRecordRepository.findAllUuidByTestRunId(uuid);
                    if (!logRecords.isEmpty()) {
                        numberOfScreen = this.gridFsService.getCountScreen(logRecords);
                    }
                    trIdAndNumberOfScreens.put(uuid, String.valueOf(numberOfScreen));
                    testRun.setNumberOfScreens(numberOfScreen);
                }
                catch (Exception e) {
                    log.error("Error in calculating screenshots count for Test Run {}.", (Object)uuid, (Object)e);
                }
            }
            this.testRunRepository.saveAll(testRuns);
            log.debug("Number of screens for ER {}: {}", (Object)executionRequestUuid, trIdAndNumberOfScreens);
        }
    }

    public CreatedLogRecordResponse findOrCreate(CreatedLogRecordRequest createdLogRecordRequest) {
        log.trace("Start of search (or creating - if the Log Record was not found) by request:\n{}", (Object)createdLogRecordRequest);
        LogRecord logRecord = this.findByRequestOrCreate(createdLogRecordRequest);
        TestRun testRun = this.testRunRepository.findByUuid(logRecord.getTestRunId());
        this.updateExecutionStatusOfTestAndExecutionRequest(testRun);
        log.trace("Finish updating Log Record {} for TR {}, ER {}", new Object[]{logRecord.getUuid(), testRun.getUuid(), testRun.getExecutionRequestId()});
        CreatedLogRecordResponse createdLogRecordResponse = new CreatedLogRecordResponse();
        createdLogRecordResponse.setLogRecordUuid(logRecord.getUuid());
        return createdLogRecordResponse;
    }

    private void updateExecutionStatusOfTestAndExecutionRequest(TestRun testRun) {
        if (ExecutionStatuses.TERMINATED.equals((Object)testRun.getExecutionStatus())) {
            log.warn("TestRun [{}] is already terminated", (Object)testRun.getUuid());
        } else {
            testRun.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
            this.testRunRepository.save((Object)testRun);
            ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(testRun.getExecutionRequestId());
            executionRequest.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
            this.executionRequestRepository.save((Object)executionRequest);
            log.debug("Set In Progress status for TR {} and ER {}.", (Object)testRun.getUuid(), (Object)testRun.getExecutionRequestId());
        }
    }

    LogRecord findByRequestOrCreate(CreatedLogRecordRequest createdLogRecordRequest) {
        LogRecord logRecord = this.logRecordRepository.findByUuid(createdLogRecordRequest.getLogRecordUuid());
        if (Objects.isNull(logRecord)) {
            LogRecord logRecordRequest = (LogRecord)this.modelMapper.map((Object)createdLogRecordRequest, LogRecord.class);
            logRecordRequest.setCreatedDate(new Timestamp(System.currentTimeMillis()));
            return (LogRecord)this.logRecordRepository.save((Object)logRecordRequest);
        }
        return logRecord;
    }

    public LogRecordLoggingService(GridFsService gridFsService, LogRecordRepository logRecordRepository, TestRunRepository testRunRepository, ExecutionRequestRepository executionRequestRepository, ModelMapper modelMapper) {
        this.gridFsService = gridFsService;
        this.logRecordRepository = logRecordRepository;
        this.testRunRepository = testRunRepository;
        this.executionRequestRepository = executionRequestRepository;
        this.modelMapper = modelMapper;
    }
}

