/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.services;

import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.ram.logging.entities.requests.CreatedTestRunWithParentsRequest;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.repositories.TestPlansRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TestPlanLoggingService {
    private static final Logger log = LoggerFactory.getLogger(TestPlanLoggingService.class);
    private final TestPlansRepository repository;

    public TestPlan findByUuidNameOrCreateNew(CreatedTestRunWithParentsRequest request, Project project) {
        return this.findByUuidNameOrCreateNew(project.getUuid(), request.getTestPlanId(), request.getTestPlanName());
    }

    public TestPlan findByUuidNameOrCreateNew(UUID projectId, UUID testPlanId, String testPlanName) {
        if (Objects.nonNull(testPlanId)) {
            return this.findOrCreateTestPlanByUuid(projectId, testPlanId, testPlanName);
        }
        return this.findOrCreateTestPlanByProjectUuidAndTestPlanName(projectId, testPlanName);
    }

    synchronized TestPlan findOrCreateTestPlanByUuid(UUID projectId, UUID testPlanId, String testPlanName) {
        TestPlan result = this.repository.findByUuid(testPlanId);
        if (Objects.nonNull(result)) {
            log.debug("Test plan by ID is exist {}", (Object)result.getUuid());
            return result;
        }
        result = new TestPlan();
        result.setProjectId(projectId);
        result.setName(testPlanName);
        result.setUuid(testPlanId);
        log.debug("Test plan will be creating for project {} with name {}", (Object)projectId, (Object)testPlanName);
        this.repository.save((Object)result);
        return result;
    }

    synchronized TestPlan findOrCreateTestPlanByProjectUuidAndTestPlanName(UUID projectId, String testPlanName) {
        TestPlan result = this.repository.findByProjectIdAndName(projectId, testPlanName);
        if (Objects.nonNull(result)) {
            log.debug("Test plan by projectId && name is exist {}", (Object)result.getUuid());
            return result;
        }
        result = new TestPlan();
        result.setProjectId(projectId);
        result.setName(testPlanName);
        log.debug("Test plan will be creating for project {} with name {}", (Object)projectId, (Object)testPlanName);
        this.repository.save((Object)result);
        return result;
    }

    public TestPlanLoggingService(TestPlansRepository repository) {
        this.repository = repository;
    }
}

