/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.services;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.logging.entities.requests.CreatedTestRunRequest;
import org.qubership.atp.ram.logging.entities.requests.CreatedTestRunWithParentsRequest;
import org.qubership.atp.ram.logging.entities.requests.StopTestRunRequest;
import org.qubership.atp.ram.logging.entities.responses.CreatedTestRunResponse;
import org.qubership.atp.ram.logging.entities.responses.StopTestRunResponse;
import org.qubership.atp.ram.logging.services.ExecutionRequestLoggingService;
import org.qubership.atp.ram.logging.services.ProjectLoggingService;
import org.qubership.atp.ram.logging.services.TestPlanLoggingService;
import org.qubership.atp.ram.logging.utils.ListUtils;
import org.qubership.atp.ram.logging.utils.ObjectsFieldsUtils;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.IssueService;
import org.qubership.atp.ram.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TestRunLoggingService {
    private static final Logger log = LoggerFactory.getLogger(TestRunLoggingService.class);
    private final ProjectLoggingService projectLoggingService;
    private final TestPlanLoggingService testPlanLoggingService;
    private final ExecutionRequestLoggingService executionRequestLoggingService;
    private final TestRunRepository testRunRepository;
    private final ModelMapper modelMapper;
    private final IssueService issueService;

    public CreatedTestRunResponse findOrCreateWithParents(CreatedTestRunWithParentsRequest request) {
        log.trace("Request for create/update TR, TP, ER, project {}", (Object)request);
        Project project = this.projectLoggingService.findByUuidNameOrCreateNew(request);
        TestPlan testPlan = this.testPlanLoggingService.findByUuidNameOrCreateNew(request, project);
        ExecutionRequest executionRequest = this.executionRequestLoggingService.findOrCreateExecutionRequest(request, testPlan);
        TestRun testrun = this.configuredCreatedOrExistedTestRun(request, executionRequest.getUuid());
        log.trace("Finish create/update TR, TP, ER, project. Test run ID {}", (Object)testrun.getUuid());
        return new CreatedTestRunResponse(testrun.getUuid(), executionRequest.getUuid());
    }

    TestRun configuredCreatedOrExistedTestRun(CreatedTestRunWithParentsRequest request, UUID executionRequestId) {
        TestRun existedTestRun = Objects.isNull(request.getTestRunId()) ? this.testRunRepository.findByExecutionRequestIdAndName(executionRequestId, request.getTestRunName()) : this.testRunRepository.findByUuid(request.getTestRunId());
        TestRun configuredTestRun = this.configureTestRunObject(request, executionRequestId);
        if (Objects.nonNull(existedTestRun)) {
            log.debug("Test run was exist, {}", (Object)existedTestRun.getUuid());
            this.updateListParams(existedTestRun, configuredTestRun);
            return (TestRun)this.testRunRepository.save((Object)existedTestRun);
        }
        log.debug("Test run will be creating for ER {}", (Object)executionRequestId);
        return (TestRun)this.testRunRepository.save((Object)configuredTestRun);
    }

    private void updateListParams(TestRun existedTestRun, TestRun configuredTestRun) {
        log.debug("Start updating list params for TR {}", (Object)existedTestRun.getUuid());
        existedTestRun.setQaHost(ListUtils.mergeTwoListsWithoutDuplicates(existedTestRun.getQaHost(), configuredTestRun.getQaHost()));
        existedTestRun.setSolutionBuild(ListUtils.mergeTwoListsWithoutDuplicates(existedTestRun.getSolutionBuild(), configuredTestRun.getSolutionBuild()));
        existedTestRun.setTaHost(ListUtils.mergeTwoListsWithoutDuplicates(existedTestRun.getTaHost(), configuredTestRun.getTaHost()));
    }

    private TestRun configureTestRunObject(CreatedTestRunRequest request, UUID requestId) {
        log.debug("Request for TR: {}", (Object)request);
        TestRun testRun = (TestRun)this.modelMapper.map((Object)request, TestRun.class);
        testRun.setExecutionRequestId(requestId);
        testRun.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setStartDate(arg_0), new Timestamp(System.currentTimeMillis()));
        testRun.updateTestingStatus(TestingStatuses.UNKNOWN);
        testRun.setName(request.getTestRunName());
        return testRun;
    }

    public CreatedTestRunResponse update(CreatedTestRunRequest request) {
        log.trace("Start updating TR {}", (Object)request.getTestRunId());
        TestRun testRun = this.testRunRepository.findByUuid(request.getTestRunId());
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setExecutionStatus(arg_0), Objects.nonNull(request.getExecutionStatus()) ? ExecutionStatuses.findByValue((String)request.getExecutionStatus()) : ExecutionStatuses.IN_PROGRESS);
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).updateTestingStatus(arg_0), Objects.nonNull(request.getTestingStatus()) ? TestingStatuses.findByValue((String)request.getTestingStatus()) : TestingStatuses.UNKNOWN);
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setFinishDate(arg_0), new Timestamp(request.getFinishDate()));
        testRun.setDuration(TimeUtils.getDuration((Timestamp)testRun.getStartDate(), (Timestamp)testRun.getFinishDate()));
        this.updateListParams(testRun, (TestRun)this.modelMapper.map((Object)request, TestRun.class));
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setUrlToBrowserOrLogs(arg_0), this.getUrlToBrowserLog(testRun, request.getUrlToBrowserOrLogs()));
        this.testRunRepository.save((Object)testRun);
        log.trace("Finish updating TR {}", (Object)request.getTestRunId());
        return new CreatedTestRunResponse(testRun.getUuid(), null);
    }

    public StopTestRunResponse stop(StopTestRunRequest request) {
        log.info("Start stopping test run {}", (Object)request.getTestRunId());
        TestRun testRun = this.testRunRepository.findByUuid(request.getTestRunId());
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setFinishDate(arg_0), new Timestamp(System.currentTimeMillis()));
        testRun.setDuration(TimeUtils.getDuration((Timestamp)testRun.getStartDate(), (Timestamp)testRun.getFinishDate()));
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).updateTestingStatus(arg_0), Objects.nonNull(request.getTestingStatus()) ? TestingStatuses.findByValue((String)request.getTestingStatus()) : TestingStatuses.UNKNOWN);
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setExecutionStatus(arg_0), Objects.nonNull(request.getExecutionStatus()) ? ExecutionStatuses.findByValue((String)request.getExecutionStatus()) : ExecutionStatuses.FINISHED);
        ObjectsFieldsUtils.setField(arg_0 -> ((TestRun)testRun).setUrlToBrowserOrLogs(arg_0), this.getUrlToBrowserLog(testRun, request.getUrlToBrowserOrLogs()));
        this.testRunRepository.save((Object)testRun);
        if (TestingStatuses.FAILED.equals((Object)testRun.getTestingStatus())) {
            this.issueService.calculateIssuesForExecution(testRun.getExecutionRequestId(), Collections.singletonList(testRun.getUuid()));
        }
        log.trace("Finish stopping test run {}", (Object)request.getTestRunId());
        return new StopTestRunResponse(testRun.getExecutionStatus().toString());
    }

    Set<String> getUrlToBrowserLog(TestRun testRun, Set<String> urls) {
        log.debug("Start preparing browser log for TR {}, urls {}", (Object)testRun.getUuid(), urls);
        if (!CollectionUtils.isEmpty(urls)) {
            String forReplace = "T";
            String startDateStr = testRun.getStartDate().toString().replace(" ", forReplace);
            String finishDateStr = testRun.getFinishDate().toString().replace(" ", forReplace);
            HashSet<String> newUrls = new HashSet<String>();
            for (String url : urls) {
                newUrls.add(url.replace("${START_DATE}", startDateStr).replace("${END_DATE}", finishDateStr));
            }
            log.debug("Finish preparing browser log for TR {}, result urls {}", (Object)testRun.getUuid(), newUrls);
            return newUrls;
        }
        log.debug("Urls for test run {} are empty", (Object)testRun.getUuid());
        return urls;
    }

    public List<TestRun> findTestRunsByErId(UUID executionRequestId) {
        return this.testRunRepository.findAllByExecutionRequestId(executionRequestId);
    }

    public TestRunLoggingService(ProjectLoggingService projectLoggingService, TestPlanLoggingService testPlanLoggingService, ExecutionRequestLoggingService executionRequestLoggingService, TestRunRepository testRunRepository, ModelMapper modelMapper, IssueService issueService) {
        this.projectLoggingService = projectLoggingService;
        this.testPlanLoggingService = testPlanLoggingService;
        this.executionRequestLoggingService = executionRequestLoggingService;
        this.testRunRepository = testRunRepository;
        this.modelMapper = modelMapper;
        this.issueService = issueService;
    }
}

