/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static String scaleAndConvertImageToBase64(InputStream content, UUID logRecordId) {
        try {
            int width = 300;
            String ext = "jpg";
            BufferedImage image = ImageIO.read(content);
            BufferedImage resized = ImageUtils.resize(image, 300, 300 * image.getHeight() / image.getWidth());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resized, "jpg", outputStream);
            return Base64.getEncoder().encodeToString(outputStream.toByteArray());
        }
        catch (IOException e) {
            log.error("Failed to scale nad convert preview for log record with id: {}", (Object)logRecordId, (Object)e);
            return "";
        }
    }

    private static BufferedImage resize(BufferedImage img, int width, int height) {
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, 1);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }

    private ImageUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

