/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.controllers;

import java.io.InputStream;
import java.util.UUID;
import org.qubership.atp.ram.logging.entities.requests.CreatedLogRecordRequest;
import org.qubership.atp.ram.logging.entities.requests.UpdateLogRecordStatusAndResponseRequest;
import org.qubership.atp.ram.logging.entities.responses.CreatedLogRecordResponse;
import org.qubership.atp.ram.logging.entities.responses.UploadScreenshotResponse;
import org.qubership.atp.ram.logging.services.LogRecordLoggingService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/logging/logRecords"})
@RestController
public class LogRecordLoggingController {
    private final LogRecordLoggingService logRecordLoggingService;

    @PostMapping(value={"/upload/{uuid}/stream"})
    public UploadScreenshotResponse upload(@PathVariable(value="uuid") UUID id, @RequestParam(value="contentType") String contentType, @RequestParam(value="fileName") String fileName, @RequestParam(value="snapshotSource") String snapshotSource, @RequestBody InputStream inputStream) {
        return this.logRecordLoggingService.upload(contentType, id, inputStream, fileName, snapshotSource);
    }

    @PostMapping(value={"/{uuid}/update"})
    public CreatedLogRecordResponse updateTestingStatusMessageAndRequestResponse(@PathVariable(value="uuid") UUID logRecordId, @RequestBody UpdateLogRecordStatusAndResponseRequest request) {
        return this.logRecordLoggingService.updateTestingStatusMessageAndRequestResponse(logRecordId, request);
    }

    @PostMapping(value={"/findOrCreate"})
    public CreatedLogRecordResponse findOrCreate(@RequestBody CreatedLogRecordRequest createdLogRecordRequest) {
        return this.logRecordLoggingService.findOrCreate(createdLogRecordRequest);
    }

    public LogRecordLoggingController(LogRecordLoggingService logRecordLoggingService) {
        this.logRecordLoggingService = logRecordLoggingService;
    }
}

