/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.configuration;

import java.sql.Timestamp;
import org.modelmapper.AbstractConverter;
import org.modelmapper.AbstractProvider;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.modelmapper.Provider;
import org.qubership.atp.ram.logging.entities.requests.CreatedLogRecordRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ModelMapperConfiguration {
    @Bean(name={"mapperForLogging"})
    public ModelMapper initModelMapper() {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setSkipNullEnabled(true);
        this.addDateConverted(modelMapper);
        this.addPropertyMap(modelMapper);
        return modelMapper;
    }

    private void addDateConverted(ModelMapper modelMapper) {
        AbstractProvider<Timestamp> localDateProvider = new AbstractProvider<Timestamp>(){

            public Timestamp get() {
                return new Timestamp(System.currentTimeMillis());
            }
        };
        AbstractConverter<String, Timestamp> toStringDate = new AbstractConverter<String, Timestamp>(){

            protected Timestamp convert(String source) {
                return Timestamp.valueOf(source);
            }
        };
        modelMapper.createTypeMap(String.class, Timestamp.class);
        modelMapper.addConverter((Converter)toStringDate);
        modelMapper.getTypeMap(String.class, Timestamp.class).setProvider((Provider)localDateProvider);
    }

    private void addPropertyMap(ModelMapper modelMapper) {
        PropertyMap<CreatedLogRecordRequest, LogRecord> propertyMap = new PropertyMap<CreatedLogRecordRequest, LogRecord>(){

            protected void configure() {
                ((LogRecord)this.map()).setUuid(((CreatedLogRecordRequest)this.source).getLogRecordUuid());
                ((LogRecord)this.map()).setParentRecordId(((CreatedLogRecordRequest)this.source).getParentRecordUuid());
                ((LogRecord)this.map()).setCompaund(((CreatedLogRecordRequest)this.source).isCompaund());
            }
        };
        modelMapper.addMappings((PropertyMap)propertyMap);
    }
}

