/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.logging.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.ram.logging.entities.requests.CreatedTestRunWithParentsRequest;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.repositories.ProjectsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProjectLoggingService {
    private static final Logger log = LoggerFactory.getLogger(ProjectLoggingService.class);
    private final ProjectsRepository projectsRepository;

    public Project findByUuidNameOrCreateNew(CreatedTestRunWithParentsRequest request) {
        if (Objects.nonNull(request.getProjectId())) {
            return this.findOrCreateProjectByUuid(request.getProjectId(), request.getProjectName());
        }
        return this.findProjectByName(request.getProjectName());
    }

    synchronized Project findOrCreateProjectByUuid(UUID projectId, String projectName) {
        Project result = this.projectsRepository.findByUuid(projectId);
        if (Objects.nonNull(result)) {
            log.debug("Project by ID is exist {}", (Object)result.getUuid());
            return result;
        }
        result = new Project();
        result.setName(projectName);
        result.setUuid(projectId);
        this.projectsRepository.save((Object)result);
        log.debug("Project will be creating {}", (Object)projectId);
        return result;
    }

    synchronized Project findProjectByName(String projectName) {
        Project result = this.getProjectByName(projectName);
        if (Objects.isNull(result)) {
            log.error("Failed to find Project by name: {}", (Object)projectName);
            throw new AtpEntityNotFoundException("Project", "name", (Object)projectName);
        }
        return result;
    }

    private Project getProjectByName(String projectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"ProjectName is required!");
        return this.projectsRepository.findByName(projectName);
    }

    public ProjectLoggingService(ProjectsRepository projectsRepository) {
        this.projectsRepository = projectsRepository;
    }
}

