/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.filters;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.qubership.atp.ram.dto.filters.AbstractFilter;
import org.qubership.atp.ram.dto.filters.FilterUtils;
import org.qubership.atp.ram.dto.filters.types.FilterType;
import org.qubership.atp.ram.dto.filters.types.SingleValueFilterType;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestUnexpectedFilterTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

public class DateFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(DateFilter.class);
    public static final String TYPE = "DateFilter";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final long DAY_MS = 86399999L;
    private FilterType filterType;
    private String value;
    private String to;
    private String from;
    private SingleValueFilterType valueFilterType;

    @Override
    public Criteria buildFilterCriteriaForField(String field) {
        if (this.valueFilterType == SingleValueFilterType.EQUAL) {
            this.filterType = FilterType.RANGE;
        }
        switch (this.filterType) {
            case VALUE: {
                Timestamp timestamp = this.getTimeStampFromString(this.value);
                if (timestamp == null) {
                    return null;
                }
                if (this.valueFilterType == SingleValueFilterType.TO) {
                    timestamp.setTime(timestamp.getTime() + 86399999L);
                }
                return FilterUtils.getCriteriaLessOrMoreThanValue(field, this.valueFilterType, timestamp);
            }
            case RANGE: {
                Timestamp from = this.getTimeStampFromString(this.from);
                Timestamp to = this.getTimeStampFromString(this.to);
                if (from == null || to == null) {
                    return null;
                }
                to.setTime(to.getTime() + 86399999L);
                return new Criteria().andOperator(new Criteria[]{Criteria.where((String)field).lte((Object)to), Criteria.where((String)field).gte((Object)from)});
            }
        }
        log.error("Unexpected execution request filter type: {}", (Object)this.filterType);
        throw new RamExecutionRequestUnexpectedFilterTypeException(this.filterType.name());
    }

    private Timestamp getTimeStampFromString(String date) {
        try {
            return new Timestamp(DATE_FORMAT.parse(date).getTime());
        }
        catch (ParseException e) {
            log.error("DateFilter:" + e.getLocalizedMessage());
            return null;
        }
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public String getValue() {
        return this.value;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public SingleValueFilterType getValueFilterType() {
        return this.valueFilterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setValueFilterType(SingleValueFilterType valueFilterType) {
        this.valueFilterType = valueFilterType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateFilter)) {
            return false;
        }
        DateFilter other = (DateFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FilterType this$filterType = this.getFilterType();
        FilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        SingleValueFilterType this$valueFilterType = this.getValueFilterType();
        SingleValueFilterType other$valueFilterType = other.getValueFilterType();
        return !(this$valueFilterType == null ? other$valueFilterType != null : !((Object)((Object)this$valueFilterType)).equals((Object)other$valueFilterType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DateFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        SingleValueFilterType $valueFilterType = this.getValueFilterType();
        result = result * 59 + ($valueFilterType == null ? 43 : ((Object)((Object)$valueFilterType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DateFilter(filterType=" + (Object)((Object)this.getFilterType()) + ", value=" + this.getValue() + ", to=" + this.getTo() + ", from=" + this.getFrom() + ", valueFilterType=" + (Object)((Object)this.getValueFilterType()) + ")";
    }
}

