/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.filters;

import org.qubership.atp.ram.dto.filters.types.SingleValueFilterType;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestUnexpectedFilterTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

public class FilterUtils {
    private static final Logger log = LoggerFactory.getLogger(FilterUtils.class);

    public static Criteria getCriteriaLessOrMoreThanValue(String field, SingleValueFilterType type, Object value) {
        switch (type) {
            case TO: {
                return Criteria.where((String)field).lte(value);
            }
            case FROM: {
                return Criteria.where((String)field).gte(value);
            }
            case EQUAL: {
                return Criteria.where((String)field).is(value);
            }
        }
        log.error("Unexpected execution request filter type: {}", (Object)type);
        throw new RamExecutionRequestUnexpectedFilterTypeException(type.name());
    }
}

