/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.filters;

import org.qubership.atp.ram.dto.filters.AbstractFilter;
import org.qubership.atp.ram.dto.filters.FilterUtils;
import org.qubership.atp.ram.dto.filters.types.FilterType;
import org.qubership.atp.ram.dto.filters.types.SingleValueFilterType;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestUnexpectedFilterTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

public class RateFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(RateFilter.class);
    public static final String TYPE = "RateFilter";
    private FilterType filterType;
    private Integer value;
    private Integer to;
    private Integer from;
    private SingleValueFilterType valueFilterType;

    @Override
    public Criteria buildFilterCriteriaForField(String field) {
        switch (this.filterType) {
            case VALUE: {
                if (this.valueFilterType == null) {
                    return Criteria.where((String)field).is((Object)this.value);
                }
                return FilterUtils.getCriteriaLessOrMoreThanValue(field, this.valueFilterType, this.value);
            }
            case RANGE: {
                if (this.from == null || this.to == null) {
                    return null;
                }
                return new Criteria().andOperator(new Criteria[]{Criteria.where((String)field).lte((Object)this.to), Criteria.where((String)field).gte((Object)this.from)});
            }
        }
        log.error("Unexpected execution request filter type: {}", (Object)this.filterType);
        throw new RamExecutionRequestUnexpectedFilterTypeException(this.filterType.name());
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Integer getValue() {
        return this.value;
    }

    public Integer getTo() {
        return this.to;
    }

    public Integer getFrom() {
        return this.from;
    }

    public SingleValueFilterType getValueFilterType() {
        return this.valueFilterType;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public void setTo(Integer to) {
        this.to = to;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setValueFilterType(SingleValueFilterType valueFilterType) {
        this.valueFilterType = valueFilterType;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateFilter)) {
            return false;
        }
        RateFilter other = (RateFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$value = this.getValue();
        Integer other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Integer this$to = this.getTo();
        Integer other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        FilterType this$filterType = this.getFilterType();
        FilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        SingleValueFilterType this$valueFilterType = this.getValueFilterType();
        SingleValueFilterType other$valueFilterType = other.getValueFilterType();
        return !(this$valueFilterType == null ? other$valueFilterType != null : !((Object)((Object)this$valueFilterType)).equals((Object)other$valueFilterType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RateFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Integer $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        FilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        SingleValueFilterType $valueFilterType = this.getValueFilterType();
        result = result * 59 + ($valueFilterType == null ? 43 : ((Object)((Object)$valueFilterType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RateFilter(filterType=" + (Object)((Object)this.getFilterType()) + ", value=" + this.getValue() + ", to=" + this.getTo() + ", from=" + this.getFrom() + ", valueFilterType=" + (Object)((Object)this.getValueFilterType()) + ")";
    }
}

