/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.entities.treenodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.ram.entities.treenodes.TreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNodeType;
import org.qubership.atp.ram.entities.treenodes.labelparams.CountReportLabelParam;
import org.qubership.atp.ram.models.LabelTemplate;
import org.springframework.util.CollectionUtils;

public class LabelTemplateTreeNode
extends TreeNode {
    private UUID labelId;
    private Map<UUID, String> errors = new HashMap<UUID, String>();
    private int passedRate;
    private int failedRate;
    private int warningRate;
    private int testRunCount;
    private int testRunPassedCount;
    private List<CountReportLabelParam> reportLabelParams = new ArrayList<CountReportLabelParam>();

    public LabelTemplateTreeNode(LabelTemplate.LabelTemplateNode labelTemplateNode, UUID executionRequestId) {
        this.id = UUID.randomUUID();
        this.name = labelTemplateNode.getLabelName();
        this.nodeType = TreeNodeType.LABEL_TEMPLATE_NODE;
        this.executionRequestId = executionRequestId;
        this.labelId = labelTemplateNode.getLabelId();
        this.errors = labelTemplateNode.getErrors();
        this.passedRate = labelTemplateNode.getPassedRate();
        this.warningRate = labelTemplateNode.getWarningRate();
        this.failedRate = labelTemplateNode.getFailedRate();
        this.testRunCount = labelTemplateNode.getTestRunCount();
        this.testRunPassedCount = labelTemplateNode.getTestRunPassedCount();
    }

    public LabelTemplateTreeNode(String name) {
        super(name);
    }

    public void setChildren(Collection<TreeNode> nodes) {
        if (CollectionUtils.isEmpty((Collection)this.children)) {
            this.children = new ArrayList();
        }
        this.children.addAll(nodes);
    }

    public UUID getLabelId() {
        return this.labelId;
    }

    public Map<UUID, String> getErrors() {
        return this.errors;
    }

    public int getPassedRate() {
        return this.passedRate;
    }

    public int getFailedRate() {
        return this.failedRate;
    }

    public int getWarningRate() {
        return this.warningRate;
    }

    public int getTestRunCount() {
        return this.testRunCount;
    }

    public int getTestRunPassedCount() {
        return this.testRunPassedCount;
    }

    public List<CountReportLabelParam> getReportLabelParams() {
        return this.reportLabelParams;
    }

    public void setLabelId(UUID labelId) {
        this.labelId = labelId;
    }

    public void setErrors(Map<UUID, String> errors) {
        this.errors = errors;
    }

    public void setPassedRate(int passedRate) {
        this.passedRate = passedRate;
    }

    public void setFailedRate(int failedRate) {
        this.failedRate = failedRate;
    }

    public void setWarningRate(int warningRate) {
        this.warningRate = warningRate;
    }

    public void setTestRunCount(int testRunCount) {
        this.testRunCount = testRunCount;
    }

    public void setTestRunPassedCount(int testRunPassedCount) {
        this.testRunPassedCount = testRunPassedCount;
    }

    public void setReportLabelParams(List<CountReportLabelParam> reportLabelParams) {
        this.reportLabelParams = reportLabelParams;
    }

    @Override
    public String toString() {
        return "LabelTemplateTreeNode(labelId=" + this.getLabelId() + ", errors=" + this.getErrors() + ", passedRate=" + this.getPassedRate() + ", failedRate=" + this.getFailedRate() + ", warningRate=" + this.getWarningRate() + ", testRunCount=" + this.getTestRunCount() + ", testRunPassedCount=" + this.getTestRunPassedCount() + ", reportLabelParams=" + this.getReportLabelParams() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelTemplateTreeNode)) {
            return false;
        }
        LabelTemplateTreeNode other = (LabelTemplateTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPassedRate() != other.getPassedRate()) {
            return false;
        }
        if (this.getFailedRate() != other.getFailedRate()) {
            return false;
        }
        if (this.getWarningRate() != other.getWarningRate()) {
            return false;
        }
        if (this.getTestRunCount() != other.getTestRunCount()) {
            return false;
        }
        if (this.getTestRunPassedCount() != other.getTestRunPassedCount()) {
            return false;
        }
        UUID this$labelId = this.getLabelId();
        UUID other$labelId = other.getLabelId();
        if (this$labelId == null ? other$labelId != null : !((Object)this$labelId).equals(other$labelId)) {
            return false;
        }
        Map<UUID, String> this$errors = this.getErrors();
        Map<UUID, String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<CountReportLabelParam> this$reportLabelParams = this.getReportLabelParams();
        List<CountReportLabelParam> other$reportLabelParams = other.getReportLabelParams();
        return !(this$reportLabelParams == null ? other$reportLabelParams != null : !((Object)this$reportLabelParams).equals(other$reportLabelParams));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LabelTemplateTreeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPassedRate();
        result = result * 59 + this.getFailedRate();
        result = result * 59 + this.getWarningRate();
        result = result * 59 + this.getTestRunCount();
        result = result * 59 + this.getTestRunPassedCount();
        UUID $labelId = this.getLabelId();
        result = result * 59 + ($labelId == null ? 43 : ((Object)$labelId).hashCode());
        Map<UUID, String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<CountReportLabelParam> $reportLabelParams = this.getReportLabelParams();
        result = result * 59 + ($reportLabelParams == null ? 43 : ((Object)$reportLabelParams).hashCode());
        return result;
    }

    public LabelTemplateTreeNode() {
    }
}

