/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.enums;

import java.util.Arrays;
import java.util.List;
import org.qubership.atp.ram.enums.MonitoringSystem;

public enum SystemStatus {
    NOTHING(MonitoringSystem.HEALTHCHECK),
    PASS(MonitoringSystem.HEALTHCHECK),
    WARN(MonitoringSystem.HEALTHCHECK),
    FAIL(MonitoringSystem.HEALTHCHECK),
    GREEN("GOOD", MonitoringSystem.SSM),
    RED("ERROR", MonitoringSystem.SSM),
    AMBER("WARNING", MonitoringSystem.SSM),
    UNKNOWN(MonitoringSystem.SSM);

    private List<MonitoringSystem> monitoringSystems;
    private String techName;

    private SystemStatus(MonitoringSystem ... monitoringSystems) {
        this.monitoringSystems = Arrays.asList(monitoringSystems);
    }

    private SystemStatus(String techName, MonitoringSystem ... monitoringSystems) {
        this.techName = techName;
        this.monitoringSystems = Arrays.asList(monitoringSystems);
    }

    public static SystemStatus findByValue(String strValue) {
        for (SystemStatus v : SystemStatus.values()) {
            if (!v.name().equalsIgnoreCase(strValue)) continue;
            return v;
        }
        return null;
    }

    public String getTechName() {
        return this.techName;
    }
}

