/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.models.RamObject;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@JsonIgnoreProperties(ignoreUnknown=true)
@Document(collection="executionRequests")
@CompoundIndexes(value={@CompoundIndex(name="_id_testPlanId", def="{'_id': 1, 'testPlanId': 1}"), @CompoundIndex(name="projectId_executionStatus_finishDate", def="{'projectId': 1, 'executionStatus': 1, 'finishDate': 1}")})
public class ExecutionRequest
extends RamObject {
    public static final String EXECUTION_STATUS_FIELD = "executionStatus";
    public static final String TEST_PLAN_ID_FIELD = "testPlanId";
    public static final String ANALYZED_BY_QA_FIELD = "analyzedByQa";
    public static final String START_DATE_FIELD = "startDate";
    public static final String PASSED_RATE_FIELD = "passedRate";
    public static final String WARNING_RATE_FIELD = "warningRate";
    public static final String FAILED_RATE_FIELD = "failedRate";
    public static final String ENVIRONMENT_ID = "environmentId";
    public static final String PROJECT_ID = "projectId";
    public static final String INITIAL_EXECUTION_REQUEST_ID = "initialExecutionRequestId";
    private UUID previousExecutionRequestId;
    @Field(value="projectId")
    private UUID projectId;
    @Field(value="testPlanId")
    private UUID testPlanId;
    @Field(value="executionStatus")
    private ExecutionStatuses executionStatus;
    @Field(value="analyzedByQa")
    private boolean analyzedByQa;
    @Field(value="passedRate")
    private int passedRate;
    @Field(value="warningRate")
    private int warningRate;
    @Field(value="failedRate")
    private int failedRate;
    private int countOfTestRuns;
    private String solutionBuild;
    @Field(value="startDate")
    @Indexed(background=true)
    private Timestamp startDate;
    private Timestamp finishDate;
    private long duration;
    private String legacyMailRecipients;
    private String ciJobUrl;
    private UUID testScopeId;
    @Field(value="environmentId")
    private UUID environmentId;
    private UUID taToolsGroupId;
    private List<UUID> labels;
    private UUID executorId;
    private String executorName;
    private UUID labelTemplateId;
    private UUID widgetConfigTemplateId;
    private int threads;
    private int numberOfStarts;
    private boolean autoSyncCasesWithJira;
    private boolean autoSyncRunsWithJira;
    private UUID emailTemplateId;
    private String emailSubject;
    private UUID logCollectorConditionId;
    private Set<UUID> flagIds;
    private Long countLogRecords;
    private Set<UUID> filteredByLabels;
    private int failedLogrecordsCounter;
    private String jointExecutionKey;
    private Integer jointExecutionCount;
    private Integer jointExecutionTimeout;
    @Field(value="initialExecutionRequestId")
    private UUID initialExecutionRequestId;
    private boolean virtual;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionRequest)) {
            return false;
        }
        ExecutionRequest other = (ExecutionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAnalyzedByQa() != other.isAnalyzedByQa()) {
            return false;
        }
        if (this.getPassedRate() != other.getPassedRate()) {
            return false;
        }
        if (this.getWarningRate() != other.getWarningRate()) {
            return false;
        }
        if (this.getFailedRate() != other.getFailedRate()) {
            return false;
        }
        if (this.getCountOfTestRuns() != other.getCountOfTestRuns()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getNumberOfStarts() != other.getNumberOfStarts()) {
            return false;
        }
        if (this.isAutoSyncCasesWithJira() != other.isAutoSyncCasesWithJira()) {
            return false;
        }
        if (this.isAutoSyncRunsWithJira() != other.isAutoSyncRunsWithJira()) {
            return false;
        }
        if (this.getFailedLogrecordsCounter() != other.getFailedLogrecordsCounter()) {
            return false;
        }
        if (this.isVirtual() != other.isVirtual()) {
            return false;
        }
        Long this$countLogRecords = this.getCountLogRecords();
        Long other$countLogRecords = other.getCountLogRecords();
        if (this$countLogRecords == null ? other$countLogRecords != null : !((Object)this$countLogRecords).equals(other$countLogRecords)) {
            return false;
        }
        Integer this$jointExecutionCount = this.getJointExecutionCount();
        Integer other$jointExecutionCount = other.getJointExecutionCount();
        if (this$jointExecutionCount == null ? other$jointExecutionCount != null : !((Object)this$jointExecutionCount).equals(other$jointExecutionCount)) {
            return false;
        }
        Integer this$jointExecutionTimeout = this.getJointExecutionTimeout();
        Integer other$jointExecutionTimeout = other.getJointExecutionTimeout();
        if (this$jointExecutionTimeout == null ? other$jointExecutionTimeout != null : !((Object)this$jointExecutionTimeout).equals(other$jointExecutionTimeout)) {
            return false;
        }
        UUID this$previousExecutionRequestId = this.getPreviousExecutionRequestId();
        UUID other$previousExecutionRequestId = other.getPreviousExecutionRequestId();
        if (this$previousExecutionRequestId == null ? other$previousExecutionRequestId != null : !((Object)this$previousExecutionRequestId).equals(other$previousExecutionRequestId)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        UUID this$testPlanId = this.getTestPlanId();
        UUID other$testPlanId = other.getTestPlanId();
        if (this$testPlanId == null ? other$testPlanId != null : !((Object)this$testPlanId).equals(other$testPlanId)) {
            return false;
        }
        ExecutionStatuses this$executionStatus = this.getExecutionStatus();
        ExecutionStatuses other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        String this$solutionBuild = this.getSolutionBuild();
        String other$solutionBuild = other.getSolutionBuild();
        if (this$solutionBuild == null ? other$solutionBuild != null : !this$solutionBuild.equals(other$solutionBuild)) {
            return false;
        }
        Timestamp this$startDate = this.getStartDate();
        Timestamp other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Timestamp this$finishDate = this.getFinishDate();
        Timestamp other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !((Object)this$finishDate).equals(other$finishDate)) {
            return false;
        }
        String this$legacyMailRecipients = this.getLegacyMailRecipients();
        String other$legacyMailRecipients = other.getLegacyMailRecipients();
        if (this$legacyMailRecipients == null ? other$legacyMailRecipients != null : !this$legacyMailRecipients.equals(other$legacyMailRecipients)) {
            return false;
        }
        String this$ciJobUrl = this.getCiJobUrl();
        String other$ciJobUrl = other.getCiJobUrl();
        if (this$ciJobUrl == null ? other$ciJobUrl != null : !this$ciJobUrl.equals(other$ciJobUrl)) {
            return false;
        }
        UUID this$testScopeId = this.getTestScopeId();
        UUID other$testScopeId = other.getTestScopeId();
        if (this$testScopeId == null ? other$testScopeId != null : !((Object)this$testScopeId).equals(other$testScopeId)) {
            return false;
        }
        UUID this$environmentId = this.getEnvironmentId();
        UUID other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !((Object)this$environmentId).equals(other$environmentId)) {
            return false;
        }
        UUID this$taToolsGroupId = this.getTaToolsGroupId();
        UUID other$taToolsGroupId = other.getTaToolsGroupId();
        if (this$taToolsGroupId == null ? other$taToolsGroupId != null : !((Object)this$taToolsGroupId).equals(other$taToolsGroupId)) {
            return false;
        }
        List<UUID> this$labels = this.getLabels();
        List<UUID> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        UUID this$executorId = this.getExecutorId();
        UUID other$executorId = other.getExecutorId();
        if (this$executorId == null ? other$executorId != null : !((Object)this$executorId).equals(other$executorId)) {
            return false;
        }
        String this$executorName = this.getExecutorName();
        String other$executorName = other.getExecutorName();
        if (this$executorName == null ? other$executorName != null : !this$executorName.equals(other$executorName)) {
            return false;
        }
        UUID this$labelTemplateId = this.getLabelTemplateId();
        UUID other$labelTemplateId = other.getLabelTemplateId();
        if (this$labelTemplateId == null ? other$labelTemplateId != null : !((Object)this$labelTemplateId).equals(other$labelTemplateId)) {
            return false;
        }
        UUID this$widgetConfigTemplateId = this.getWidgetConfigTemplateId();
        UUID other$widgetConfigTemplateId = other.getWidgetConfigTemplateId();
        if (this$widgetConfigTemplateId == null ? other$widgetConfigTemplateId != null : !((Object)this$widgetConfigTemplateId).equals(other$widgetConfigTemplateId)) {
            return false;
        }
        UUID this$emailTemplateId = this.getEmailTemplateId();
        UUID other$emailTemplateId = other.getEmailTemplateId();
        if (this$emailTemplateId == null ? other$emailTemplateId != null : !((Object)this$emailTemplateId).equals(other$emailTemplateId)) {
            return false;
        }
        String this$emailSubject = this.getEmailSubject();
        String other$emailSubject = other.getEmailSubject();
        if (this$emailSubject == null ? other$emailSubject != null : !this$emailSubject.equals(other$emailSubject)) {
            return false;
        }
        UUID this$logCollectorConditionId = this.getLogCollectorConditionId();
        UUID other$logCollectorConditionId = other.getLogCollectorConditionId();
        if (this$logCollectorConditionId == null ? other$logCollectorConditionId != null : !((Object)this$logCollectorConditionId).equals(other$logCollectorConditionId)) {
            return false;
        }
        Set<UUID> this$flagIds = this.getFlagIds();
        Set<UUID> other$flagIds = other.getFlagIds();
        if (this$flagIds == null ? other$flagIds != null : !((Object)this$flagIds).equals(other$flagIds)) {
            return false;
        }
        Set<UUID> this$filteredByLabels = this.getFilteredByLabels();
        Set<UUID> other$filteredByLabels = other.getFilteredByLabels();
        if (this$filteredByLabels == null ? other$filteredByLabels != null : !((Object)this$filteredByLabels).equals(other$filteredByLabels)) {
            return false;
        }
        String this$jointExecutionKey = this.getJointExecutionKey();
        String other$jointExecutionKey = other.getJointExecutionKey();
        if (this$jointExecutionKey == null ? other$jointExecutionKey != null : !this$jointExecutionKey.equals(other$jointExecutionKey)) {
            return false;
        }
        UUID this$initialExecutionRequestId = this.getInitialExecutionRequestId();
        UUID other$initialExecutionRequestId = other.getInitialExecutionRequestId();
        return !(this$initialExecutionRequestId == null ? other$initialExecutionRequestId != null : !((Object)this$initialExecutionRequestId).equals(other$initialExecutionRequestId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAnalyzedByQa() ? 79 : 97);
        result = result * 59 + this.getPassedRate();
        result = result * 59 + this.getWarningRate();
        result = result * 59 + this.getFailedRate();
        result = result * 59 + this.getCountOfTestRuns();
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getNumberOfStarts();
        result = result * 59 + (this.isAutoSyncCasesWithJira() ? 79 : 97);
        result = result * 59 + (this.isAutoSyncRunsWithJira() ? 79 : 97);
        result = result * 59 + this.getFailedLogrecordsCounter();
        result = result * 59 + (this.isVirtual() ? 79 : 97);
        Long $countLogRecords = this.getCountLogRecords();
        result = result * 59 + ($countLogRecords == null ? 43 : ((Object)$countLogRecords).hashCode());
        Integer $jointExecutionCount = this.getJointExecutionCount();
        result = result * 59 + ($jointExecutionCount == null ? 43 : ((Object)$jointExecutionCount).hashCode());
        Integer $jointExecutionTimeout = this.getJointExecutionTimeout();
        result = result * 59 + ($jointExecutionTimeout == null ? 43 : ((Object)$jointExecutionTimeout).hashCode());
        UUID $previousExecutionRequestId = this.getPreviousExecutionRequestId();
        result = result * 59 + ($previousExecutionRequestId == null ? 43 : ((Object)$previousExecutionRequestId).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        UUID $testPlanId = this.getTestPlanId();
        result = result * 59 + ($testPlanId == null ? 43 : ((Object)$testPlanId).hashCode());
        ExecutionStatuses $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        String $solutionBuild = this.getSolutionBuild();
        result = result * 59 + ($solutionBuild == null ? 43 : $solutionBuild.hashCode());
        Timestamp $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Timestamp $finishDate = this.getFinishDate();
        result = result * 59 + ($finishDate == null ? 43 : ((Object)$finishDate).hashCode());
        String $legacyMailRecipients = this.getLegacyMailRecipients();
        result = result * 59 + ($legacyMailRecipients == null ? 43 : $legacyMailRecipients.hashCode());
        String $ciJobUrl = this.getCiJobUrl();
        result = result * 59 + ($ciJobUrl == null ? 43 : $ciJobUrl.hashCode());
        UUID $testScopeId = this.getTestScopeId();
        result = result * 59 + ($testScopeId == null ? 43 : ((Object)$testScopeId).hashCode());
        UUID $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : ((Object)$environmentId).hashCode());
        UUID $taToolsGroupId = this.getTaToolsGroupId();
        result = result * 59 + ($taToolsGroupId == null ? 43 : ((Object)$taToolsGroupId).hashCode());
        List<UUID> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        UUID $executorId = this.getExecutorId();
        result = result * 59 + ($executorId == null ? 43 : ((Object)$executorId).hashCode());
        String $executorName = this.getExecutorName();
        result = result * 59 + ($executorName == null ? 43 : $executorName.hashCode());
        UUID $labelTemplateId = this.getLabelTemplateId();
        result = result * 59 + ($labelTemplateId == null ? 43 : ((Object)$labelTemplateId).hashCode());
        UUID $widgetConfigTemplateId = this.getWidgetConfigTemplateId();
        result = result * 59 + ($widgetConfigTemplateId == null ? 43 : ((Object)$widgetConfigTemplateId).hashCode());
        UUID $emailTemplateId = this.getEmailTemplateId();
        result = result * 59 + ($emailTemplateId == null ? 43 : ((Object)$emailTemplateId).hashCode());
        String $emailSubject = this.getEmailSubject();
        result = result * 59 + ($emailSubject == null ? 43 : $emailSubject.hashCode());
        UUID $logCollectorConditionId = this.getLogCollectorConditionId();
        result = result * 59 + ($logCollectorConditionId == null ? 43 : ((Object)$logCollectorConditionId).hashCode());
        Set<UUID> $flagIds = this.getFlagIds();
        result = result * 59 + ($flagIds == null ? 43 : ((Object)$flagIds).hashCode());
        Set<UUID> $filteredByLabels = this.getFilteredByLabels();
        result = result * 59 + ($filteredByLabels == null ? 43 : ((Object)$filteredByLabels).hashCode());
        String $jointExecutionKey = this.getJointExecutionKey();
        result = result * 59 + ($jointExecutionKey == null ? 43 : $jointExecutionKey.hashCode());
        UUID $initialExecutionRequestId = this.getInitialExecutionRequestId();
        result = result * 59 + ($initialExecutionRequestId == null ? 43 : ((Object)$initialExecutionRequestId).hashCode());
        return result;
    }

    public UUID getPreviousExecutionRequestId() {
        return this.previousExecutionRequestId;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getTestPlanId() {
        return this.testPlanId;
    }

    public ExecutionStatuses getExecutionStatus() {
        return this.executionStatus;
    }

    public boolean isAnalyzedByQa() {
        return this.analyzedByQa;
    }

    public int getPassedRate() {
        return this.passedRate;
    }

    public int getWarningRate() {
        return this.warningRate;
    }

    public int getFailedRate() {
        return this.failedRate;
    }

    public int getCountOfTestRuns() {
        return this.countOfTestRuns;
    }

    public String getSolutionBuild() {
        return this.solutionBuild;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getFinishDate() {
        return this.finishDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getLegacyMailRecipients() {
        return this.legacyMailRecipients;
    }

    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    public UUID getTestScopeId() {
        return this.testScopeId;
    }

    public UUID getEnvironmentId() {
        return this.environmentId;
    }

    public UUID getTaToolsGroupId() {
        return this.taToolsGroupId;
    }

    public List<UUID> getLabels() {
        return this.labels;
    }

    public UUID getExecutorId() {
        return this.executorId;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public UUID getLabelTemplateId() {
        return this.labelTemplateId;
    }

    public UUID getWidgetConfigTemplateId() {
        return this.widgetConfigTemplateId;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getNumberOfStarts() {
        return this.numberOfStarts;
    }

    public boolean isAutoSyncCasesWithJira() {
        return this.autoSyncCasesWithJira;
    }

    public boolean isAutoSyncRunsWithJira() {
        return this.autoSyncRunsWithJira;
    }

    public UUID getEmailTemplateId() {
        return this.emailTemplateId;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public UUID getLogCollectorConditionId() {
        return this.logCollectorConditionId;
    }

    public Set<UUID> getFlagIds() {
        return this.flagIds;
    }

    public Long getCountLogRecords() {
        return this.countLogRecords;
    }

    public Set<UUID> getFilteredByLabels() {
        return this.filteredByLabels;
    }

    public int getFailedLogrecordsCounter() {
        return this.failedLogrecordsCounter;
    }

    public String getJointExecutionKey() {
        return this.jointExecutionKey;
    }

    public Integer getJointExecutionCount() {
        return this.jointExecutionCount;
    }

    public Integer getJointExecutionTimeout() {
        return this.jointExecutionTimeout;
    }

    public UUID getInitialExecutionRequestId() {
        return this.initialExecutionRequestId;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setPreviousExecutionRequestId(UUID previousExecutionRequestId) {
        this.previousExecutionRequestId = previousExecutionRequestId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setTestPlanId(UUID testPlanId) {
        this.testPlanId = testPlanId;
    }

    public void setExecutionStatus(ExecutionStatuses executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setAnalyzedByQa(boolean analyzedByQa) {
        this.analyzedByQa = analyzedByQa;
    }

    public void setPassedRate(int passedRate) {
        this.passedRate = passedRate;
    }

    public void setWarningRate(int warningRate) {
        this.warningRate = warningRate;
    }

    public void setFailedRate(int failedRate) {
        this.failedRate = failedRate;
    }

    public void setCountOfTestRuns(int countOfTestRuns) {
        this.countOfTestRuns = countOfTestRuns;
    }

    public void setSolutionBuild(String solutionBuild) {
        this.solutionBuild = solutionBuild;
    }

    public void setStartDate(Timestamp startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(Timestamp finishDate) {
        this.finishDate = finishDate;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setLegacyMailRecipients(String legacyMailRecipients) {
        this.legacyMailRecipients = legacyMailRecipients;
    }

    public void setCiJobUrl(String ciJobUrl) {
        this.ciJobUrl = ciJobUrl;
    }

    public void setTestScopeId(UUID testScopeId) {
        this.testScopeId = testScopeId;
    }

    public void setEnvironmentId(UUID environmentId) {
        this.environmentId = environmentId;
    }

    public void setTaToolsGroupId(UUID taToolsGroupId) {
        this.taToolsGroupId = taToolsGroupId;
    }

    public void setLabels(List<UUID> labels) {
        this.labels = labels;
    }

    public void setExecutorId(UUID executorId) {
        this.executorId = executorId;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public void setLabelTemplateId(UUID labelTemplateId) {
        this.labelTemplateId = labelTemplateId;
    }

    public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
        this.widgetConfigTemplateId = widgetConfigTemplateId;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setNumberOfStarts(int numberOfStarts) {
        this.numberOfStarts = numberOfStarts;
    }

    public void setAutoSyncCasesWithJira(boolean autoSyncCasesWithJira) {
        this.autoSyncCasesWithJira = autoSyncCasesWithJira;
    }

    public void setAutoSyncRunsWithJira(boolean autoSyncRunsWithJira) {
        this.autoSyncRunsWithJira = autoSyncRunsWithJira;
    }

    public void setEmailTemplateId(UUID emailTemplateId) {
        this.emailTemplateId = emailTemplateId;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public void setLogCollectorConditionId(UUID logCollectorConditionId) {
        this.logCollectorConditionId = logCollectorConditionId;
    }

    public void setFlagIds(Set<UUID> flagIds) {
        this.flagIds = flagIds;
    }

    public void setCountLogRecords(Long countLogRecords) {
        this.countLogRecords = countLogRecords;
    }

    public void setFilteredByLabels(Set<UUID> filteredByLabels) {
        this.filteredByLabels = filteredByLabels;
    }

    public void setFailedLogrecordsCounter(int failedLogrecordsCounter) {
        this.failedLogrecordsCounter = failedLogrecordsCounter;
    }

    public void setJointExecutionKey(String jointExecutionKey) {
        this.jointExecutionKey = jointExecutionKey;
    }

    public void setJointExecutionCount(Integer jointExecutionCount) {
        this.jointExecutionCount = jointExecutionCount;
    }

    public void setJointExecutionTimeout(Integer jointExecutionTimeout) {
        this.jointExecutionTimeout = jointExecutionTimeout;
    }

    public void setInitialExecutionRequestId(UUID initialExecutionRequestId) {
        this.initialExecutionRequestId = initialExecutionRequestId;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    @Override
    public String toString() {
        return "ExecutionRequest(previousExecutionRequestId=" + this.getPreviousExecutionRequestId() + ", projectId=" + this.getProjectId() + ", testPlanId=" + this.getTestPlanId() + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", analyzedByQa=" + this.isAnalyzedByQa() + ", passedRate=" + this.getPassedRate() + ", warningRate=" + this.getWarningRate() + ", failedRate=" + this.getFailedRate() + ", countOfTestRuns=" + this.getCountOfTestRuns() + ", solutionBuild=" + this.getSolutionBuild() + ", startDate=" + this.getStartDate() + ", finishDate=" + this.getFinishDate() + ", duration=" + this.getDuration() + ", legacyMailRecipients=" + this.getLegacyMailRecipients() + ", ciJobUrl=" + this.getCiJobUrl() + ", testScopeId=" + this.getTestScopeId() + ", environmentId=" + this.getEnvironmentId() + ", taToolsGroupId=" + this.getTaToolsGroupId() + ", labels=" + this.getLabels() + ", executorId=" + this.getExecutorId() + ", executorName=" + this.getExecutorName() + ", labelTemplateId=" + this.getLabelTemplateId() + ", widgetConfigTemplateId=" + this.getWidgetConfigTemplateId() + ", threads=" + this.getThreads() + ", numberOfStarts=" + this.getNumberOfStarts() + ", autoSyncCasesWithJira=" + this.isAutoSyncCasesWithJira() + ", autoSyncRunsWithJira=" + this.isAutoSyncRunsWithJira() + ", emailTemplateId=" + this.getEmailTemplateId() + ", emailSubject=" + this.getEmailSubject() + ", logCollectorConditionId=" + this.getLogCollectorConditionId() + ", flagIds=" + this.getFlagIds() + ", countLogRecords=" + this.getCountLogRecords() + ", filteredByLabels=" + this.getFilteredByLabels() + ", failedLogrecordsCounter=" + this.getFailedLogrecordsCounter() + ", jointExecutionKey=" + this.getJointExecutionKey() + ", jointExecutionCount=" + this.getJointExecutionCount() + ", jointExecutionTimeout=" + this.getJointExecutionTimeout() + ", initialExecutionRequestId=" + this.getInitialExecutionRequestId() + ", virtual=" + this.isVirtual() + ")";
    }
}

