/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.ram.models.DateAuditorEntity;
import org.qubership.atp.ram.models.RootCauseType;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="rootCause")
@CompoundIndex(name="_id_parentId", def="{'_id': 1, 'parentId': 1}")
@TypeName(value="rootCause")
public class RootCause
extends DateAuditorEntity {
    private UUID parentId;
    private UUID projectId;
    @NotNull
    @DiffInclude
    private RootCauseType type;
    @DiffInclude
    private boolean disabled;
    private boolean isDefault;

    public RootCause(UUID uuid, RootCauseType type, String name) {
        this.name = name;
        this.uuid = uuid;
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RootCause)) {
            return false;
        }
        RootCause other = (RootCause)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isDefault() != other.isDefault()) {
            return false;
        }
        UUID this$parentId = this.getParentId();
        UUID other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !((Object)this$parentId).equals(other$parentId)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        RootCauseType this$type = this.getType();
        RootCauseType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RootCause;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isDefault() ? 79 : 97);
        UUID $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : ((Object)$parentId).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        RootCauseType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public UUID getParentId() {
        return this.parentId;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public RootCauseType getType() {
        return this.type;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setParentId(UUID parentId) {
        this.parentId = parentId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setType(RootCauseType type) {
        this.type = type;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public RootCause() {
    }

    @Override
    public String toString() {
        return "RootCause(super=" + super.toString() + ", parentId=" + this.getParentId() + ", projectId=" + this.getProjectId() + ", type=" + (Object)((Object)this.getType()) + ", disabled=" + this.isDisabled() + ", isDefault=" + this.isDefault() + ")";
    }
}

