/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.Flags;
import org.qubership.atp.ram.enums.TestScopeSections;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.Comment;
import org.qubership.atp.ram.models.MetaInfo;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRunStatistic;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@JsonIgnoreProperties(ignoreUnknown=true)
@Document(collection="testrun")
@CompoundIndexes(value={@CompoundIndex(name="_id_executionRequestId", def="{'_id': 1, 'executionRequestId': 1}"), @CompoundIndex(name="_id_parentTestRunId", def="{'_id': 1, 'parentTestRunId': 1}"), @CompoundIndex(name="testCaseId_startDateDesc", def="{ 'testCaseId': 1, 'startDate': -1 }")})
public class TestRun
extends RamObject {
    public static final String TEST_RUN_JSON_FILTER_NAME = "Test run Json Filter";
    private UUID parentTestRunId;
    private boolean isGroupedTestRun;
    @Indexed
    private UUID executionRequestId;
    @Indexed(background=true)
    private UUID testCaseId;
    private String testCaseName;
    private ExecutionStatuses executionStatus;
    private TestingStatuses testingStatus = TestingStatuses.UNKNOWN;
    private Timestamp startDate;
    private Timestamp finishDate;
    @CreatedDate
    private Timestamp createdDate;
    private long duration;
    private String executor;
    private String jiraTicket;
    private List<String> taHost = new ArrayList<String>();
    private List<String> qaHost = new ArrayList<String>();
    private List<String> solutionBuild = new ArrayList<String>();
    private UUID rootCauseId;
    private String dataSetUrl;
    private List<Flags> flags;
    private String dataSetListUrl;
    private String logCollectorData;
    private boolean fdrWasSent;
    private String fdrLink;
    private int numberOfScreens;
    private Set<String> urlToBrowserOrLogs;
    private String urlToBrowserSession;
    private int passedRate;
    private int warningRate;
    private int failedRate;
    private Comment comment;
    private MetaInfo metaInfo;
    private TestRunStatistic statistic;
    private TestScopeSections testScopeSection;
    private int order;
    private Set<UUID> labelIds;
    private List<String> browserNames;
    private boolean isFinalTestRun;
    private UUID initialTestRunId;

    public boolean isFinalTestRun() {
        return this.isFinalTestRun;
    }

    public Boolean getIsFinalTestRun() {
        return this.isFinalTestRun;
    }

    public void updateTestingStatus(TestingStatuses testingStatus) {
        if (this.testingStatus == null) {
            this.testingStatus = testingStatus;
            return;
        }
        if (Objects.nonNull((Object)testingStatus)) {
            this.testingStatus = TestingStatuses.compareAndGetPriority(this.testingStatus, testingStatus);
        }
    }

    public void setTestingStatus(TestingStatuses testingStatus) {
        this.testingStatus = testingStatus;
    }

    public void addNumberOfScreens() {
        ++this.numberOfScreens;
    }

    public void addUrlToBrowserOrLogs(String urlToBrowserOrLogs) {
        if (this.urlToBrowserOrLogs == null) {
            this.urlToBrowserOrLogs = new HashSet<String>();
        }
        this.urlToBrowserOrLogs.add(urlToBrowserOrLogs);
    }

    public Set<UUID> getLabelIds() {
        return Objects.isNull(this.labelIds) ? new HashSet() : this.labelIds;
    }

    public TestRun isGroupedTestRun(Boolean isGroupedTestRun) {
        this.isGroupedTestRun = isGroupedTestRun;
        return this;
    }

    public boolean isGroupedTestRun() {
        return this.isGroupedTestRun;
    }

    public Boolean getIsGroupedTestRun() {
        return this.isGroupedTestRun;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRun)) {
            return false;
        }
        TestRun other = (TestRun)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isGroupedTestRun = this.getIsGroupedTestRun();
        Boolean other$isGroupedTestRun = other.getIsGroupedTestRun();
        if (this$isGroupedTestRun == null ? other$isGroupedTestRun != null : !((Object)this$isGroupedTestRun).equals(other$isGroupedTestRun)) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isFdrWasSent() != other.isFdrWasSent()) {
            return false;
        }
        if (this.getNumberOfScreens() != other.getNumberOfScreens()) {
            return false;
        }
        if (this.getPassedRate() != other.getPassedRate()) {
            return false;
        }
        if (this.getWarningRate() != other.getWarningRate()) {
            return false;
        }
        if (this.getFailedRate() != other.getFailedRate()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isFinalTestRun() != other.isFinalTestRun()) {
            return false;
        }
        UUID this$parentTestRunId = this.getParentTestRunId();
        UUID other$parentTestRunId = other.getParentTestRunId();
        if (this$parentTestRunId == null ? other$parentTestRunId != null : !((Object)this$parentTestRunId).equals(other$parentTestRunId)) {
            return false;
        }
        UUID this$executionRequestId = this.getExecutionRequestId();
        UUID other$executionRequestId = other.getExecutionRequestId();
        if (this$executionRequestId == null ? other$executionRequestId != null : !((Object)this$executionRequestId).equals(other$executionRequestId)) {
            return false;
        }
        UUID this$testCaseId = this.getTestCaseId();
        UUID other$testCaseId = other.getTestCaseId();
        if (this$testCaseId == null ? other$testCaseId != null : !((Object)this$testCaseId).equals(other$testCaseId)) {
            return false;
        }
        String this$testCaseName = this.getTestCaseName();
        String other$testCaseName = other.getTestCaseName();
        if (this$testCaseName == null ? other$testCaseName != null : !this$testCaseName.equals(other$testCaseName)) {
            return false;
        }
        ExecutionStatuses this$executionStatus = this.getExecutionStatus();
        ExecutionStatuses other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        TestingStatuses this$testingStatus = this.getTestingStatus();
        TestingStatuses other$testingStatus = other.getTestingStatus();
        if (this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus)) {
            return false;
        }
        Timestamp this$startDate = this.getStartDate();
        Timestamp other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Timestamp this$finishDate = this.getFinishDate();
        Timestamp other$finishDate = other.getFinishDate();
        if (this$finishDate == null ? other$finishDate != null : !((Object)this$finishDate).equals(other$finishDate)) {
            return false;
        }
        Timestamp this$createdDate = this.getCreatedDate();
        Timestamp other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        String this$executor = this.getExecutor();
        String other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        String this$jiraTicket = this.getJiraTicket();
        String other$jiraTicket = other.getJiraTicket();
        if (this$jiraTicket == null ? other$jiraTicket != null : !this$jiraTicket.equals(other$jiraTicket)) {
            return false;
        }
        List<String> this$taHost = this.getTaHost();
        List<String> other$taHost = other.getTaHost();
        if (this$taHost == null ? other$taHost != null : !((Object)this$taHost).equals(other$taHost)) {
            return false;
        }
        List<String> this$qaHost = this.getQaHost();
        List<String> other$qaHost = other.getQaHost();
        if (this$qaHost == null ? other$qaHost != null : !((Object)this$qaHost).equals(other$qaHost)) {
            return false;
        }
        List<String> this$solutionBuild = this.getSolutionBuild();
        List<String> other$solutionBuild = other.getSolutionBuild();
        if (this$solutionBuild == null ? other$solutionBuild != null : !((Object)this$solutionBuild).equals(other$solutionBuild)) {
            return false;
        }
        UUID this$rootCauseId = this.getRootCauseId();
        UUID other$rootCauseId = other.getRootCauseId();
        if (this$rootCauseId == null ? other$rootCauseId != null : !((Object)this$rootCauseId).equals(other$rootCauseId)) {
            return false;
        }
        String this$dataSetUrl = this.getDataSetUrl();
        String other$dataSetUrl = other.getDataSetUrl();
        if (this$dataSetUrl == null ? other$dataSetUrl != null : !this$dataSetUrl.equals(other$dataSetUrl)) {
            return false;
        }
        List<Flags> this$flags = this.getFlags();
        List<Flags> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        String this$dataSetListUrl = this.getDataSetListUrl();
        String other$dataSetListUrl = other.getDataSetListUrl();
        if (this$dataSetListUrl == null ? other$dataSetListUrl != null : !this$dataSetListUrl.equals(other$dataSetListUrl)) {
            return false;
        }
        String this$logCollectorData = this.getLogCollectorData();
        String other$logCollectorData = other.getLogCollectorData();
        if (this$logCollectorData == null ? other$logCollectorData != null : !this$logCollectorData.equals(other$logCollectorData)) {
            return false;
        }
        String this$fdrLink = this.getFdrLink();
        String other$fdrLink = other.getFdrLink();
        if (this$fdrLink == null ? other$fdrLink != null : !this$fdrLink.equals(other$fdrLink)) {
            return false;
        }
        Set<String> this$urlToBrowserOrLogs = this.getUrlToBrowserOrLogs();
        Set<String> other$urlToBrowserOrLogs = other.getUrlToBrowserOrLogs();
        if (this$urlToBrowserOrLogs == null ? other$urlToBrowserOrLogs != null : !((Object)this$urlToBrowserOrLogs).equals(other$urlToBrowserOrLogs)) {
            return false;
        }
        String this$urlToBrowserSession = this.getUrlToBrowserSession();
        String other$urlToBrowserSession = other.getUrlToBrowserSession();
        if (this$urlToBrowserSession == null ? other$urlToBrowserSession != null : !this$urlToBrowserSession.equals(other$urlToBrowserSession)) {
            return false;
        }
        Comment this$comment = this.getComment();
        Comment other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !((Object)this$comment).equals(other$comment)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        TestRunStatistic this$statistic = this.getStatistic();
        TestRunStatistic other$statistic = other.getStatistic();
        if (this$statistic == null ? other$statistic != null : !((Object)this$statistic).equals(other$statistic)) {
            return false;
        }
        TestScopeSections this$testScopeSection = this.getTestScopeSection();
        TestScopeSections other$testScopeSection = other.getTestScopeSection();
        if (this$testScopeSection == null ? other$testScopeSection != null : !((Object)((Object)this$testScopeSection)).equals((Object)other$testScopeSection)) {
            return false;
        }
        Set<UUID> this$labelIds = this.getLabelIds();
        Set<UUID> other$labelIds = other.getLabelIds();
        if (this$labelIds == null ? other$labelIds != null : !((Object)this$labelIds).equals(other$labelIds)) {
            return false;
        }
        List<String> this$browserNames = this.getBrowserNames();
        List<String> other$browserNames = other.getBrowserNames();
        if (this$browserNames == null ? other$browserNames != null : !((Object)this$browserNames).equals(other$browserNames)) {
            return false;
        }
        UUID this$initialTestRunId = this.getInitialTestRunId();
        UUID other$initialTestRunId = other.getInitialTestRunId();
        return !(this$initialTestRunId == null ? other$initialTestRunId != null : !((Object)this$initialTestRunId).equals(other$initialTestRunId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestRun;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isGroupedTestRun = this.getIsGroupedTestRun();
        result = result * 59 + ($isGroupedTestRun == null ? 43 : ((Object)$isGroupedTestRun).hashCode());
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        result = result * 59 + (this.isFdrWasSent() ? 79 : 97);
        result = result * 59 + this.getNumberOfScreens();
        result = result * 59 + this.getPassedRate();
        result = result * 59 + this.getWarningRate();
        result = result * 59 + this.getFailedRate();
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isFinalTestRun() ? 79 : 97);
        UUID $parentTestRunId = this.getParentTestRunId();
        result = result * 59 + ($parentTestRunId == null ? 43 : ((Object)$parentTestRunId).hashCode());
        UUID $executionRequestId = this.getExecutionRequestId();
        result = result * 59 + ($executionRequestId == null ? 43 : ((Object)$executionRequestId).hashCode());
        UUID $testCaseId = this.getTestCaseId();
        result = result * 59 + ($testCaseId == null ? 43 : ((Object)$testCaseId).hashCode());
        String $testCaseName = this.getTestCaseName();
        result = result * 59 + ($testCaseName == null ? 43 : $testCaseName.hashCode());
        ExecutionStatuses $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        TestingStatuses $testingStatus = this.getTestingStatus();
        result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
        Timestamp $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Timestamp $finishDate = this.getFinishDate();
        result = result * 59 + ($finishDate == null ? 43 : ((Object)$finishDate).hashCode());
        Timestamp $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        String $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        String $jiraTicket = this.getJiraTicket();
        result = result * 59 + ($jiraTicket == null ? 43 : $jiraTicket.hashCode());
        List<String> $taHost = this.getTaHost();
        result = result * 59 + ($taHost == null ? 43 : ((Object)$taHost).hashCode());
        List<String> $qaHost = this.getQaHost();
        result = result * 59 + ($qaHost == null ? 43 : ((Object)$qaHost).hashCode());
        List<String> $solutionBuild = this.getSolutionBuild();
        result = result * 59 + ($solutionBuild == null ? 43 : ((Object)$solutionBuild).hashCode());
        UUID $rootCauseId = this.getRootCauseId();
        result = result * 59 + ($rootCauseId == null ? 43 : ((Object)$rootCauseId).hashCode());
        String $dataSetUrl = this.getDataSetUrl();
        result = result * 59 + ($dataSetUrl == null ? 43 : $dataSetUrl.hashCode());
        List<Flags> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        String $dataSetListUrl = this.getDataSetListUrl();
        result = result * 59 + ($dataSetListUrl == null ? 43 : $dataSetListUrl.hashCode());
        String $logCollectorData = this.getLogCollectorData();
        result = result * 59 + ($logCollectorData == null ? 43 : $logCollectorData.hashCode());
        String $fdrLink = this.getFdrLink();
        result = result * 59 + ($fdrLink == null ? 43 : $fdrLink.hashCode());
        Set<String> $urlToBrowserOrLogs = this.getUrlToBrowserOrLogs();
        result = result * 59 + ($urlToBrowserOrLogs == null ? 43 : ((Object)$urlToBrowserOrLogs).hashCode());
        String $urlToBrowserSession = this.getUrlToBrowserSession();
        result = result * 59 + ($urlToBrowserSession == null ? 43 : $urlToBrowserSession.hashCode());
        Comment $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : ((Object)$comment).hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        TestRunStatistic $statistic = this.getStatistic();
        result = result * 59 + ($statistic == null ? 43 : ((Object)$statistic).hashCode());
        TestScopeSections $testScopeSection = this.getTestScopeSection();
        result = result * 59 + ($testScopeSection == null ? 43 : ((Object)((Object)$testScopeSection)).hashCode());
        Set<UUID> $labelIds = this.getLabelIds();
        result = result * 59 + ($labelIds == null ? 43 : ((Object)$labelIds).hashCode());
        List<String> $browserNames = this.getBrowserNames();
        result = result * 59 + ($browserNames == null ? 43 : ((Object)$browserNames).hashCode());
        UUID $initialTestRunId = this.getInitialTestRunId();
        result = result * 59 + ($initialTestRunId == null ? 43 : ((Object)$initialTestRunId).hashCode());
        return result;
    }

    public UUID getParentTestRunId() {
        return this.parentTestRunId;
    }

    public UUID getExecutionRequestId() {
        return this.executionRequestId;
    }

    public UUID getTestCaseId() {
        return this.testCaseId;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public ExecutionStatuses getExecutionStatus() {
        return this.executionStatus;
    }

    public TestingStatuses getTestingStatus() {
        return this.testingStatus;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getFinishDate() {
        return this.finishDate;
    }

    public Timestamp getCreatedDate() {
        return this.createdDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getExecutor() {
        return this.executor;
    }

    public String getJiraTicket() {
        return this.jiraTicket;
    }

    public List<String> getTaHost() {
        return this.taHost;
    }

    public List<String> getQaHost() {
        return this.qaHost;
    }

    public List<String> getSolutionBuild() {
        return this.solutionBuild;
    }

    public UUID getRootCauseId() {
        return this.rootCauseId;
    }

    public String getDataSetUrl() {
        return this.dataSetUrl;
    }

    public List<Flags> getFlags() {
        return this.flags;
    }

    public String getDataSetListUrl() {
        return this.dataSetListUrl;
    }

    public String getLogCollectorData() {
        return this.logCollectorData;
    }

    public boolean isFdrWasSent() {
        return this.fdrWasSent;
    }

    public String getFdrLink() {
        return this.fdrLink;
    }

    public int getNumberOfScreens() {
        return this.numberOfScreens;
    }

    public Set<String> getUrlToBrowserOrLogs() {
        return this.urlToBrowserOrLogs;
    }

    public String getUrlToBrowserSession() {
        return this.urlToBrowserSession;
    }

    public int getPassedRate() {
        return this.passedRate;
    }

    public int getWarningRate() {
        return this.warningRate;
    }

    public int getFailedRate() {
        return this.failedRate;
    }

    public Comment getComment() {
        return this.comment;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public TestRunStatistic getStatistic() {
        return this.statistic;
    }

    public TestScopeSections getTestScopeSection() {
        return this.testScopeSection;
    }

    public int getOrder() {
        return this.order;
    }

    public List<String> getBrowserNames() {
        return this.browserNames;
    }

    public UUID getInitialTestRunId() {
        return this.initialTestRunId;
    }

    public void setParentTestRunId(UUID parentTestRunId) {
        this.parentTestRunId = parentTestRunId;
    }

    public void setGroupedTestRun(boolean isGroupedTestRun) {
        this.isGroupedTestRun = isGroupedTestRun;
    }

    public void setExecutionRequestId(UUID executionRequestId) {
        this.executionRequestId = executionRequestId;
    }

    public void setTestCaseId(UUID testCaseId) {
        this.testCaseId = testCaseId;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public void setExecutionStatus(ExecutionStatuses executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setStartDate(Timestamp startDate) {
        this.startDate = startDate;
    }

    public void setFinishDate(Timestamp finishDate) {
        this.finishDate = finishDate;
    }

    public void setCreatedDate(Timestamp createdDate) {
        this.createdDate = createdDate;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setExecutor(String executor) {
        this.executor = executor;
    }

    public void setJiraTicket(String jiraTicket) {
        this.jiraTicket = jiraTicket;
    }

    public void setTaHost(List<String> taHost) {
        this.taHost = taHost;
    }

    public void setQaHost(List<String> qaHost) {
        this.qaHost = qaHost;
    }

    public void setSolutionBuild(List<String> solutionBuild) {
        this.solutionBuild = solutionBuild;
    }

    public void setRootCauseId(UUID rootCauseId) {
        this.rootCauseId = rootCauseId;
    }

    public void setDataSetUrl(String dataSetUrl) {
        this.dataSetUrl = dataSetUrl;
    }

    public void setFlags(List<Flags> flags) {
        this.flags = flags;
    }

    public void setDataSetListUrl(String dataSetListUrl) {
        this.dataSetListUrl = dataSetListUrl;
    }

    public void setLogCollectorData(String logCollectorData) {
        this.logCollectorData = logCollectorData;
    }

    public void setFdrWasSent(boolean fdrWasSent) {
        this.fdrWasSent = fdrWasSent;
    }

    public void setFdrLink(String fdrLink) {
        this.fdrLink = fdrLink;
    }

    public void setNumberOfScreens(int numberOfScreens) {
        this.numberOfScreens = numberOfScreens;
    }

    public void setUrlToBrowserOrLogs(Set<String> urlToBrowserOrLogs) {
        this.urlToBrowserOrLogs = urlToBrowserOrLogs;
    }

    public void setUrlToBrowserSession(String urlToBrowserSession) {
        this.urlToBrowserSession = urlToBrowserSession;
    }

    public void setPassedRate(int passedRate) {
        this.passedRate = passedRate;
    }

    public void setWarningRate(int warningRate) {
        this.warningRate = warningRate;
    }

    public void setFailedRate(int failedRate) {
        this.failedRate = failedRate;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setStatistic(TestRunStatistic statistic) {
        this.statistic = statistic;
    }

    public void setTestScopeSection(TestScopeSections testScopeSection) {
        this.testScopeSection = testScopeSection;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setLabelIds(Set<UUID> labelIds) {
        this.labelIds = labelIds;
    }

    public void setBrowserNames(List<String> browserNames) {
        this.browserNames = browserNames;
    }

    public void setFinalTestRun(boolean isFinalTestRun) {
        this.isFinalTestRun = isFinalTestRun;
    }

    public void setInitialTestRunId(UUID initialTestRunId) {
        this.initialTestRunId = initialTestRunId;
    }

    @Override
    public String toString() {
        return "TestRun(parentTestRunId=" + this.getParentTestRunId() + ", isGroupedTestRun=" + this.getIsGroupedTestRun() + ", executionRequestId=" + this.getExecutionRequestId() + ", testCaseId=" + this.getTestCaseId() + ", testCaseName=" + this.getTestCaseName() + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ", startDate=" + this.getStartDate() + ", finishDate=" + this.getFinishDate() + ", createdDate=" + this.getCreatedDate() + ", duration=" + this.getDuration() + ", executor=" + this.getExecutor() + ", jiraTicket=" + this.getJiraTicket() + ", taHost=" + this.getTaHost() + ", qaHost=" + this.getQaHost() + ", solutionBuild=" + this.getSolutionBuild() + ", rootCauseId=" + this.getRootCauseId() + ", dataSetUrl=" + this.getDataSetUrl() + ", flags=" + this.getFlags() + ", dataSetListUrl=" + this.getDataSetListUrl() + ", logCollectorData=" + this.getLogCollectorData() + ", fdrWasSent=" + this.isFdrWasSent() + ", fdrLink=" + this.getFdrLink() + ", numberOfScreens=" + this.getNumberOfScreens() + ", urlToBrowserOrLogs=" + this.getUrlToBrowserOrLogs() + ", urlToBrowserSession=" + this.getUrlToBrowserSession() + ", passedRate=" + this.getPassedRate() + ", warningRate=" + this.getWarningRate() + ", failedRate=" + this.getFailedRate() + ", comment=" + this.getComment() + ", metaInfo=" + this.getMetaInfo() + ", statistic=" + this.getStatistic() + ", testScopeSection=" + (Object)((Object)this.getTestScopeSection()) + ", order=" + this.getOrder() + ", labelIds=" + this.getLabelIds() + ", browserNames=" + this.getBrowserNames() + ", isFinalTestRun=" + this.isFinalTestRun() + ", initialTestRunId=" + this.getInitialTestRunId() + ")";
    }
}

