/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.entities.treenodes;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.entities.treenodes.TreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNodeType;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LabelTemplate;

public class ExecutionRequestTreeNode
extends TreeNode {
    private Integer passedRate;
    private UUID labelTemplateId;
    private String labelTemplateName;
    private List<String> validationLabelsOrder = new ArrayList<String>();
    private UUID testScopeId;

    public ExecutionRequestTreeNode(ExecutionRequest executionRequest) {
        this.id = UUID.randomUUID();
        this.executionRequestId = executionRequest.getUuid();
        this.name = executionRequest.getName();
        this.passedRate = Math.round(executionRequest.getPassedRate());
        this.nodeType = TreeNodeType.EXECUTION_REQUEST_NODE;
        this.testScopeId = executionRequest.getTestScopeId();
        this.isExecutionRequestVirtual = executionRequest.isVirtual();
    }

    public void setLabelTemplateData(LabelTemplate labelTemplate) {
        this.labelTemplateId = labelTemplate.getUuid();
        this.labelTemplateName = labelTemplate.getName();
    }

    public Integer getPassedRate() {
        return this.passedRate;
    }

    public UUID getLabelTemplateId() {
        return this.labelTemplateId;
    }

    public String getLabelTemplateName() {
        return this.labelTemplateName;
    }

    public List<String> getValidationLabelsOrder() {
        return this.validationLabelsOrder;
    }

    public UUID getTestScopeId() {
        return this.testScopeId;
    }

    public void setPassedRate(Integer passedRate) {
        this.passedRate = passedRate;
    }

    public void setLabelTemplateId(UUID labelTemplateId) {
        this.labelTemplateId = labelTemplateId;
    }

    public void setLabelTemplateName(String labelTemplateName) {
        this.labelTemplateName = labelTemplateName;
    }

    public void setValidationLabelsOrder(List<String> validationLabelsOrder) {
        this.validationLabelsOrder = validationLabelsOrder;
    }

    public void setTestScopeId(UUID testScopeId) {
        this.testScopeId = testScopeId;
    }

    @Override
    public String toString() {
        return "ExecutionRequestTreeNode(passedRate=" + this.getPassedRate() + ", labelTemplateId=" + this.getLabelTemplateId() + ", labelTemplateName=" + this.getLabelTemplateName() + ", validationLabelsOrder=" + this.getValidationLabelsOrder() + ", testScopeId=" + this.getTestScopeId() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionRequestTreeNode)) {
            return false;
        }
        ExecutionRequestTreeNode other = (ExecutionRequestTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$passedRate = this.getPassedRate();
        Integer other$passedRate = other.getPassedRate();
        if (this$passedRate == null ? other$passedRate != null : !((Object)this$passedRate).equals(other$passedRate)) {
            return false;
        }
        UUID this$labelTemplateId = this.getLabelTemplateId();
        UUID other$labelTemplateId = other.getLabelTemplateId();
        if (this$labelTemplateId == null ? other$labelTemplateId != null : !((Object)this$labelTemplateId).equals(other$labelTemplateId)) {
            return false;
        }
        String this$labelTemplateName = this.getLabelTemplateName();
        String other$labelTemplateName = other.getLabelTemplateName();
        if (this$labelTemplateName == null ? other$labelTemplateName != null : !this$labelTemplateName.equals(other$labelTemplateName)) {
            return false;
        }
        List<String> this$validationLabelsOrder = this.getValidationLabelsOrder();
        List<String> other$validationLabelsOrder = other.getValidationLabelsOrder();
        if (this$validationLabelsOrder == null ? other$validationLabelsOrder != null : !((Object)this$validationLabelsOrder).equals(other$validationLabelsOrder)) {
            return false;
        }
        UUID this$testScopeId = this.getTestScopeId();
        UUID other$testScopeId = other.getTestScopeId();
        return !(this$testScopeId == null ? other$testScopeId != null : !((Object)this$testScopeId).equals(other$testScopeId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExecutionRequestTreeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $passedRate = this.getPassedRate();
        result = result * 59 + ($passedRate == null ? 43 : ((Object)$passedRate).hashCode());
        UUID $labelTemplateId = this.getLabelTemplateId();
        result = result * 59 + ($labelTemplateId == null ? 43 : ((Object)$labelTemplateId).hashCode());
        String $labelTemplateName = this.getLabelTemplateName();
        result = result * 59 + ($labelTemplateName == null ? 43 : $labelTemplateName.hashCode());
        List<String> $validationLabelsOrder = this.getValidationLabelsOrder();
        result = result * 59 + ($validationLabelsOrder == null ? 43 : ((Object)$validationLabelsOrder).hashCode());
        UUID $testScopeId = this.getTestScopeId();
        result = result * 59 + ($testScopeId == null ? 43 : ((Object)$testScopeId).hashCode());
        return result;
    }

    public ExecutionRequestTreeNode() {
    }
}

