/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.entities.treenodes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.UUID;
import org.qubership.atp.ram.entities.treenodes.TreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNodeType;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.LogRecord;

public class LogRecordTreeNode
extends TreeNode {
    private TestingStatuses testingStatus;
    private ExecutionStatuses executionStatus;
    private TypeAction actionType;
    private UUID testRunId;
    private UUID logRecordId;
    private boolean isRootCauseAvailable;
    @JsonIgnore
    private boolean isLeaf = false;

    public LogRecordTreeNode(LogRecord logRecord, UUID executionRequestId) {
        this.id = UUID.randomUUID();
        this.testRunId = logRecord.getTestRunId();
        this.logRecordId = logRecord.getUuid();
        this.executionRequestId = executionRequestId;
        this.name = logRecord.getName();
        this.nodeType = TreeNodeType.LOG_RECORD_NODE;
        this.actionType = logRecord.getType();
        this.testingStatus = logRecord.getTestingStatus();
        this.isRootCauseAvailable = logRecord.getRootCause() != null;
        this.executionStatus = logRecord.getExecutionStatus();
    }

    public TestingStatuses getTestingStatus() {
        return this.testingStatus;
    }

    public ExecutionStatuses getExecutionStatus() {
        return this.executionStatus;
    }

    public TypeAction getActionType() {
        return this.actionType;
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public UUID getLogRecordId() {
        return this.logRecordId;
    }

    public boolean isRootCauseAvailable() {
        return this.isRootCauseAvailable;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setTestingStatus(TestingStatuses testingStatus) {
        this.testingStatus = testingStatus;
    }

    public void setExecutionStatus(ExecutionStatuses executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setActionType(TypeAction actionType) {
        this.actionType = actionType;
    }

    public void setTestRunId(UUID testRunId) {
        this.testRunId = testRunId;
    }

    public void setLogRecordId(UUID logRecordId) {
        this.logRecordId = logRecordId;
    }

    public void setRootCauseAvailable(boolean isRootCauseAvailable) {
        this.isRootCauseAvailable = isRootCauseAvailable;
    }

    @JsonIgnore
    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public String toString() {
        return "LogRecordTreeNode(testingStatus=" + (Object)((Object)this.getTestingStatus()) + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", actionType=" + (Object)((Object)this.getActionType()) + ", testRunId=" + this.getTestRunId() + ", logRecordId=" + this.getLogRecordId() + ", isRootCauseAvailable=" + this.isRootCauseAvailable() + ", isLeaf=" + this.isLeaf() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRecordTreeNode)) {
            return false;
        }
        LogRecordTreeNode other = (LogRecordTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isRootCauseAvailable() != other.isRootCauseAvailable()) {
            return false;
        }
        if (this.isLeaf() != other.isLeaf()) {
            return false;
        }
        TestingStatuses this$testingStatus = this.getTestingStatus();
        TestingStatuses other$testingStatus = other.getTestingStatus();
        if (this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus)) {
            return false;
        }
        ExecutionStatuses this$executionStatus = this.getExecutionStatus();
        ExecutionStatuses other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        TypeAction this$actionType = this.getActionType();
        TypeAction other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !((Object)((Object)this$actionType)).equals((Object)other$actionType)) {
            return false;
        }
        UUID this$testRunId = this.getTestRunId();
        UUID other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !((Object)this$testRunId).equals(other$testRunId)) {
            return false;
        }
        UUID this$logRecordId = this.getLogRecordId();
        UUID other$logRecordId = other.getLogRecordId();
        return !(this$logRecordId == null ? other$logRecordId != null : !((Object)this$logRecordId).equals(other$logRecordId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LogRecordTreeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isRootCauseAvailable() ? 79 : 97);
        result = result * 59 + (this.isLeaf() ? 79 : 97);
        TestingStatuses $testingStatus = this.getTestingStatus();
        result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
        ExecutionStatuses $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        TypeAction $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : ((Object)((Object)$actionType)).hashCode());
        UUID $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : ((Object)$testRunId).hashCode());
        UUID $logRecordId = this.getLogRecordId();
        result = result * 59 + ($logRecordId == null ? 43 : ((Object)$logRecordId).hashCode());
        return result;
    }

    public LogRecordTreeNode() {
    }
}

