/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.enums;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public enum DefaultRootCauseType {
    AT_ISSUE("AT Issue"),
    DESIGN_CHANGE("Design Change"),
    ERROR_IN_CONFIGURATION("Error in configuration"),
    INVESTIGATION_NEEDED("Investigation Needed"),
    NOT_ANALYZED("Not Analyzed"),
    PERFOMANCE_ISSUE("Performance Issue"),
    SOLUTION_ISSUE("Solution Issue"),
    ATP_MAINTENCE("ATP Maintenance"),
    NETWORK_ISSUE("Network Issue"),
    ENVIROMENT_ISSUE("Environment Issue"),
    TEST_DATA_ISSUE("Test Data Issue");

    private static final Map<String, DefaultRootCauseType> NAME_INDEX;
    private String name;

    private DefaultRootCauseType(String name) {
        this.name = name;
    }

    public static DefaultRootCauseType fromName(String name) {
        DefaultRootCauseType result = NAME_INDEX.get(name);
        Preconditions.checkNotNull((Object)((Object)result), (String)"Not valid root cause type: ", (Object)name);
        return result;
    }

    public String getName() {
        return this.name;
    }

    static {
        NAME_INDEX = Maps.newHashMapWithExpectedSize((int)DefaultRootCauseType.values().length);
        for (DefaultRootCauseType defaultRootCauseType : DefaultRootCauseType.values()) {
            NAME_INDEX.put(defaultRootCauseType.getName(), defaultRootCauseType);
        }
    }
}

