/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.dto.response.MessageParameter;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.CustomLink;
import org.qubership.atp.ram.models.MetaInfo;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.models.SsmMetricReports;
import org.qubership.atp.ram.models.StepLinkMetaInfo;
import org.qubership.atp.ram.models.Table;
import org.qubership.atp.ram.models.logrecords.parts.ContextVariable;
import org.qubership.atp.ram.models.logrecords.parts.FileMetadata;
import org.qubership.atp.ram.models.logrecords.parts.Log;
import org.qubership.atp.ram.models.logrecords.parts.ValidationTable;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Document(collection="logrecord")
@CompoundIndexes(value={@CompoundIndex(name="_id_parentRecordId_testRunId", def="{'_id': 1, 'parentRecordId': 1, 'testRunId': 1}"), @CompoundIndex(name="testRunId_startDate", def="{'testRunId': 1, 'startDate': 1}"), @CompoundIndex(name="_testRunId_createdDate", def="{'testRunId': 1, 'createdDate': 1}", background=true), @CompoundIndex(name="_name_testRunId", def="{'name': 'text', 'testRunId': 1}", background=true), @CompoundIndex(name="_testRunId_parentRecordId_createdDateStamp", def="{'testRunId': 1, 'parentRecordId': 1, 'createdDateStamp': 1}", background=true), @CompoundIndex(name="_testRunId_lastUpdated", def="{'testRunId': 1, 'lastUpdated': 1}", background=true), @CompoundIndex(name="_testRunId_fileMetadata.type", def="{'testRunId': 1, 'fileMetadata.type': 1}", background=true), @CompoundIndex(name="_testRunId_testingStatus", def="{'testRunId': 1, 'testingStatus': 1}", background=true)})
public class LogRecord
extends RamObject {
    private String protocolType;
    @LastModifiedDate
    private Date lastUpdated;
    @CreatedDate
    private Timestamp createdDate;
    private long createdDateStamp;
    private String message;
    @Indexed
    private UUID parentRecordId;
    @Indexed
    private UUID testRunId;
    private boolean isSection;
    private TestingStatuses testingStatus;
    private ExecutionStatuses executionStatus = ExecutionStatuses.NOT_STARTED;
    private String server;
    @Indexed(background=true)
    private Timestamp startDate;
    private Timestamp endDate;
    private long duration;
    private RootCause rootCause;
    private String stackTrace;
    private boolean isCompaund;
    private String snapshotId;
    private Set<String> configInfoId = new HashSet<String>();
    private String urlToLogCollectorData;
    private String linkToSvp;
    private TypeAction type;
    private List<UUID> duplicateId = new ArrayList<UUID>();
    private List<Log.TaToolLog> taToolsLogs;
    private ValidationTable validationTable;
    private Set<String> validationLabels;
    private List<FileMetadata> fileMetadata;
    @Transient
    @JsonIgnore
    private List<MessageParameter> messageParameters;
    @JsonIgnore
    @Transient
    private List<ContextVariable> contextVariables;
    @JsonIgnore
    @Transient
    private List<ContextVariable> stepContextVariables;
    @JsonProperty(value="isBrowserConsoleLogsPresent")
    private boolean isBrowserConsoleLogsPresent;
    private boolean isMessageParametersPresent;
    private Table table;
    private SsmMetricReports ssmMetricReports;
    private String preview;
    private MetaInfo metaInfo;
    private List<Child> children;
    private boolean isContextVariablesPresent;
    private List<CustomLink> customLinks;

    public LogRecord() {
        this.testingStatus = TestingStatuses.UNKNOWN;
    }

    public void setTestingStatus(TestingStatuses testingStatus) {
        if (Objects.nonNull((Object)testingStatus)) {
            this.testingStatus = TestingStatuses.compareAndGetPriority(this.testingStatus, testingStatus);
        }
    }

    public void setTestingStatusHard(TestingStatuses testingStatus) {
        if (Objects.nonNull((Object)testingStatus)) {
            this.testingStatus = testingStatus;
        }
    }

    public boolean isContextVariablesPresent() {
        return this.isContextVariablesPresent || this.contextVariables != null && !this.contextVariables.isEmpty() || this.stepContextVariables != null && !this.stepContextVariables.isEmpty();
    }

    @JsonProperty(value="isMessageParametersPresent")
    public boolean isMessageParametersPresent() {
        return this.isMessageParametersPresent || !CollectionUtils.isEmpty(this.messageParameters);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogRecord)) {
            return false;
        }
        LogRecord other = (LogRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCreatedDateStamp() != other.getCreatedDateStamp()) {
            return false;
        }
        if (this.isSection() != other.isSection()) {
            return false;
        }
        if (this.getDuration() != other.getDuration()) {
            return false;
        }
        if (this.isCompaund() != other.isCompaund()) {
            return false;
        }
        if (this.isBrowserConsoleLogsPresent() != other.isBrowserConsoleLogsPresent()) {
            return false;
        }
        if (this.isMessageParametersPresent() != other.isMessageParametersPresent()) {
            return false;
        }
        if (this.isContextVariablesPresent() != other.isContextVariablesPresent()) {
            return false;
        }
        String this$protocolType = this.getProtocolType();
        String other$protocolType = other.getProtocolType();
        if (this$protocolType == null ? other$protocolType != null : !this$protocolType.equals(other$protocolType)) {
            return false;
        }
        Date this$lastUpdated = this.getLastUpdated();
        Date other$lastUpdated = other.getLastUpdated();
        if (this$lastUpdated == null ? other$lastUpdated != null : !((Object)this$lastUpdated).equals(other$lastUpdated)) {
            return false;
        }
        Timestamp this$createdDate = this.getCreatedDate();
        Timestamp other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        UUID this$parentRecordId = this.getParentRecordId();
        UUID other$parentRecordId = other.getParentRecordId();
        if (this$parentRecordId == null ? other$parentRecordId != null : !((Object)this$parentRecordId).equals(other$parentRecordId)) {
            return false;
        }
        UUID this$testRunId = this.getTestRunId();
        UUID other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !((Object)this$testRunId).equals(other$testRunId)) {
            return false;
        }
        TestingStatuses this$testingStatus = this.getTestingStatus();
        TestingStatuses other$testingStatus = other.getTestingStatus();
        if (this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus)) {
            return false;
        }
        ExecutionStatuses this$executionStatus = this.getExecutionStatus();
        ExecutionStatuses other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        if (this$server == null ? other$server != null : !this$server.equals(other$server)) {
            return false;
        }
        Timestamp this$startDate = this.getStartDate();
        Timestamp other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Timestamp this$endDate = this.getEndDate();
        Timestamp other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        RootCause this$rootCause = this.getRootCause();
        RootCause other$rootCause = other.getRootCause();
        if (this$rootCause == null ? other$rootCause != null : !((Object)this$rootCause).equals(other$rootCause)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        String this$snapshotId = this.getSnapshotId();
        String other$snapshotId = other.getSnapshotId();
        if (this$snapshotId == null ? other$snapshotId != null : !this$snapshotId.equals(other$snapshotId)) {
            return false;
        }
        Set<String> this$configInfoId = this.getConfigInfoId();
        Set<String> other$configInfoId = other.getConfigInfoId();
        if (this$configInfoId == null ? other$configInfoId != null : !((Object)this$configInfoId).equals(other$configInfoId)) {
            return false;
        }
        String this$urlToLogCollectorData = this.getUrlToLogCollectorData();
        String other$urlToLogCollectorData = other.getUrlToLogCollectorData();
        if (this$urlToLogCollectorData == null ? other$urlToLogCollectorData != null : !this$urlToLogCollectorData.equals(other$urlToLogCollectorData)) {
            return false;
        }
        String this$linkToSvp = this.getLinkToSvp();
        String other$linkToSvp = other.getLinkToSvp();
        if (this$linkToSvp == null ? other$linkToSvp != null : !this$linkToSvp.equals(other$linkToSvp)) {
            return false;
        }
        TypeAction this$type = this.getType();
        TypeAction other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<UUID> this$duplicateId = this.getDuplicateId();
        List<UUID> other$duplicateId = other.getDuplicateId();
        if (this$duplicateId == null ? other$duplicateId != null : !((Object)this$duplicateId).equals(other$duplicateId)) {
            return false;
        }
        List<Log.TaToolLog> this$taToolsLogs = this.getTaToolsLogs();
        List<Log.TaToolLog> other$taToolsLogs = other.getTaToolsLogs();
        if (this$taToolsLogs == null ? other$taToolsLogs != null : !((Object)this$taToolsLogs).equals(other$taToolsLogs)) {
            return false;
        }
        ValidationTable this$validationTable = this.getValidationTable();
        ValidationTable other$validationTable = other.getValidationTable();
        if (this$validationTable == null ? other$validationTable != null : !((Object)this$validationTable).equals(other$validationTable)) {
            return false;
        }
        Set<String> this$validationLabels = this.getValidationLabels();
        Set<String> other$validationLabels = other.getValidationLabels();
        if (this$validationLabels == null ? other$validationLabels != null : !((Object)this$validationLabels).equals(other$validationLabels)) {
            return false;
        }
        List<FileMetadata> this$fileMetadata = this.getFileMetadata();
        List<FileMetadata> other$fileMetadata = other.getFileMetadata();
        if (this$fileMetadata == null ? other$fileMetadata != null : !((Object)this$fileMetadata).equals(other$fileMetadata)) {
            return false;
        }
        List<MessageParameter> this$messageParameters = this.getMessageParameters();
        List<MessageParameter> other$messageParameters = other.getMessageParameters();
        if (this$messageParameters == null ? other$messageParameters != null : !((Object)this$messageParameters).equals(other$messageParameters)) {
            return false;
        }
        List<ContextVariable> this$contextVariables = this.getContextVariables();
        List<ContextVariable> other$contextVariables = other.getContextVariables();
        if (this$contextVariables == null ? other$contextVariables != null : !((Object)this$contextVariables).equals(other$contextVariables)) {
            return false;
        }
        List<ContextVariable> this$stepContextVariables = this.getStepContextVariables();
        List<ContextVariable> other$stepContextVariables = other.getStepContextVariables();
        if (this$stepContextVariables == null ? other$stepContextVariables != null : !((Object)this$stepContextVariables).equals(other$stepContextVariables)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        if (this$table == null ? other$table != null : !((Object)this$table).equals(other$table)) {
            return false;
        }
        SsmMetricReports this$ssmMetricReports = this.getSsmMetricReports();
        SsmMetricReports other$ssmMetricReports = other.getSsmMetricReports();
        if (this$ssmMetricReports == null ? other$ssmMetricReports != null : !((Object)this$ssmMetricReports).equals(other$ssmMetricReports)) {
            return false;
        }
        String this$preview = this.getPreview();
        String other$preview = other.getPreview();
        if (this$preview == null ? other$preview != null : !this$preview.equals(other$preview)) {
            return false;
        }
        MetaInfo this$metaInfo = this.getMetaInfo();
        MetaInfo other$metaInfo = other.getMetaInfo();
        if (this$metaInfo == null ? other$metaInfo != null : !((Object)this$metaInfo).equals(other$metaInfo)) {
            return false;
        }
        List<Child> this$children = this.getChildren();
        List<Child> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        List<CustomLink> this$customLinks = this.getCustomLinks();
        List<CustomLink> other$customLinks = other.getCustomLinks();
        return !(this$customLinks == null ? other$customLinks != null : !((Object)this$customLinks).equals(other$customLinks));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LogRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $createdDateStamp = this.getCreatedDateStamp();
        result = result * 59 + (int)($createdDateStamp >>> 32 ^ $createdDateStamp);
        result = result * 59 + (this.isSection() ? 79 : 97);
        long $duration = this.getDuration();
        result = result * 59 + (int)($duration >>> 32 ^ $duration);
        result = result * 59 + (this.isCompaund() ? 79 : 97);
        result = result * 59 + (this.isBrowserConsoleLogsPresent() ? 79 : 97);
        result = result * 59 + (this.isMessageParametersPresent() ? 79 : 97);
        result = result * 59 + (this.isContextVariablesPresent() ? 79 : 97);
        String $protocolType = this.getProtocolType();
        result = result * 59 + ($protocolType == null ? 43 : $protocolType.hashCode());
        Date $lastUpdated = this.getLastUpdated();
        result = result * 59 + ($lastUpdated == null ? 43 : ((Object)$lastUpdated).hashCode());
        Timestamp $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        UUID $parentRecordId = this.getParentRecordId();
        result = result * 59 + ($parentRecordId == null ? 43 : ((Object)$parentRecordId).hashCode());
        UUID $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : ((Object)$testRunId).hashCode());
        TestingStatuses $testingStatus = this.getTestingStatus();
        result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
        ExecutionStatuses $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        Timestamp $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Timestamp $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        RootCause $rootCause = this.getRootCause();
        result = result * 59 + ($rootCause == null ? 43 : ((Object)$rootCause).hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        String $snapshotId = this.getSnapshotId();
        result = result * 59 + ($snapshotId == null ? 43 : $snapshotId.hashCode());
        Set<String> $configInfoId = this.getConfigInfoId();
        result = result * 59 + ($configInfoId == null ? 43 : ((Object)$configInfoId).hashCode());
        String $urlToLogCollectorData = this.getUrlToLogCollectorData();
        result = result * 59 + ($urlToLogCollectorData == null ? 43 : $urlToLogCollectorData.hashCode());
        String $linkToSvp = this.getLinkToSvp();
        result = result * 59 + ($linkToSvp == null ? 43 : $linkToSvp.hashCode());
        TypeAction $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<UUID> $duplicateId = this.getDuplicateId();
        result = result * 59 + ($duplicateId == null ? 43 : ((Object)$duplicateId).hashCode());
        List<Log.TaToolLog> $taToolsLogs = this.getTaToolsLogs();
        result = result * 59 + ($taToolsLogs == null ? 43 : ((Object)$taToolsLogs).hashCode());
        ValidationTable $validationTable = this.getValidationTable();
        result = result * 59 + ($validationTable == null ? 43 : ((Object)$validationTable).hashCode());
        Set<String> $validationLabels = this.getValidationLabels();
        result = result * 59 + ($validationLabels == null ? 43 : ((Object)$validationLabels).hashCode());
        List<FileMetadata> $fileMetadata = this.getFileMetadata();
        result = result * 59 + ($fileMetadata == null ? 43 : ((Object)$fileMetadata).hashCode());
        List<MessageParameter> $messageParameters = this.getMessageParameters();
        result = result * 59 + ($messageParameters == null ? 43 : ((Object)$messageParameters).hashCode());
        List<ContextVariable> $contextVariables = this.getContextVariables();
        result = result * 59 + ($contextVariables == null ? 43 : ((Object)$contextVariables).hashCode());
        List<ContextVariable> $stepContextVariables = this.getStepContextVariables();
        result = result * 59 + ($stepContextVariables == null ? 43 : ((Object)$stepContextVariables).hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        SsmMetricReports $ssmMetricReports = this.getSsmMetricReports();
        result = result * 59 + ($ssmMetricReports == null ? 43 : ((Object)$ssmMetricReports).hashCode());
        String $preview = this.getPreview();
        result = result * 59 + ($preview == null ? 43 : $preview.hashCode());
        MetaInfo $metaInfo = this.getMetaInfo();
        result = result * 59 + ($metaInfo == null ? 43 : ((Object)$metaInfo).hashCode());
        List<Child> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        List<CustomLink> $customLinks = this.getCustomLinks();
        result = result * 59 + ($customLinks == null ? 43 : ((Object)$customLinks).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "LogRecord(super=" + super.toString() + ", protocolType=" + this.getProtocolType() + ", lastUpdated=" + this.getLastUpdated() + ", createdDate=" + this.getCreatedDate() + ", createdDateStamp=" + this.getCreatedDateStamp() + ", message=" + this.getMessage() + ", parentRecordId=" + this.getParentRecordId() + ", testRunId=" + this.getTestRunId() + ", isSection=" + this.isSection() + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", server=" + this.getServer() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", duration=" + this.getDuration() + ", rootCause=" + this.getRootCause() + ", stackTrace=" + this.getStackTrace() + ", isCompaund=" + this.isCompaund() + ", snapshotId=" + this.getSnapshotId() + ", configInfoId=" + this.getConfigInfoId() + ", urlToLogCollectorData=" + this.getUrlToLogCollectorData() + ", linkToSvp=" + this.getLinkToSvp() + ", type=" + (Object)((Object)this.getType()) + ", duplicateId=" + this.getDuplicateId() + ", taToolsLogs=" + this.getTaToolsLogs() + ", validationTable=" + this.getValidationTable() + ", validationLabels=" + this.getValidationLabels() + ", fileMetadata=" + this.getFileMetadata() + ", messageParameters=" + this.getMessageParameters() + ", contextVariables=" + this.getContextVariables() + ", stepContextVariables=" + this.getStepContextVariables() + ", isBrowserConsoleLogsPresent=" + this.isBrowserConsoleLogsPresent() + ", isMessageParametersPresent=" + this.isMessageParametersPresent() + ", table=" + this.getTable() + ", ssmMetricReports=" + this.getSsmMetricReports() + ", preview=" + this.getPreview() + ", metaInfo=" + this.getMetaInfo() + ", children=" + this.getChildren() + ", isContextVariablesPresent=" + this.isContextVariablesPresent() + ", customLinks=" + this.getCustomLinks() + ")";
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public Timestamp getCreatedDate() {
        return this.createdDate;
    }

    public long getCreatedDateStamp() {
        return this.createdDateStamp;
    }

    public String getMessage() {
        return this.message;
    }

    public UUID getParentRecordId() {
        return this.parentRecordId;
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public boolean isSection() {
        return this.isSection;
    }

    public TestingStatuses getTestingStatus() {
        return this.testingStatus;
    }

    public ExecutionStatuses getExecutionStatus() {
        return this.executionStatus;
    }

    public String getServer() {
        return this.server;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public long getDuration() {
        return this.duration;
    }

    public RootCause getRootCause() {
        return this.rootCause;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public boolean isCompaund() {
        return this.isCompaund;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public Set<String> getConfigInfoId() {
        return this.configInfoId;
    }

    public String getUrlToLogCollectorData() {
        return this.urlToLogCollectorData;
    }

    public String getLinkToSvp() {
        return this.linkToSvp;
    }

    public TypeAction getType() {
        return this.type;
    }

    public List<UUID> getDuplicateId() {
        return this.duplicateId;
    }

    public List<Log.TaToolLog> getTaToolsLogs() {
        return this.taToolsLogs;
    }

    public ValidationTable getValidationTable() {
        return this.validationTable;
    }

    public Set<String> getValidationLabels() {
        return this.validationLabels;
    }

    public List<FileMetadata> getFileMetadata() {
        return this.fileMetadata;
    }

    public List<MessageParameter> getMessageParameters() {
        return this.messageParameters;
    }

    public List<ContextVariable> getContextVariables() {
        return this.contextVariables;
    }

    public List<ContextVariable> getStepContextVariables() {
        return this.stepContextVariables;
    }

    public boolean isBrowserConsoleLogsPresent() {
        return this.isBrowserConsoleLogsPresent;
    }

    public Table getTable() {
        return this.table;
    }

    public SsmMetricReports getSsmMetricReports() {
        return this.ssmMetricReports;
    }

    public String getPreview() {
        return this.preview;
    }

    public MetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public List<Child> getChildren() {
        return this.children;
    }

    public List<CustomLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public void setCreatedDate(Timestamp createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedDateStamp(long createdDateStamp) {
        this.createdDateStamp = createdDateStamp;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setParentRecordId(UUID parentRecordId) {
        this.parentRecordId = parentRecordId;
    }

    public void setTestRunId(UUID testRunId) {
        this.testRunId = testRunId;
    }

    public void setSection(boolean isSection) {
        this.isSection = isSection;
    }

    public void setExecutionStatus(ExecutionStatuses executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setStartDate(Timestamp startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Timestamp endDate) {
        this.endDate = endDate;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setRootCause(RootCause rootCause) {
        this.rootCause = rootCause;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setCompaund(boolean isCompaund) {
        this.isCompaund = isCompaund;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setConfigInfoId(Set<String> configInfoId) {
        this.configInfoId = configInfoId;
    }

    public void setUrlToLogCollectorData(String urlToLogCollectorData) {
        this.urlToLogCollectorData = urlToLogCollectorData;
    }

    public void setLinkToSvp(String linkToSvp) {
        this.linkToSvp = linkToSvp;
    }

    public void setType(TypeAction type) {
        this.type = type;
    }

    public void setDuplicateId(List<UUID> duplicateId) {
        this.duplicateId = duplicateId;
    }

    public void setTaToolsLogs(List<Log.TaToolLog> taToolsLogs) {
        this.taToolsLogs = taToolsLogs;
    }

    public void setValidationTable(ValidationTable validationTable) {
        this.validationTable = validationTable;
    }

    public void setValidationLabels(Set<String> validationLabels) {
        this.validationLabels = validationLabels;
    }

    public void setFileMetadata(List<FileMetadata> fileMetadata) {
        this.fileMetadata = fileMetadata;
    }

    @JsonIgnore
    public void setMessageParameters(List<MessageParameter> messageParameters) {
        this.messageParameters = messageParameters;
    }

    @JsonIgnore
    public void setContextVariables(List<ContextVariable> contextVariables) {
        this.contextVariables = contextVariables;
    }

    @JsonIgnore
    public void setStepContextVariables(List<ContextVariable> stepContextVariables) {
        this.stepContextVariables = stepContextVariables;
    }

    @JsonProperty(value="isBrowserConsoleLogsPresent")
    public void setBrowserConsoleLogsPresent(boolean isBrowserConsoleLogsPresent) {
        this.isBrowserConsoleLogsPresent = isBrowserConsoleLogsPresent;
    }

    public void setMessageParametersPresent(boolean isMessageParametersPresent) {
        this.isMessageParametersPresent = isMessageParametersPresent;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setSsmMetricReports(SsmMetricReports ssmMetricReports) {
        this.ssmMetricReports = ssmMetricReports;
    }

    public void setPreview(String preview) {
        this.preview = preview;
    }

    public void setMetaInfo(MetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setChildren(List<Child> children) {
        this.children = children;
    }

    public void setContextVariablesPresent(boolean isContextVariablesPresent) {
        this.isContextVariablesPresent = isContextVariablesPresent;
    }

    public void setCustomLinks(List<CustomLink> customLinks) {
        this.customLinks = customLinks;
    }

    public static class Child
    extends RamObject {
        private TypeAction type;
        private TestingStatuses testingStatus;
        private ExecutionStatuses executionStatus;
        private StepLinkMetaInfo editorMetaInfo;
        private List<CustomLink> customLinks;

        public Child(LogRecord logRecord) {
            super(logRecord.getUuid(), logRecord.getName());
            this.type = logRecord.getType();
            this.testingStatus = logRecord.getTestingStatus();
            this.executionStatus = logRecord.getExecutionStatus();
            this.editorMetaInfo = logRecord.getMetaInfo() == null || logRecord.getMetaInfo().getEditorMetaInfo() == null || StringUtils.isEmpty((Object)logRecord.getMetaInfo().getEditorMetaInfo().getEngineType()) ? null : logRecord.getMetaInfo().getEditorMetaInfo();
            this.customLinks = logRecord.getCustomLinks();
        }

        public TypeAction getType() {
            return this.type;
        }

        public TestingStatuses getTestingStatus() {
            return this.testingStatus;
        }

        public ExecutionStatuses getExecutionStatus() {
            return this.executionStatus;
        }

        public StepLinkMetaInfo getEditorMetaInfo() {
            return this.editorMetaInfo;
        }

        public List<CustomLink> getCustomLinks() {
            return this.customLinks;
        }

        public void setType(TypeAction type) {
            this.type = type;
        }

        public void setTestingStatus(TestingStatuses testingStatus) {
            this.testingStatus = testingStatus;
        }

        public void setExecutionStatus(ExecutionStatuses executionStatus) {
            this.executionStatus = executionStatus;
        }

        public void setEditorMetaInfo(StepLinkMetaInfo editorMetaInfo) {
            this.editorMetaInfo = editorMetaInfo;
        }

        public void setCustomLinks(List<CustomLink> customLinks) {
            this.customLinks = customLinks;
        }

        @Override
        public String toString() {
            return "LogRecord.Child(type=" + (Object)((Object)this.getType()) + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", editorMetaInfo=" + this.getEditorMetaInfo() + ", customLinks=" + this.getCustomLinks() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Child)) {
                return false;
            }
            Child other = (Child)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TypeAction this$type = this.getType();
            TypeAction other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            TestingStatuses this$testingStatus = this.getTestingStatus();
            TestingStatuses other$testingStatus = other.getTestingStatus();
            if (this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus)) {
                return false;
            }
            ExecutionStatuses this$executionStatus = this.getExecutionStatus();
            ExecutionStatuses other$executionStatus = other.getExecutionStatus();
            if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
                return false;
            }
            StepLinkMetaInfo this$editorMetaInfo = this.getEditorMetaInfo();
            StepLinkMetaInfo other$editorMetaInfo = other.getEditorMetaInfo();
            if (this$editorMetaInfo == null ? other$editorMetaInfo != null : !((Object)this$editorMetaInfo).equals(other$editorMetaInfo)) {
                return false;
            }
            List<CustomLink> this$customLinks = this.getCustomLinks();
            List<CustomLink> other$customLinks = other.getCustomLinks();
            return !(this$customLinks == null ? other$customLinks != null : !((Object)this$customLinks).equals(other$customLinks));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Child;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            TypeAction $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            TestingStatuses $testingStatus = this.getTestingStatus();
            result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
            ExecutionStatuses $executionStatus = this.getExecutionStatus();
            result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
            StepLinkMetaInfo $editorMetaInfo = this.getEditorMetaInfo();
            result = result * 59 + ($editorMetaInfo == null ? 43 : ((Object)$editorMetaInfo).hashCode());
            List<CustomLink> $customLinks = this.getCustomLinks();
            result = result * 59 + ($customLinks == null ? 43 : ((Object)$customLinks).hashCode());
            return result;
        }
    }
}

