/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.ColumnVisibility;
import org.qubership.atp.ram.models.RamObject;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="widgetConfigTemplates")
public class WidgetConfigTemplate
extends RamObject {
    @Indexed(background=true)
    private UUID projectId;
    private List<WidgetConfig> widgets = new ArrayList<WidgetConfig>();

    public WidgetConfig getWidgetConfig(UUID widgetId) {
        return this.widgets.stream().filter(widgetConfig -> widgetConfig.getWidgetId().equals(widgetId)).findFirst().orElse(new WidgetConfig(widgetId));
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<WidgetConfig> getWidgets() {
        return this.widgets;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setWidgets(List<WidgetConfig> widgets) {
        this.widgets = widgets;
    }

    @Override
    public String toString() {
        return "WidgetConfigTemplate(projectId=" + this.getProjectId() + ", widgets=" + this.getWidgets() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WidgetConfigTemplate)) {
            return false;
        }
        WidgetConfigTemplate other = (WidgetConfigTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<WidgetConfig> this$widgets = this.getWidgets();
        List<WidgetConfig> other$widgets = other.getWidgets();
        return !(this$widgets == null ? other$widgets != null : !((Object)this$widgets).equals(other$widgets));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WidgetConfigTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<WidgetConfig> $widgets = this.getWidgets();
        result = result * 59 + ($widgets == null ? 43 : ((Object)$widgets).hashCode());
        return result;
    }

    public WidgetConfigTemplate(UUID projectId, List<WidgetConfig> widgets) {
        this.projectId = projectId;
        this.widgets = widgets;
    }

    public WidgetConfigTemplate() {
    }

    public static class WidgetConfig {
        private UUID widgetId;
        private UUID labelTemplateId;
        private UUID validationTemplateId;
        private List<ColumnVisibility> columnVisibilities;
        private boolean isExecutionRequestsSummary;
        private Integer sizeLimit;
        private Filters filters;

        public WidgetConfig(UUID widgetId) {
            this.widgetId = widgetId;
        }

        public UUID getWidgetId() {
            return this.widgetId;
        }

        public UUID getLabelTemplateId() {
            return this.labelTemplateId;
        }

        public UUID getValidationTemplateId() {
            return this.validationTemplateId;
        }

        public List<ColumnVisibility> getColumnVisibilities() {
            return this.columnVisibilities;
        }

        public boolean isExecutionRequestsSummary() {
            return this.isExecutionRequestsSummary;
        }

        public Integer getSizeLimit() {
            return this.sizeLimit;
        }

        public Filters getFilters() {
            return this.filters;
        }

        public void setWidgetId(UUID widgetId) {
            this.widgetId = widgetId;
        }

        public void setLabelTemplateId(UUID labelTemplateId) {
            this.labelTemplateId = labelTemplateId;
        }

        public void setValidationTemplateId(UUID validationTemplateId) {
            this.validationTemplateId = validationTemplateId;
        }

        public void setColumnVisibilities(List<ColumnVisibility> columnVisibilities) {
            this.columnVisibilities = columnVisibilities;
        }

        public void setExecutionRequestsSummary(boolean isExecutionRequestsSummary) {
            this.isExecutionRequestsSummary = isExecutionRequestsSummary;
        }

        public void setSizeLimit(Integer sizeLimit) {
            this.sizeLimit = sizeLimit;
        }

        public void setFilters(Filters filters) {
            this.filters = filters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WidgetConfig)) {
                return false;
            }
            WidgetConfig other = (WidgetConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isExecutionRequestsSummary() != other.isExecutionRequestsSummary()) {
                return false;
            }
            Integer this$sizeLimit = this.getSizeLimit();
            Integer other$sizeLimit = other.getSizeLimit();
            if (this$sizeLimit == null ? other$sizeLimit != null : !((Object)this$sizeLimit).equals(other$sizeLimit)) {
                return false;
            }
            UUID this$widgetId = this.getWidgetId();
            UUID other$widgetId = other.getWidgetId();
            if (this$widgetId == null ? other$widgetId != null : !((Object)this$widgetId).equals(other$widgetId)) {
                return false;
            }
            UUID this$labelTemplateId = this.getLabelTemplateId();
            UUID other$labelTemplateId = other.getLabelTemplateId();
            if (this$labelTemplateId == null ? other$labelTemplateId != null : !((Object)this$labelTemplateId).equals(other$labelTemplateId)) {
                return false;
            }
            UUID this$validationTemplateId = this.getValidationTemplateId();
            UUID other$validationTemplateId = other.getValidationTemplateId();
            if (this$validationTemplateId == null ? other$validationTemplateId != null : !((Object)this$validationTemplateId).equals(other$validationTemplateId)) {
                return false;
            }
            List<ColumnVisibility> this$columnVisibilities = this.getColumnVisibilities();
            List<ColumnVisibility> other$columnVisibilities = other.getColumnVisibilities();
            if (this$columnVisibilities == null ? other$columnVisibilities != null : !((Object)this$columnVisibilities).equals(other$columnVisibilities)) {
                return false;
            }
            Filters this$filters = this.getFilters();
            Filters other$filters = other.getFilters();
            return !(this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WidgetConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExecutionRequestsSummary() ? 79 : 97);
            Integer $sizeLimit = this.getSizeLimit();
            result = result * 59 + ($sizeLimit == null ? 43 : ((Object)$sizeLimit).hashCode());
            UUID $widgetId = this.getWidgetId();
            result = result * 59 + ($widgetId == null ? 43 : ((Object)$widgetId).hashCode());
            UUID $labelTemplateId = this.getLabelTemplateId();
            result = result * 59 + ($labelTemplateId == null ? 43 : ((Object)$labelTemplateId).hashCode());
            UUID $validationTemplateId = this.getValidationTemplateId();
            result = result * 59 + ($validationTemplateId == null ? 43 : ((Object)$validationTemplateId).hashCode());
            List<ColumnVisibility> $columnVisibilities = this.getColumnVisibilities();
            result = result * 59 + ($columnVisibilities == null ? 43 : ((Object)$columnVisibilities).hashCode());
            Filters $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            return result;
        }

        public String toString() {
            return "WidgetConfigTemplate.WidgetConfig(widgetId=" + this.getWidgetId() + ", labelTemplateId=" + this.getLabelTemplateId() + ", validationTemplateId=" + this.getValidationTemplateId() + ", columnVisibilities=" + this.getColumnVisibilities() + ", isExecutionRequestsSummary=" + this.isExecutionRequestsSummary() + ", sizeLimit=" + this.getSizeLimit() + ", filters=" + this.getFilters() + ")";
        }

        public WidgetConfig(UUID widgetId, UUID labelTemplateId, UUID validationTemplateId, List<ColumnVisibility> columnVisibilities, boolean isExecutionRequestsSummary, Integer sizeLimit, Filters filters) {
            this.widgetId = widgetId;
            this.labelTemplateId = labelTemplateId;
            this.validationTemplateId = validationTemplateId;
            this.columnVisibilities = columnVisibilities;
            this.isExecutionRequestsSummary = isExecutionRequestsSummary;
            this.sizeLimit = sizeLimit;
            this.filters = filters;
        }

        public WidgetConfig() {
        }
    }

    public static class Filters {
        private Set<TestingStatuses> testingStatuses;
        private Set<TestingStatuses> firstStatuses;
        private Set<TestingStatuses> finalStatuses;
        private Set<UUID> failureReasons;

        public Set<TestingStatuses> getTestingStatuses() {
            return this.testingStatuses;
        }

        public Set<TestingStatuses> getFirstStatuses() {
            return this.firstStatuses;
        }

        public Set<TestingStatuses> getFinalStatuses() {
            return this.finalStatuses;
        }

        public Set<UUID> getFailureReasons() {
            return this.failureReasons;
        }

        public void setTestingStatuses(Set<TestingStatuses> testingStatuses) {
            this.testingStatuses = testingStatuses;
        }

        public void setFirstStatuses(Set<TestingStatuses> firstStatuses) {
            this.firstStatuses = firstStatuses;
        }

        public void setFinalStatuses(Set<TestingStatuses> finalStatuses) {
            this.finalStatuses = finalStatuses;
        }

        public void setFailureReasons(Set<UUID> failureReasons) {
            this.failureReasons = failureReasons;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Filters)) {
                return false;
            }
            Filters other = (Filters)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<TestingStatuses> this$testingStatuses = this.getTestingStatuses();
            Set<TestingStatuses> other$testingStatuses = other.getTestingStatuses();
            if (this$testingStatuses == null ? other$testingStatuses != null : !((Object)this$testingStatuses).equals(other$testingStatuses)) {
                return false;
            }
            Set<TestingStatuses> this$firstStatuses = this.getFirstStatuses();
            Set<TestingStatuses> other$firstStatuses = other.getFirstStatuses();
            if (this$firstStatuses == null ? other$firstStatuses != null : !((Object)this$firstStatuses).equals(other$firstStatuses)) {
                return false;
            }
            Set<TestingStatuses> this$finalStatuses = this.getFinalStatuses();
            Set<TestingStatuses> other$finalStatuses = other.getFinalStatuses();
            if (this$finalStatuses == null ? other$finalStatuses != null : !((Object)this$finalStatuses).equals(other$finalStatuses)) {
                return false;
            }
            Set<UUID> this$failureReasons = this.getFailureReasons();
            Set<UUID> other$failureReasons = other.getFailureReasons();
            return !(this$failureReasons == null ? other$failureReasons != null : !((Object)this$failureReasons).equals(other$failureReasons));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Filters;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<TestingStatuses> $testingStatuses = this.getTestingStatuses();
            result = result * 59 + ($testingStatuses == null ? 43 : ((Object)$testingStatuses).hashCode());
            Set<TestingStatuses> $firstStatuses = this.getFirstStatuses();
            result = result * 59 + ($firstStatuses == null ? 43 : ((Object)$firstStatuses).hashCode());
            Set<TestingStatuses> $finalStatuses = this.getFinalStatuses();
            result = result * 59 + ($finalStatuses == null ? 43 : ((Object)$finalStatuses).hashCode());
            Set<UUID> $failureReasons = this.getFailureReasons();
            result = result * 59 + ($failureReasons == null ? 43 : ((Object)$failureReasons).hashCode());
            return result;
        }

        public String toString() {
            return "WidgetConfigTemplate.Filters(testingStatuses=" + this.getTestingStatuses() + ", firstStatuses=" + this.getFirstStatuses() + ", finalStatuses=" + this.getFinalStatuses() + ", failureReasons=" + this.getFailureReasons() + ")";
        }

        public Filters(Set<TestingStatuses> testingStatuses, Set<TestingStatuses> firstStatuses, Set<TestingStatuses> finalStatuses, Set<UUID> failureReasons) {
            this.testingStatuses = testingStatuses;
            this.firstStatuses = firstStatuses;
            this.finalStatuses = finalStatuses;
            this.failureReasons = failureReasons;
        }

        public Filters() {
        }
    }
}

