/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.filters;

import java.util.regex.Pattern;
import org.qubership.atp.ram.dto.filters.AbstractFilter;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestUnexpectedFilterTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.util.StringUtils;

public class TextFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(TextFilter.class);
    public static final String TYPE = "TextFilter";
    private TextFilterType filterType;
    private boolean caseSensitive;
    private String value;

    @Override
    public Criteria buildFilterCriteriaForField(String field) {
        if (StringUtils.isEmpty((Object)this.value)) {
            return null;
        }
        Pattern regex = this.getPattern();
        return this.getCriteria(field, regex);
    }

    private Criteria getCriteria(String field, Pattern regex) {
        Criteria criteria = this.caseSensitive ? Criteria.where((String)field).regex(regex) : Criteria.where((String)field).regex(regex.pattern(), "i");
        return criteria;
    }

    private Pattern getPattern() {
        Pattern regex;
        switch (this.filterType.ordinal()) {
            case 0: {
                regex = Pattern.compile(Pattern.quote(this.value));
                break;
            }
            case 1: {
                regex = Pattern.compile("^" + Pattern.quote(this.value));
                break;
            }
            default: {
                log.error("Unexpected execution request filter type: {}", (Object)this.filterType);
                throw new RamExecutionRequestUnexpectedFilterTypeException(this.filterType.name());
            }
        }
        return regex;
    }

    public TextFilterType getFilterType() {
        return this.filterType;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String getValue() {
        return this.value;
    }

    public void setFilterType(TextFilterType filterType) {
        this.filterType = filterType;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "TextFilter(filterType=" + (Object)((Object)this.getFilterType()) + ", caseSensitive=" + this.isCaseSensitive() + ", value=" + this.getValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextFilter)) {
            return false;
        }
        TextFilter other = (TextFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCaseSensitive() != other.isCaseSensitive()) {
            return false;
        }
        TextFilterType this$filterType = this.getFilterType();
        TextFilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCaseSensitive() ? 79 : 97);
        TextFilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public static enum TextFilterType {
        CONTAINS,
        STARTS_WITH;

    }
}

