/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.response;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.TestRun;
import org.springframework.util.CollectionUtils;

public class StatusUpdateResponse {
    private Date lastLoaded;
    private List<TestRunStatusUpdateResponse> testRuns;

    public Date getLastLoaded() {
        return this.lastLoaded;
    }

    public List<TestRunStatusUpdateResponse> getTestRuns() {
        return this.testRuns;
    }

    public void setLastLoaded(Date lastLoaded) {
        this.lastLoaded = lastLoaded;
    }

    public void setTestRuns(List<TestRunStatusUpdateResponse> testRuns) {
        this.testRuns = testRuns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusUpdateResponse)) {
            return false;
        }
        StatusUpdateResponse other = (StatusUpdateResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Date this$lastLoaded = this.getLastLoaded();
        Date other$lastLoaded = other.getLastLoaded();
        if (this$lastLoaded == null ? other$lastLoaded != null : !((Object)this$lastLoaded).equals(other$lastLoaded)) {
            return false;
        }
        List<TestRunStatusUpdateResponse> this$testRuns = this.getTestRuns();
        List<TestRunStatusUpdateResponse> other$testRuns = other.getTestRuns();
        return !(this$testRuns == null ? other$testRuns != null : !((Object)this$testRuns).equals(other$testRuns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusUpdateResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $lastLoaded = this.getLastLoaded();
        result = result * 59 + ($lastLoaded == null ? 43 : ((Object)$lastLoaded).hashCode());
        List<TestRunStatusUpdateResponse> $testRuns = this.getTestRuns();
        result = result * 59 + ($testRuns == null ? 43 : ((Object)$testRuns).hashCode());
        return result;
    }

    public String toString() {
        return "StatusUpdateResponse(lastLoaded=" + this.getLastLoaded() + ", testRuns=" + this.getTestRuns() + ")";
    }

    public StatusUpdateResponse(Date lastLoaded, List<TestRunStatusUpdateResponse> testRuns) {
        this.lastLoaded = lastLoaded;
        this.testRuns = testRuns;
    }

    public static class BaseStatusUpdateResponse {
        protected UUID id;
        protected ExecutionStatuses executionStatus;
        protected TestingStatuses testingStatus;

        public UUID getId() {
            return this.id;
        }

        public ExecutionStatuses getExecutionStatus() {
            return this.executionStatus;
        }

        public TestingStatuses getTestingStatus() {
            return this.testingStatus;
        }

        public void setId(UUID id) {
            this.id = id;
        }

        public void setExecutionStatus(ExecutionStatuses executionStatus) {
            this.executionStatus = executionStatus;
        }

        public void setTestingStatus(TestingStatuses testingStatus) {
            this.testingStatus = testingStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseStatusUpdateResponse)) {
                return false;
            }
            BaseStatusUpdateResponse other = (BaseStatusUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            ExecutionStatuses this$executionStatus = this.getExecutionStatus();
            ExecutionStatuses other$executionStatus = other.getExecutionStatus();
            if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
                return false;
            }
            TestingStatuses this$testingStatus = this.getTestingStatus();
            TestingStatuses other$testingStatus = other.getTestingStatus();
            return !(this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaseStatusUpdateResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            ExecutionStatuses $executionStatus = this.getExecutionStatus();
            result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
            TestingStatuses $testingStatus = this.getTestingStatus();
            result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
            return result;
        }

        public String toString() {
            return "StatusUpdateResponse.BaseStatusUpdateResponse(id=" + this.getId() + ", executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ")";
        }

        public BaseStatusUpdateResponse(UUID id, ExecutionStatuses executionStatus, TestingStatuses testingStatus) {
            this.id = id;
            this.executionStatus = executionStatus;
            this.testingStatus = testingStatus;
        }

        public BaseStatusUpdateResponse() {
        }
    }

    public static class TestRunStatusUpdateResponse
    extends BaseStatusUpdateResponse {
        private List<BaseStatusUpdateResponse> logRecords;

        public TestRunStatusUpdateResponse(TestRun testRun, List<LogRecord> logRecords) {
            super(testRun.getUuid(), testRun.getExecutionStatus(), testRun.getTestingStatus());
            this.logRecords = !CollectionUtils.isEmpty(logRecords) ? logRecords.stream().map(logRecord -> new BaseStatusUpdateResponse(logRecord.getUuid(), logRecord.getExecutionStatus(), logRecord.getTestingStatus())).collect(Collectors.toList()) : Collections.emptyList();
        }

        public List<BaseStatusUpdateResponse> getLogRecords() {
            return this.logRecords;
        }

        public void setLogRecords(List<BaseStatusUpdateResponse> logRecords) {
            this.logRecords = logRecords;
        }

        @Override
        public String toString() {
            return "StatusUpdateResponse.TestRunStatusUpdateResponse(logRecords=" + this.getLogRecords() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestRunStatusUpdateResponse)) {
                return false;
            }
            TestRunStatusUpdateResponse other = (TestRunStatusUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<BaseStatusUpdateResponse> this$logRecords = this.getLogRecords();
            List<BaseStatusUpdateResponse> other$logRecords = other.getLogRecords();
            return !(this$logRecords == null ? other$logRecords != null : !((Object)this$logRecords).equals(other$logRecords));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof TestRunStatusUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<BaseStatusUpdateResponse> $logRecords = this.getLogRecords();
            result = result * 59 + ($logRecords == null ? 43 : ((Object)$logRecords).hashCode());
            return result;
        }
    }
}

