/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.entities.treenodes;

import java.util.UUID;
import org.qubership.atp.ram.entities.treenodes.TreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNodeType;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.TestRun;

public class TestRunTreeNode
extends TreeNode {
    private ExecutionStatuses executionStatus;
    private TestingStatuses testingStatus;
    private Integer passedRate;
    private UUID testRunId;
    private UUID testCaseId;
    private String testCaseName;
    private boolean isTestCaseRemoved;

    public TestRunTreeNode(TestRun testRun) {
        this.id = UUID.randomUUID();
        this.testRunId = testRun.getUuid();
        this.executionRequestId = testRun.getExecutionRequestId();
        this.name = testRun.getName();
        this.passedRate = testRun.getPassedRate();
        this.nodeType = TreeNodeType.TEST_RUN_NODE;
        this.executionStatus = testRun.getExecutionStatus();
        this.testingStatus = testRun.getTestingStatus();
        this.testCaseId = testRun.getTestCaseId();
        this.testCaseName = testRun.getTestCaseName();
        this.isTestCaseRemoved = false;
    }

    public TestRunTreeNode(TestRun testRun, boolean isTestCaseAlive) {
        this.id = UUID.randomUUID();
        this.testRunId = testRun.getUuid();
        this.executionRequestId = testRun.getExecutionRequestId();
        this.name = testRun.getName();
        this.passedRate = testRun.getPassedRate();
        this.nodeType = TreeNodeType.TEST_RUN_NODE;
        this.executionStatus = testRun.getExecutionStatus();
        this.testingStatus = testRun.getTestingStatus();
        this.testCaseId = testRun.getTestCaseId();
        this.testCaseName = testRun.getTestCaseName();
        this.isTestCaseRemoved = !isTestCaseAlive;
    }

    public TestRunTreeNode(String name) {
        super(name);
    }

    public ExecutionStatuses getExecutionStatus() {
        return this.executionStatus;
    }

    public TestingStatuses getTestingStatus() {
        return this.testingStatus;
    }

    public Integer getPassedRate() {
        return this.passedRate;
    }

    public UUID getTestRunId() {
        return this.testRunId;
    }

    public UUID getTestCaseId() {
        return this.testCaseId;
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public boolean isTestCaseRemoved() {
        return this.isTestCaseRemoved;
    }

    public void setExecutionStatus(ExecutionStatuses executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setTestingStatus(TestingStatuses testingStatus) {
        this.testingStatus = testingStatus;
    }

    public void setPassedRate(Integer passedRate) {
        this.passedRate = passedRate;
    }

    public void setTestRunId(UUID testRunId) {
        this.testRunId = testRunId;
    }

    public void setTestCaseId(UUID testCaseId) {
        this.testCaseId = testCaseId;
    }

    public void setTestCaseName(String testCaseName) {
        this.testCaseName = testCaseName;
    }

    public void setTestCaseRemoved(boolean isTestCaseRemoved) {
        this.isTestCaseRemoved = isTestCaseRemoved;
    }

    @Override
    public String toString() {
        return "TestRunTreeNode(executionStatus=" + (Object)((Object)this.getExecutionStatus()) + ", testingStatus=" + (Object)((Object)this.getTestingStatus()) + ", passedRate=" + this.getPassedRate() + ", testRunId=" + this.getTestRunId() + ", testCaseId=" + this.getTestCaseId() + ", testCaseName=" + this.getTestCaseName() + ", isTestCaseRemoved=" + this.isTestCaseRemoved() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRunTreeNode)) {
            return false;
        }
        TestRunTreeNode other = (TestRunTreeNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isTestCaseRemoved() != other.isTestCaseRemoved()) {
            return false;
        }
        Integer this$passedRate = this.getPassedRate();
        Integer other$passedRate = other.getPassedRate();
        if (this$passedRate == null ? other$passedRate != null : !((Object)this$passedRate).equals(other$passedRate)) {
            return false;
        }
        ExecutionStatuses this$executionStatus = this.getExecutionStatus();
        ExecutionStatuses other$executionStatus = other.getExecutionStatus();
        if (this$executionStatus == null ? other$executionStatus != null : !((Object)((Object)this$executionStatus)).equals((Object)other$executionStatus)) {
            return false;
        }
        TestingStatuses this$testingStatus = this.getTestingStatus();
        TestingStatuses other$testingStatus = other.getTestingStatus();
        if (this$testingStatus == null ? other$testingStatus != null : !((Object)((Object)this$testingStatus)).equals((Object)other$testingStatus)) {
            return false;
        }
        UUID this$testRunId = this.getTestRunId();
        UUID other$testRunId = other.getTestRunId();
        if (this$testRunId == null ? other$testRunId != null : !((Object)this$testRunId).equals(other$testRunId)) {
            return false;
        }
        UUID this$testCaseId = this.getTestCaseId();
        UUID other$testCaseId = other.getTestCaseId();
        if (this$testCaseId == null ? other$testCaseId != null : !((Object)this$testCaseId).equals(other$testCaseId)) {
            return false;
        }
        String this$testCaseName = this.getTestCaseName();
        String other$testCaseName = other.getTestCaseName();
        return !(this$testCaseName == null ? other$testCaseName != null : !this$testCaseName.equals(other$testCaseName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestRunTreeNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isTestCaseRemoved() ? 79 : 97);
        Integer $passedRate = this.getPassedRate();
        result = result * 59 + ($passedRate == null ? 43 : ((Object)$passedRate).hashCode());
        ExecutionStatuses $executionStatus = this.getExecutionStatus();
        result = result * 59 + ($executionStatus == null ? 43 : ((Object)((Object)$executionStatus)).hashCode());
        TestingStatuses $testingStatus = this.getTestingStatus();
        result = result * 59 + ($testingStatus == null ? 43 : ((Object)((Object)$testingStatus)).hashCode());
        UUID $testRunId = this.getTestRunId();
        result = result * 59 + ($testRunId == null ? 43 : ((Object)$testRunId).hashCode());
        UUID $testCaseId = this.getTestCaseId();
        result = result * 59 + ($testCaseId == null ? 43 : ((Object)$testCaseId).hashCode());
        String $testCaseName = this.getTestCaseName();
        result = result * 59 + ($testCaseName == null ? 43 : $testCaseName.hashCode());
        return result;
    }

    public TestRunTreeNode() {
    }
}

