/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.enums;

public enum TestingStatuses {
    STOPPED("Stopped", 5, 6),
    FAILED("Failed", 4, 3),
    WARNING("Warning", 3, 2),
    PASSED("Passed", 2, 1),
    SKIPPED("Skipped", 1, 4),
    BLOCKED("Blocked", 1, 5),
    NOT_STARTED("Not Started", 1, 7),
    UNKNOWN("Unknown", 0, 8);

    private String name;
    private int id;
    private int reportsOrder;

    private TestingStatuses(String name, int id, int reportsOrder) {
        this.name = name;
        this.id = id;
        this.reportsOrder = reportsOrder;
    }

    public static TestingStatuses findByValue(String value) {
        for (TestingStatuses status : TestingStatuses.values()) {
            if (!status.toString().equalsIgnoreCase(value)) continue;
            return status;
        }
        return null;
    }

    public static TestingStatuses findByName(String value) {
        for (TestingStatuses status : TestingStatuses.values()) {
            if (!status.getName().equalsIgnoreCase(value)) continue;
            return status;
        }
        return null;
    }

    public static TestingStatuses compareAndGetPriority(TestingStatuses first, TestingStatuses second) {
        return first.getId() >= second.getId() ? first : second;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getReportsOrder() {
        return this.reportsOrder;
    }
}

