/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import java.net.URI;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Comparator;
import org.javers.core.metamodel.annotation.Value;

@Value
public class JiraTicket
implements Comparable<JiraTicket> {
    private String url;
    private Timestamp createdDate;
    private Boolean resolved;

    public JiraTicket(String url) {
        this.url = url;
        this.createdDate = Timestamp.valueOf(LocalDateTime.now());
        this.resolved = false;
    }

    @Override
    public int compareTo(JiraTicket that) {
        int dateCompare = Comparator.comparing(JiraTicket::getResolved).compare(this, that);
        if (dateCompare != 0) {
            return dateCompare;
        }
        return Comparator.comparing(JiraTicket::getCreatedDate).reversed().compare(this, that);
    }

    public String getKey() {
        String path = new URI(this.url).getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public String getUrl() {
        return this.url;
    }

    public Timestamp getCreatedDate() {
        return this.createdDate;
    }

    public Boolean getResolved() {
        return this.resolved;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCreatedDate(Timestamp createdDate) {
        this.createdDate = createdDate;
    }

    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JiraTicket)) {
            return false;
        }
        JiraTicket other = (JiraTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$resolved = this.getResolved();
        Boolean other$resolved = other.getResolved();
        if (this$resolved == null ? other$resolved != null : !((Object)this$resolved).equals(other$resolved)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Timestamp this$createdDate = this.getCreatedDate();
        Timestamp other$createdDate = other.getCreatedDate();
        return !(this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JiraTicket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $resolved = this.getResolved();
        result = result * 59 + ($resolved == null ? 43 : ((Object)$resolved).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Timestamp $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        return result;
    }

    public String toString() {
        return "JiraTicket(url=" + this.getUrl() + ", createdDate=" + this.getCreatedDate() + ", resolved=" + this.getResolved() + ")";
    }

    public JiraTicket(String url, Timestamp createdDate, Boolean resolved) {
        this.url = url;
        this.createdDate = createdDate;
        this.resolved = resolved;
    }

    public JiraTicket() {
    }
}

