/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.UUID;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.ram.models.DateAuditorEntity;
import org.qubership.atp.ram.models.WidgetType;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Document(collection="reporttemplates")
@TypeName(value="reporttemplates")
public class ReportTemplate
extends DateAuditorEntity {
    @DiffInclude
    private List<WidgetType> widgets;
    @Indexed(name="project_id_idx")
    private UUID projectId;
    @DiffInclude
    private boolean active;
    @NotBlank
    @DiffInclude
    private String subject;
    @DiffInclude
    private List<@Email String> recipients;

    public ReportTemplate(@NotBlank String subject, List<@Email String> recipients, List<WidgetType> widgets, boolean active) {
        this.widgets = widgets;
        this.active = active;
        this.subject = subject;
        this.recipients = recipients;
    }

    public List<WidgetType> getWidgets() {
        return this.widgets;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<@Email String> getRecipients() {
        return this.recipients;
    }

    public void setWidgets(List<WidgetType> widgets) {
        this.widgets = widgets;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setRecipients(List<@Email String> recipients) {
        this.recipients = recipients;
    }

    @Override
    public String toString() {
        return "ReportTemplate(widgets=" + this.getWidgets() + ", projectId=" + this.getProjectId() + ", active=" + this.isActive() + ", subject=" + this.getSubject() + ", recipients=" + this.getRecipients() + ")";
    }

    public ReportTemplate() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportTemplate)) {
            return false;
        }
        ReportTemplate other = (ReportTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isActive() != other.isActive()) {
            return false;
        }
        List<WidgetType> this$widgets = this.getWidgets();
        List<WidgetType> other$widgets = other.getWidgets();
        if (this$widgets == null ? other$widgets != null : !((Object)this$widgets).equals(other$widgets)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        List<String> this$recipients = this.getRecipients();
        List<String> other$recipients = other.getRecipients();
        return !(this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReportTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isActive() ? 79 : 97);
        List<WidgetType> $widgets = this.getWidgets();
        result = result * 59 + ($widgets == null ? 43 : ((Object)$widgets).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        List<String> $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        return result;
    }
}

