/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models.logrecords.parts;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.qubership.atp.ram.RamConstants;
import org.qubership.atp.ram.models.logrecords.parts.RequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Request {
    private static final Logger log = LoggerFactory.getLogger(Request.class);
    private String endpoint;
    private String method;
    private Map<String, String> headers;
    private List<RequestHeader> headersList;
    private Timestamp timestamp;
    private String body;
    private boolean htmlBody;

    public Request(String endpoint, String method, Map<String, String> headers, List<RequestHeader> headersList, Timestamp timestamp, String body) {
        this.endpoint = endpoint;
        this.method = method;
        this.headers = headers;
        this.headersList = headersList;
        this.timestamp = timestamp;
        this.body = body;
        this.htmlBody = false;
    }

    public String toString() {
        try {
            return RamConstants.OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            log.error("Can not parse Request(endpoint = {}; method = {}; headers = {}; timestamp = {}; body = {}) to json.", new Object[]{this.endpoint, this.method, this.headers, this.timestamp, this.body, e});
            return "";
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<RequestHeader> getHeadersList() {
        return this.headersList;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isHtmlBody() {
        return this.htmlBody;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setHeadersList(List<RequestHeader> headersList) {
        this.headersList = headersList;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setHtmlBody(boolean htmlBody) {
        this.htmlBody = htmlBody;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHtmlBody() != other.isHtmlBody()) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        List<RequestHeader> this$headersList = this.getHeadersList();
        List<RequestHeader> other$headersList = other.getHeadersList();
        if (this$headersList == null ? other$headersList != null : !((Object)this$headersList).equals(other$headersList)) {
            return false;
        }
        Timestamp this$timestamp = this.getTimestamp();
        Timestamp other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHtmlBody() ? 79 : 97);
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        List<RequestHeader> $headersList = this.getHeadersList();
        result = result * 59 + ($headersList == null ? 43 : ((Object)$headersList).hashCode());
        Timestamp $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public Request(String endpoint, String method, Map<String, String> headers, List<RequestHeader> headersList, Timestamp timestamp, String body, boolean htmlBody) {
        this.endpoint = endpoint;
        this.method = method;
        this.headers = headers;
        this.headersList = headersList;
        this.timestamp = timestamp;
        this.body = body;
        this.htmlBody = htmlBody;
    }

    public Request() {
    }
}

