/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models.tree;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.util.CollectionUtils;

public class TreeWalker<T> {
    private void walk(T root, Function<T, List<T>> childrenSupplier, Consumer<T> walkConsumer) {
        List<T> rootChildren = childrenSupplier.apply(root);
        if (!CollectionUtils.isEmpty(rootChildren)) {
            rootChildren.forEach(walkConsumer);
        }
    }

    public void walkWithPreProcess(T root, Function<T, List<T>> childrenSupplier, BiConsumer<T, T> preOperation) {
        preOperation.accept(null, root);
        this.walk(root, childrenSupplier, child -> this.walkWithPreProcess(root, child, childrenSupplier, preOperation));
    }

    private void walkWithPreProcess(T root, T child, Function<T, List<T>> childrenSupplier, BiConsumer<T, T> callBeforeChildren) {
        callBeforeChildren.accept(root, child);
        this.processChildren(child, childrenSupplier, subChild -> this.walkWithPreProcess(child, subChild, childrenSupplier, callBeforeChildren));
    }

    public void walkWithPostProcess(T root, Function<T, List<T>> childrenSupplier, BiConsumer<T, T> pastOperation) {
        this.walk(root, childrenSupplier, child -> this.walkWithPostProcess(root, child, childrenSupplier, pastOperation));
        pastOperation.accept(null, root);
    }

    private void walkWithPostProcess(T root, T child, Function<T, List<T>> childrenSupplier, BiConsumer<T, T> callAfterChildren) {
        this.processChildren(child, childrenSupplier, subChild -> this.walkWithPostProcess(child, subChild, childrenSupplier, callAfterChildren));
        callAfterChildren.accept(root, child);
    }

    private void processChildren(T child, Function<T, List<T>> childrenSupplier, Consumer<T> callConsumer) {
        List<T> children = childrenSupplier.apply(child);
        if (!CollectionUtils.isEmpty(children)) {
            children.forEach(callConsumer);
        }
    }
}

