/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.dto.filters;

import java.util.Objects;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.ram.dto.filters.AbstractFilter;
import org.qubership.atp.ram.dto.filters.FilterUtils;
import org.qubership.atp.ram.dto.filters.types.FilterType;
import org.qubership.atp.ram.dto.filters.types.SingleValueFilterType;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestIllegalFilterParameterException;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestUnexpectedFilterTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;

public class NumberFilter
extends AbstractFilter {
    private static final Logger log = LoggerFactory.getLogger(NumberFilter.class);
    public static final String TYPE = "NumberFilter";
    private FilterType filterType;
    private SingleValueFilterType valueFilterType;
    private Integer from;
    private Integer to;

    @Override
    public Criteria buildFilterCriteriaForField(String field) {
        if (Objects.isNull(this.from) && Objects.isNull(this.to)) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamExecutionRequestIllegalFilterParameterException());
        }
        switch (this.filterType) {
            case VALUE: {
                switch (this.valueFilterType) {
                    case FROM: {
                        return FilterUtils.getCriteriaLessOrMoreThanValue(field, this.valueFilterType, this.from);
                    }
                    case TO: {
                        return FilterUtils.getCriteriaLessOrMoreThanValue(field, this.valueFilterType, this.to);
                    }
                }
                log.error("Unexpected execution request filter type: {}", (Object)this.valueFilterType);
                throw new RamExecutionRequestUnexpectedFilterTypeException(this.valueFilterType.name());
            }
            case RANGE: {
                return new Criteria().andOperator(new Criteria[]{Criteria.where((String)field).lte((Object)this.to), Criteria.where((String)field).gte((Object)this.from)});
            }
        }
        log.error("Unexpected execution request filter type: {}", (Object)this.filterType);
        throw new RamExecutionRequestUnexpectedFilterTypeException(this.filterType.name());
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public SingleValueFilterType getValueFilterType() {
        return this.valueFilterType;
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getTo() {
        return this.to;
    }

    public void setFilterType(FilterType filterType) {
        this.filterType = filterType;
    }

    public void setValueFilterType(SingleValueFilterType valueFilterType) {
        this.valueFilterType = valueFilterType;
    }

    public void setFrom(Integer from) {
        this.from = from;
    }

    public void setTo(Integer to) {
        this.to = to;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NumberFilter)) {
            return false;
        }
        NumberFilter other = (NumberFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$from = this.getFrom();
        Integer other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Integer this$to = this.getTo();
        Integer other$to = other.getTo();
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        FilterType this$filterType = this.getFilterType();
        FilterType other$filterType = other.getFilterType();
        if (this$filterType == null ? other$filterType != null : !((Object)((Object)this$filterType)).equals((Object)other$filterType)) {
            return false;
        }
        SingleValueFilterType this$valueFilterType = this.getValueFilterType();
        SingleValueFilterType other$valueFilterType = other.getValueFilterType();
        return !(this$valueFilterType == null ? other$valueFilterType != null : !((Object)((Object)this$valueFilterType)).equals((Object)other$valueFilterType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NumberFilter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Integer $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        FilterType $filterType = this.getFilterType();
        result = result * 59 + ($filterType == null ? 43 : ((Object)((Object)$filterType)).hashCode());
        SingleValueFilterType $valueFilterType = this.getValueFilterType();
        result = result * 59 + ($valueFilterType == null ? 43 : ((Object)((Object)$valueFilterType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "NumberFilter(filterType=" + (Object)((Object)this.getFilterType()) + ", valueFilterType=" + (Object)((Object)this.getValueFilterType()) + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

