/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.DefectPriority;
import org.qubership.atp.ram.models.JiraTicket;
import org.qubership.atp.ram.models.RamObject;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import org.springframework.util.CollectionUtils;

@Document(collection="issue")
public class Issue
extends RamObject {
    public static final String COLLECTION_NAME = "issue";
    public static final String PRIORITY_FIELD = "priority";
    public static final String JIRA_TICKETS_FIELD = "jiraTickets";
    public static final String JIRA_DEFECTS_FIELD = "jiraDefects";
    public static final String FAIL_PATTERN_ID_FIELD = "failPatternId";
    public static final String FAIL_REASON_ID_FIELD = "failReasonId";
    public static final String MESSAGE_FIELD = "message";
    public static final String FAILED_TEST_RUNS_IDS_FIELD = "failedTestRunIds";
    public static final String FAILED_TEST_RUNS_COUNT_FIELD = "failedTestRunsCount";
    public static final String LOG_RECORD_IDS_FIELD = "logRecordIds";
    public static final String EXECUTION_REQUEST_ID_FIELD = "executionRequestId";
    private DefectPriority priority;
    @Field(value="jiraTickets")
    private List<String> jiraTickets;
    private List<JiraTicket> jiraDefects;
    @Field(value="failPatternId")
    private UUID failPatternId;
    @Field(value="failReasonId")
    private UUID failReasonId;
    @Field(value="message")
    private String message;
    @Field(value="failedTestRunIds")
    private List<UUID> failedTestRunIds;
    @Field(value="logRecordIds")
    private List<UUID> logRecordIds;
    @Field(value="executionRequestId")
    @Indexed(background=true)
    private UUID executionRequestId;
    @Field(value="failedTestRunsCount")
    private int failedTestRunsCount;

    public void propagateJiraTickets() {
        if (!CollectionUtils.isEmpty(this.jiraDefects)) {
            this.jiraTickets = this.jiraDefects.stream().map(JiraTicket::getUrl).collect(Collectors.toList());
        }
    }

    public DefectPriority getPriority() {
        return this.priority;
    }

    public List<String> getJiraTickets() {
        return this.jiraTickets;
    }

    public List<JiraTicket> getJiraDefects() {
        return this.jiraDefects;
    }

    public UUID getFailPatternId() {
        return this.failPatternId;
    }

    public UUID getFailReasonId() {
        return this.failReasonId;
    }

    public String getMessage() {
        return this.message;
    }

    public List<UUID> getFailedTestRunIds() {
        return this.failedTestRunIds;
    }

    public List<UUID> getLogRecordIds() {
        return this.logRecordIds;
    }

    public UUID getExecutionRequestId() {
        return this.executionRequestId;
    }

    public int getFailedTestRunsCount() {
        return this.failedTestRunsCount;
    }

    public void setPriority(DefectPriority priority) {
        this.priority = priority;
    }

    public void setJiraTickets(List<String> jiraTickets) {
        this.jiraTickets = jiraTickets;
    }

    public void setJiraDefects(List<JiraTicket> jiraDefects) {
        this.jiraDefects = jiraDefects;
    }

    public void setFailPatternId(UUID failPatternId) {
        this.failPatternId = failPatternId;
    }

    public void setFailReasonId(UUID failReasonId) {
        this.failReasonId = failReasonId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setFailedTestRunIds(List<UUID> failedTestRunIds) {
        this.failedTestRunIds = failedTestRunIds;
    }

    public void setLogRecordIds(List<UUID> logRecordIds) {
        this.logRecordIds = logRecordIds;
    }

    public void setExecutionRequestId(UUID executionRequestId) {
        this.executionRequestId = executionRequestId;
    }

    public void setFailedTestRunsCount(int failedTestRunsCount) {
        this.failedTestRunsCount = failedTestRunsCount;
    }

    @Override
    public String toString() {
        return "Issue(priority=" + (Object)((Object)this.getPriority()) + ", jiraTickets=" + this.getJiraTickets() + ", jiraDefects=" + this.getJiraDefects() + ", failPatternId=" + this.getFailPatternId() + ", failReasonId=" + this.getFailReasonId() + ", message=" + this.getMessage() + ", failedTestRunIds=" + this.getFailedTestRunIds() + ", logRecordIds=" + this.getLogRecordIds() + ", executionRequestId=" + this.getExecutionRequestId() + ", failedTestRunsCount=" + this.getFailedTestRunsCount() + ")";
    }

    public Issue(DefectPriority priority, List<String> jiraTickets, List<JiraTicket> jiraDefects, UUID failPatternId, UUID failReasonId, String message, List<UUID> failedTestRunIds, List<UUID> logRecordIds, UUID executionRequestId, int failedTestRunsCount) {
        this.priority = priority;
        this.jiraTickets = jiraTickets;
        this.jiraDefects = jiraDefects;
        this.failPatternId = failPatternId;
        this.failReasonId = failReasonId;
        this.message = message;
        this.failedTestRunIds = failedTestRunIds;
        this.logRecordIds = logRecordIds;
        this.executionRequestId = executionRequestId;
        this.failedTestRunsCount = failedTestRunsCount;
    }

    public Issue() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        Issue other = (Issue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFailedTestRunsCount() != other.getFailedTestRunsCount()) {
            return false;
        }
        DefectPriority this$priority = this.getPriority();
        DefectPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !((Object)((Object)this$priority)).equals((Object)other$priority)) {
            return false;
        }
        List<String> this$jiraTickets = this.getJiraTickets();
        List<String> other$jiraTickets = other.getJiraTickets();
        if (this$jiraTickets == null ? other$jiraTickets != null : !((Object)this$jiraTickets).equals(other$jiraTickets)) {
            return false;
        }
        List<JiraTicket> this$jiraDefects = this.getJiraDefects();
        List<JiraTicket> other$jiraDefects = other.getJiraDefects();
        if (this$jiraDefects == null ? other$jiraDefects != null : !((Object)this$jiraDefects).equals(other$jiraDefects)) {
            return false;
        }
        UUID this$failPatternId = this.getFailPatternId();
        UUID other$failPatternId = other.getFailPatternId();
        if (this$failPatternId == null ? other$failPatternId != null : !((Object)this$failPatternId).equals(other$failPatternId)) {
            return false;
        }
        UUID this$failReasonId = this.getFailReasonId();
        UUID other$failReasonId = other.getFailReasonId();
        if (this$failReasonId == null ? other$failReasonId != null : !((Object)this$failReasonId).equals(other$failReasonId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<UUID> this$failedTestRunIds = this.getFailedTestRunIds();
        List<UUID> other$failedTestRunIds = other.getFailedTestRunIds();
        if (this$failedTestRunIds == null ? other$failedTestRunIds != null : !((Object)this$failedTestRunIds).equals(other$failedTestRunIds)) {
            return false;
        }
        List<UUID> this$logRecordIds = this.getLogRecordIds();
        List<UUID> other$logRecordIds = other.getLogRecordIds();
        if (this$logRecordIds == null ? other$logRecordIds != null : !((Object)this$logRecordIds).equals(other$logRecordIds)) {
            return false;
        }
        UUID this$executionRequestId = this.getExecutionRequestId();
        UUID other$executionRequestId = other.getExecutionRequestId();
        return !(this$executionRequestId == null ? other$executionRequestId != null : !((Object)this$executionRequestId).equals(other$executionRequestId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Issue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFailedTestRunsCount();
        DefectPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)((Object)$priority)).hashCode());
        List<String> $jiraTickets = this.getJiraTickets();
        result = result * 59 + ($jiraTickets == null ? 43 : ((Object)$jiraTickets).hashCode());
        List<JiraTicket> $jiraDefects = this.getJiraDefects();
        result = result * 59 + ($jiraDefects == null ? 43 : ((Object)$jiraDefects).hashCode());
        UUID $failPatternId = this.getFailPatternId();
        result = result * 59 + ($failPatternId == null ? 43 : ((Object)$failPatternId).hashCode());
        UUID $failReasonId = this.getFailReasonId();
        result = result * 59 + ($failReasonId == null ? 43 : ((Object)$failReasonId).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<UUID> $failedTestRunIds = this.getFailedTestRunIds();
        result = result * 59 + ($failedTestRunIds == null ? 43 : ((Object)$failedTestRunIds).hashCode());
        List<UUID> $logRecordIds = this.getLogRecordIds();
        result = result * 59 + ($logRecordIds == null ? 43 : ((Object)$logRecordIds).hashCode());
        UUID $executionRequestId = this.getExecutionRequestId();
        result = result * 59 + ($executionRequestId == null ? 43 : ((Object)$executionRequestId).hashCode());
        return result;
    }
}

