/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.RamObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="jointExecutionRequests")
public class JointExecutionRequest
extends RamObject {
    private static final Logger log = LoggerFactory.getLogger(JointExecutionRequest.class);
    private String key;
    private Integer count;
    private Integer timeout;
    private List<Run> runs = new ArrayList<Run>();
    private Timestamp startDate;
    private Status status;
    private String logs;

    public void upsertRun(ExecutionRequest executionRequest) {
        this.upsertRun(executionRequest.getUuid(), executionRequest.getExecutionStatus());
    }

    public void upsertRun(UUID executionRequestId, ExecutionStatuses status) {
        log.info("Upsert joint execution run for ER '{}' with execution status: {}", (Object)executionRequestId, (Object)status);
        Map runsMap = this.runs.stream().collect(Collectors.toMap(Run::getExecutionRequestId, Function.identity()));
        runsMap.merge(executionRequestId, new Run(executionRequestId, status), (oldValue, newValue) -> newValue);
        this.runs = new ArrayList(runsMap.values());
        log.debug("Runs: {}", this.runs);
    }

    public List<UUID> getCompletedExecutionRequestIds() {
        HashSet completedStatuses = Sets.newHashSet((Object[])new ExecutionStatuses[]{ExecutionStatuses.FINISHED, ExecutionStatuses.TERMINATED, ExecutionStatuses.TERMINATED_BY_TIMEOUT});
        return this.runs.stream().filter(run -> completedStatuses.contains((Object)run.getStatus())).map(Run::getExecutionRequestId).collect(Collectors.toList());
    }

    public String getKey() {
        return this.key;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public List<Run> getRuns() {
        return this.runs;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getLogs() {
        return this.logs;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setRuns(List<Run> runs) {
        this.runs = runs;
    }

    public void setStartDate(Timestamp startDate) {
        this.startDate = startDate;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setLogs(String logs) {
        this.logs = logs;
    }

    @Override
    public String toString() {
        return "JointExecutionRequest(key=" + this.getKey() + ", count=" + this.getCount() + ", timeout=" + this.getTimeout() + ", runs=" + this.getRuns() + ", startDate=" + this.getStartDate() + ", status=" + (Object)((Object)this.getStatus()) + ", logs=" + this.getLogs() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JointExecutionRequest)) {
            return false;
        }
        JointExecutionRequest other = (JointExecutionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        List<Run> this$runs = this.getRuns();
        List<Run> other$runs = other.getRuns();
        if (this$runs == null ? other$runs != null : !((Object)this$runs).equals(other$runs)) {
            return false;
        }
        Timestamp this$startDate = this.getStartDate();
        Timestamp other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$logs = this.getLogs();
        String other$logs = other.getLogs();
        return !(this$logs == null ? other$logs != null : !this$logs.equals(other$logs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JointExecutionRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        List<Run> $runs = this.getRuns();
        result = result * 59 + ($runs == null ? 43 : ((Object)$runs).hashCode());
        Timestamp $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $logs = this.getLogs();
        result = result * 59 + ($logs == null ? 43 : $logs.hashCode());
        return result;
    }

    public static class Run {
        private UUID executionRequestId;
        private ExecutionStatuses status;

        public Run(ExecutionRequest executionRequest) {
            this.executionRequestId = executionRequest.getUuid();
            this.status = executionRequest.getExecutionStatus();
        }

        public UUID getExecutionRequestId() {
            return this.executionRequestId;
        }

        public ExecutionStatuses getStatus() {
            return this.status;
        }

        public void setExecutionRequestId(UUID executionRequestId) {
            this.executionRequestId = executionRequestId;
        }

        public void setStatus(ExecutionStatuses status) {
            this.status = status;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Run)) {
                return false;
            }
            Run other = (Run)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$executionRequestId = this.getExecutionRequestId();
            UUID other$executionRequestId = other.getExecutionRequestId();
            if (this$executionRequestId == null ? other$executionRequestId != null : !((Object)this$executionRequestId).equals(other$executionRequestId)) {
                return false;
            }
            ExecutionStatuses this$status = this.getStatus();
            ExecutionStatuses other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Run;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $executionRequestId = this.getExecutionRequestId();
            result = result * 59 + ($executionRequestId == null ? 43 : ((Object)$executionRequestId).hashCode());
            ExecutionStatuses $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            return result;
        }

        public String toString() {
            return "JointExecutionRequest.Run(executionRequestId=" + this.getExecutionRequestId() + ", status=" + (Object)((Object)this.getStatus()) + ")";
        }

        public Run(UUID executionRequestId, ExecutionStatuses status) {
            this.executionRequestId = executionRequestId;
            this.status = status;
        }

        public Run() {
        }
    }

    public static enum Status {
        COMPLETED,
        COMPLETED_BY_TIMEOUT,
        IN_PROGRESS,
        FAILED;

    }
}

