/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class LabelTemplate
implements Serializable {
    public static final String UNKNOWN = "Unknown";
    private UUID uuid;
    private String name;
    private UUID projectId;
    private List<LabelTemplateNode> labelNodes;
    @JsonIgnore
    private LabelTemplateNode unknownNode;

    public LabelTemplate createUnknownNode() {
        if (Objects.isNull(this.unknownNode)) {
            if (CollectionUtils.isEmpty(this.labelNodes)) {
                this.labelNodes = new ArrayList<LabelTemplateNode>();
            }
            this.unknownNode = new LabelTemplateNode(UNKNOWN);
            this.labelNodes.add(this.unknownNode);
        }
        return this;
    }

    public void addToUnknown(UUID testRunId, String error) {
        this.unknownNode.addTestRun(testRunId);
        this.unknownNode.errors.put(testRunId, error);
    }

    public LabelTemplate clone() {
        Gson gson = new Gson();
        return (LabelTemplate)gson.fromJson(gson.toJson((Object)this), LabelTemplate.class);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public List<LabelTemplateNode> getLabelNodes() {
        return this.labelNodes;
    }

    public LabelTemplateNode getUnknownNode() {
        return this.unknownNode;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setLabelNodes(List<LabelTemplateNode> labelNodes) {
        this.labelNodes = labelNodes;
    }

    @JsonIgnore
    public void setUnknownNode(LabelTemplateNode unknownNode) {
        this.unknownNode = unknownNode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelTemplate)) {
            return false;
        }
        LabelTemplate other = (LabelTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        List<LabelTemplateNode> this$labelNodes = this.getLabelNodes();
        List<LabelTemplateNode> other$labelNodes = other.getLabelNodes();
        if (this$labelNodes == null ? other$labelNodes != null : !((Object)this$labelNodes).equals(other$labelNodes)) {
            return false;
        }
        LabelTemplateNode this$unknownNode = this.getUnknownNode();
        LabelTemplateNode other$unknownNode = other.getUnknownNode();
        return !(this$unknownNode == null ? other$unknownNode != null : !((Object)this$unknownNode).equals(other$unknownNode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LabelTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        List<LabelTemplateNode> $labelNodes = this.getLabelNodes();
        result = result * 59 + ($labelNodes == null ? 43 : ((Object)$labelNodes).hashCode());
        LabelTemplateNode $unknownNode = this.getUnknownNode();
        result = result * 59 + ($unknownNode == null ? 43 : ((Object)$unknownNode).hashCode());
        return result;
    }

    public String toString() {
        return "LabelTemplate(uuid=" + this.getUuid() + ", name=" + this.getName() + ", projectId=" + this.getProjectId() + ", labelNodes=" + this.getLabelNodes() + ", unknownNode=" + this.getUnknownNode() + ")";
    }

    public static class LabelTemplateNode
    implements Serializable {
        private UUID labelId;
        private String labelName;
        private List<LabelTemplateNode> children;
        private Set<UUID> testRunIds = new HashSet<UUID>();
        private Map<UUID, String> errors = new HashMap<UUID, String>();
        private int passedRate;
        private int failedRate;
        private int testRunFailedCount;
        private int warningRate;
        private int testRunWarnedCount;
        private int testRunCount;
        private int testRunPassedCount;

        public LabelTemplateNode(UUID labelId, String labelName) {
            this.labelId = labelId;
            this.labelName = labelName;
        }

        public LabelTemplateNode(String labelName) {
            this.labelName = labelName;
        }

        public void addTestRun(UUID id) {
            this.testRunIds.add(id);
        }

        public UUID getLabelId() {
            return this.labelId;
        }

        public String getLabelName() {
            return this.labelName;
        }

        public List<LabelTemplateNode> getChildren() {
            return this.children;
        }

        public Set<UUID> getTestRunIds() {
            return this.testRunIds;
        }

        public Map<UUID, String> getErrors() {
            return this.errors;
        }

        public int getPassedRate() {
            return this.passedRate;
        }

        public int getFailedRate() {
            return this.failedRate;
        }

        public int getTestRunFailedCount() {
            return this.testRunFailedCount;
        }

        public int getWarningRate() {
            return this.warningRate;
        }

        public int getTestRunWarnedCount() {
            return this.testRunWarnedCount;
        }

        public int getTestRunCount() {
            return this.testRunCount;
        }

        public int getTestRunPassedCount() {
            return this.testRunPassedCount;
        }

        public void setLabelId(UUID labelId) {
            this.labelId = labelId;
        }

        public void setLabelName(String labelName) {
            this.labelName = labelName;
        }

        public void setChildren(List<LabelTemplateNode> children) {
            this.children = children;
        }

        public void setTestRunIds(Set<UUID> testRunIds) {
            this.testRunIds = testRunIds;
        }

        public void setErrors(Map<UUID, String> errors) {
            this.errors = errors;
        }

        public void setPassedRate(int passedRate) {
            this.passedRate = passedRate;
        }

        public void setFailedRate(int failedRate) {
            this.failedRate = failedRate;
        }

        public void setTestRunFailedCount(int testRunFailedCount) {
            this.testRunFailedCount = testRunFailedCount;
        }

        public void setWarningRate(int warningRate) {
            this.warningRate = warningRate;
        }

        public void setTestRunWarnedCount(int testRunWarnedCount) {
            this.testRunWarnedCount = testRunWarnedCount;
        }

        public void setTestRunCount(int testRunCount) {
            this.testRunCount = testRunCount;
        }

        public void setTestRunPassedCount(int testRunPassedCount) {
            this.testRunPassedCount = testRunPassedCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LabelTemplateNode)) {
                return false;
            }
            LabelTemplateNode other = (LabelTemplateNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPassedRate() != other.getPassedRate()) {
                return false;
            }
            if (this.getFailedRate() != other.getFailedRate()) {
                return false;
            }
            if (this.getTestRunFailedCount() != other.getTestRunFailedCount()) {
                return false;
            }
            if (this.getWarningRate() != other.getWarningRate()) {
                return false;
            }
            if (this.getTestRunWarnedCount() != other.getTestRunWarnedCount()) {
                return false;
            }
            if (this.getTestRunCount() != other.getTestRunCount()) {
                return false;
            }
            if (this.getTestRunPassedCount() != other.getTestRunPassedCount()) {
                return false;
            }
            UUID this$labelId = this.getLabelId();
            UUID other$labelId = other.getLabelId();
            if (this$labelId == null ? other$labelId != null : !((Object)this$labelId).equals(other$labelId)) {
                return false;
            }
            String this$labelName = this.getLabelName();
            String other$labelName = other.getLabelName();
            if (this$labelName == null ? other$labelName != null : !this$labelName.equals(other$labelName)) {
                return false;
            }
            List<LabelTemplateNode> this$children = this.getChildren();
            List<LabelTemplateNode> other$children = other.getChildren();
            if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
                return false;
            }
            Set<UUID> this$testRunIds = this.getTestRunIds();
            Set<UUID> other$testRunIds = other.getTestRunIds();
            if (this$testRunIds == null ? other$testRunIds != null : !((Object)this$testRunIds).equals(other$testRunIds)) {
                return false;
            }
            Map<UUID, String> this$errors = this.getErrors();
            Map<UUID, String> other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LabelTemplateNode;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPassedRate();
            result = result * 59 + this.getFailedRate();
            result = result * 59 + this.getTestRunFailedCount();
            result = result * 59 + this.getWarningRate();
            result = result * 59 + this.getTestRunWarnedCount();
            result = result * 59 + this.getTestRunCount();
            result = result * 59 + this.getTestRunPassedCount();
            UUID $labelId = this.getLabelId();
            result = result * 59 + ($labelId == null ? 43 : ((Object)$labelId).hashCode());
            String $labelName = this.getLabelName();
            result = result * 59 + ($labelName == null ? 43 : $labelName.hashCode());
            List<LabelTemplateNode> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            Set<UUID> $testRunIds = this.getTestRunIds();
            result = result * 59 + ($testRunIds == null ? 43 : ((Object)$testRunIds).hashCode());
            Map<UUID, String> $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
            return result;
        }

        public String toString() {
            return "LabelTemplate.LabelTemplateNode(labelId=" + this.getLabelId() + ", labelName=" + this.getLabelName() + ", children=" + this.getChildren() + ", testRunIds=" + this.getTestRunIds() + ", errors=" + this.getErrors() + ", passedRate=" + this.getPassedRate() + ", failedRate=" + this.getFailedRate() + ", testRunFailedCount=" + this.getTestRunFailedCount() + ", warningRate=" + this.getWarningRate() + ", testRunWarnedCount=" + this.getTestRunWarnedCount() + ", testRunCount=" + this.getTestRunCount() + ", testRunPassedCount=" + this.getTestRunPassedCount() + ")";
        }

        public LabelTemplateNode() {
        }
    }
}

