/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestCaseOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TestCase
extends RamObject {
    private static final Logger log = LoggerFactory.getLogger(TestCase.class);
    private List<TestCaseOrder> order;
    private UUID testScenarioUuid;
    private String jiraTicket;

    public TestCaseOrder findByScope(UUID testScopeId) {
        return Optional.of(this.order).orElseThrow(() -> {
            String errMsg = String.format("Cannot found order for test case '%s' in scope '%s'", this.getUuid(), testScopeId);
            log.error(errMsg);
            return new IllegalStateException(errMsg);
        }).stream().filter(order -> order.getTestScopeId().equals(testScopeId)).findFirst().orElseThrow(() -> {
            String errMsg = String.format("Cannot found order sequence for test case '%s' in scope '%s'", this.getUuid(), testScopeId);
            log.error(errMsg);
            return new IllegalStateException(errMsg);
        });
    }

    public List<TestCaseOrder> getOrder() {
        return this.order;
    }

    public UUID getTestScenarioUuid() {
        return this.testScenarioUuid;
    }

    public String getJiraTicket() {
        return this.jiraTicket;
    }

    public void setOrder(List<TestCaseOrder> order) {
        this.order = order;
    }

    public void setTestScenarioUuid(UUID testScenarioUuid) {
        this.testScenarioUuid = testScenarioUuid;
    }

    public void setJiraTicket(String jiraTicket) {
        this.jiraTicket = jiraTicket;
    }

    @Override
    public String toString() {
        return "TestCase(order=" + this.getOrder() + ", testScenarioUuid=" + this.getTestScenarioUuid() + ", jiraTicket=" + this.getJiraTicket() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestCase)) {
            return false;
        }
        TestCase other = (TestCase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<TestCaseOrder> this$order = this.getOrder();
        List<TestCaseOrder> other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        UUID this$testScenarioUuid = this.getTestScenarioUuid();
        UUID other$testScenarioUuid = other.getTestScenarioUuid();
        if (this$testScenarioUuid == null ? other$testScenarioUuid != null : !((Object)this$testScenarioUuid).equals(other$testScenarioUuid)) {
            return false;
        }
        String this$jiraTicket = this.getJiraTicket();
        String other$jiraTicket = other.getJiraTicket();
        return !(this$jiraTicket == null ? other$jiraTicket != null : !this$jiraTicket.equals(other$jiraTicket));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestCase;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<TestCaseOrder> $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        UUID $testScenarioUuid = this.getTestScenarioUuid();
        result = result * 59 + ($testScenarioUuid == null ? 43 : ((Object)$testScenarioUuid).hashCode());
        String $jiraTicket = this.getJiraTicket();
        result = result * 59 + ($jiraTicket == null ? 43 : $jiraTicket.hashCode());
        return result;
    }
}

