/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.UUID;
import org.qubership.atp.ram.entities.MailRecipients;
import org.qubership.atp.ram.models.RamObject;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="testplans")
@CompoundIndex(name="_id_projectId", def="{'_id': 1, 'projectId': 1}")
@JsonIgnoreProperties(ignoreUnknown=true)
public class TestPlan
extends RamObject {
    private UUID projectId;
    private MailRecipients recipients;
    private BugTrackingSystemSynchronization synchronization;

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestPlan)) {
            return false;
        }
        TestPlan other = (TestPlan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        MailRecipients this$recipients = this.getRecipients();
        MailRecipients other$recipients = other.getRecipients();
        if (this$recipients == null ? other$recipients != null : !((Object)this$recipients).equals(other$recipients)) {
            return false;
        }
        BugTrackingSystemSynchronization this$synchronization = this.getSynchronization();
        BugTrackingSystemSynchronization other$synchronization = other.getSynchronization();
        return !(this$synchronization == null ? other$synchronization != null : !((Object)this$synchronization).equals(other$synchronization));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestPlan;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        MailRecipients $recipients = this.getRecipients();
        result = result * 59 + ($recipients == null ? 43 : ((Object)$recipients).hashCode());
        BugTrackingSystemSynchronization $synchronization = this.getSynchronization();
        result = result * 59 + ($synchronization == null ? 43 : ((Object)$synchronization).hashCode());
        return result;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public MailRecipients getRecipients() {
        return this.recipients;
    }

    public BugTrackingSystemSynchronization getSynchronization() {
        return this.synchronization;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setRecipients(MailRecipients recipients) {
        this.recipients = recipients;
    }

    public void setSynchronization(BugTrackingSystemSynchronization synchronization) {
        this.synchronization = synchronization;
    }

    @Override
    public String toString() {
        return "TestPlan(projectId=" + this.getProjectId() + ", recipients=" + this.getRecipients() + ", synchronization=" + this.getSynchronization() + ")";
    }

    public static class BugTrackingSystemSynchronization {
        private String systemUrl;
        private String projectKey;

        public String getSystemUrl() {
            return this.systemUrl;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public void setSystemUrl(String systemUrl) {
            this.systemUrl = systemUrl;
        }

        public void setProjectKey(String projectKey) {
            this.projectKey = projectKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BugTrackingSystemSynchronization)) {
                return false;
            }
            BugTrackingSystemSynchronization other = (BugTrackingSystemSynchronization)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$systemUrl = this.getSystemUrl();
            String other$systemUrl = other.getSystemUrl();
            if (this$systemUrl == null ? other$systemUrl != null : !this$systemUrl.equals(other$systemUrl)) {
                return false;
            }
            String this$projectKey = this.getProjectKey();
            String other$projectKey = other.getProjectKey();
            return !(this$projectKey == null ? other$projectKey != null : !this$projectKey.equals(other$projectKey));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BugTrackingSystemSynchronization;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $systemUrl = this.getSystemUrl();
            result = result * 59 + ($systemUrl == null ? 43 : $systemUrl.hashCode());
            String $projectKey = this.getProjectKey();
            result = result * 59 + ($projectKey == null ? 43 : $projectKey.hashCode());
            return result;
        }

        public String toString() {
            return "TestPlan.BugTrackingSystemSynchronization(systemUrl=" + this.getSystemUrl() + ", projectKey=" + this.getProjectKey() + ")";
        }
    }
}

