/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.sleuth.zipkin2.ZipkinHttpClientSender;
import org.springframework.http.MediaType;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

abstract class HttpSender
extends Sender {
    final ZipkinHttpClientSender sender;
    final String url;
    final Encoding encoding;
    final MediaType mediaType;
    final BytesMessageEncoder messageEncoder;
    transient boolean closeCalled;

    HttpSender(ZipkinHttpClientSender sender, String baseUrl, String apiPath, BytesEncoder<Span> encoder) {
        this.sender = sender;
        this.encoding = encoder.encoding();
        if (encoder.equals((Object)SpanBytesEncoder.JSON_V2)) {
            this.mediaType = MediaType.APPLICATION_JSON;
            this.url = this.buildUrlWithCustomPathIfNecessary(baseUrl, apiPath, baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v2/spans");
        } else if (this.encoding == Encoding.PROTO3) {
            this.mediaType = MediaType.parseMediaType((String)"application/x-protobuf");
            this.url = this.buildUrlWithCustomPathIfNecessary(baseUrl, apiPath, baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v2/spans");
        } else if (this.encoding == Encoding.JSON) {
            this.mediaType = MediaType.APPLICATION_JSON;
            this.url = this.buildUrlWithCustomPathIfNecessary(baseUrl, apiPath, baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans");
        } else {
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding.name());
        }
        this.messageEncoder = BytesMessageEncoder.forEncoding((Encoding)this.encoding);
    }

    private String buildUrlWithCustomPathIfNecessary(String baseUrl, String customApiPath, String defaultUrl) {
        if (Objects.nonNull(customApiPath)) {
            return baseUrl + (baseUrl.endsWith("/") || customApiPath.startsWith("/") || customApiPath.isEmpty() ? "" : "/") + customApiPath;
        }
        return defaultUrl;
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("close");
        }
        return new HttpPostCall(this.messageEncoder.encode(encodedSpans));
    }

    public CheckResult check() {
        try {
            this.post(new byte[]{91, 93});
            return CheckResult.OK;
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void post(byte[] json) {
        this.sender.call(this.url, this.mediaType, json);
    }

    class HttpPostCall
    extends Call.Base<Void> {
        private final byte[] message;

        HttpPostCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            HttpSender.this.post(this.message);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                HttpSender.this.post(this.message);
                callback.onSuccess(null);
            }
            catch (Error | RuntimeException e) {
                callback.onError(e);
            }
        }

        public Call<Void> clone() {
            return new HttpPostCall(this.message);
        }
    }
}

