/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.services;

import java.security.Principal;
import java.util.Set;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterUtils;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.account.SimpleKeycloakAccount;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.common.VerificationException;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;

public class BearerTokenWebSocketAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(BearerTokenWebSocketAuthenticator.class);
    private final KeycloakConfigResolver keycloakConfigResolver;

    public Authentication authenticate(String tokenString) throws AuthenticationException {
        AccessToken accessToken;
        KeycloakDeployment deployment = this.keycloakConfigResolver.resolve(null);
        try {
            accessToken = this.verifyAndGetAccessToken(tokenString, deployment);
        }
        catch (VerificationException e) {
            log.debug("Exception authenticating the token {}:", (Object)tokenString, (Object)e);
            throw new BadCredentialsException("Invalid token.", (Throwable)e);
        }
        return this.completeBearerAuthentication(deployment, tokenString, accessToken);
    }

    public AccessToken verifyAndGetAccessToken(String tokenString, KeycloakDeployment deployment) throws VerificationException {
        return AdapterTokenVerifier.verifyToken((String)tokenString, (KeycloakDeployment)deployment);
    }

    private Authentication completeBearerAuthentication(KeycloakDeployment deployment, String tokenString, AccessToken accessToken) {
        RefreshableKeycloakSecurityContext session = new RefreshableKeycloakSecurityContext(deployment, null, tokenString, accessToken, null, null, null);
        KeycloakPrincipal principal = new KeycloakPrincipal(AdapterUtils.getPrincipalName((KeycloakDeployment)deployment, (AccessToken)accessToken), (KeycloakSecurityContext)session);
        RefreshableKeycloakSecurityContext securityContext = (RefreshableKeycloakSecurityContext)principal.getKeycloakSecurityContext();
        Set roles = AdapterUtils.getRolesFromSecurityContext((RefreshableKeycloakSecurityContext)securityContext);
        SimpleKeycloakAccount account = new SimpleKeycloakAccount((Principal)principal, roles, securityContext);
        KeycloakAuthenticationToken keycloakToken = new KeycloakAuthenticationToken((KeycloakAccount)account, false);
        SecurityContextHolder.getContext().setAuthentication((Authentication)keycloakToken);
        return keycloakToken;
    }

    public BearerTokenWebSocketAuthenticator(KeycloakConfigResolver keycloakConfigResolver) {
        this.keycloakConfigResolver = keycloakConfigResolver;
    }
}

