/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.TypeInfoRegistry;

class PropertyInfoRegistry {
    private static final Map<PropertyInfoKey, Mutator> MUTATOR_CACHE = new ConcurrentHashMap<PropertyInfoKey, Mutator>();
    private static final Map<PropertyInfoKey, Accessor> ACCESSOR_CACHE = new ConcurrentHashMap<PropertyInfoKey, Accessor>();
    private static final Map<PropertyInfoKey, PropertyInfoImpl.FieldPropertyInfo> FIELD_CACHE = new ConcurrentHashMap<PropertyInfoKey, PropertyInfoImpl.FieldPropertyInfo>();

    PropertyInfoRegistry() {
    }

    static Accessor accessorFor(Class<?> type, String accessorName, InheritingConfiguration configuration) {
        PropertyInfoKey key = new PropertyInfoKey(type, accessorName, configuration);
        if (!ACCESSOR_CACHE.containsKey(key) && !FIELD_CACHE.containsKey(key)) {
            Class<?> uncheckedType = type;
            for (Map.Entry<String, Accessor> entry : TypeInfoRegistry.typeInfoFor(uncheckedType, configuration).getAccessors().entrySet()) {
                if (entry.getValue().getMember() instanceof Method) {
                    PropertyInfoRegistry.accessorFor(type, (Method)entry.getValue().getMember(), configuration, entry.getKey());
                    continue;
                }
                if (!(entry.getValue().getMember() instanceof Field)) continue;
                PropertyInfoRegistry.fieldPropertyFor(type, (Field)entry.getValue().getMember(), configuration, entry.getKey());
            }
        }
        if (ACCESSOR_CACHE.containsKey(key)) {
            return ACCESSOR_CACHE.get(key);
        }
        return FIELD_CACHE.get(key);
    }

    static synchronized Accessor accessorFor(Class<?> type, Method method, Configuration configuration, String name) {
        PropertyInfoKey key = new PropertyInfoKey(type, name, configuration);
        Accessor accessor = ACCESSOR_CACHE.get(key);
        if (accessor == null) {
            accessor = new PropertyInfoImpl.MethodAccessor(type, method, name);
            ACCESSOR_CACHE.put(key, accessor);
        }
        return accessor;
    }

    static synchronized PropertyInfoImpl.FieldPropertyInfo fieldPropertyFor(Class<?> type, Field field, Configuration configuration, String name) {
        PropertyInfoKey key = new PropertyInfoKey(type, name, configuration);
        PropertyInfoImpl.FieldPropertyInfo fieldPropertyInfo = FIELD_CACHE.get(key);
        if (fieldPropertyInfo == null) {
            fieldPropertyInfo = new PropertyInfoImpl.FieldPropertyInfo(type, field, name);
            FIELD_CACHE.put(key, fieldPropertyInfo);
        }
        return fieldPropertyInfo;
    }

    static synchronized Mutator mutatorFor(Class<?> type, String name, InheritingConfiguration configuration) {
        PropertyInfoKey key = new PropertyInfoKey(type, name, configuration);
        if (!MUTATOR_CACHE.containsKey(key) && !FIELD_CACHE.containsKey(key)) {
            Class<?> uncheckedType = type;
            for (Map.Entry<String, Mutator> entry : TypeInfoRegistry.typeInfoFor(uncheckedType, configuration).getMutators().entrySet()) {
                if (entry.getValue().getMember() instanceof Method) {
                    PropertyInfoRegistry.mutatorFor(type, (Method)entry.getValue().getMember(), configuration, entry.getKey());
                    continue;
                }
                if (!(entry.getValue().getMember() instanceof Field)) continue;
                PropertyInfoRegistry.fieldPropertyFor(type, (Field)entry.getValue().getMember(), configuration, entry.getKey());
            }
        }
        if (MUTATOR_CACHE.containsKey(key)) {
            return MUTATOR_CACHE.get(key);
        }
        return FIELD_CACHE.get(key);
    }

    static synchronized Mutator mutatorFor(Class<?> type, Method method, Configuration configuration, String name) {
        PropertyInfoKey key = new PropertyInfoKey(type, name, configuration);
        Mutator mutator = MUTATOR_CACHE.get(key);
        if (mutator == null) {
            mutator = new PropertyInfoImpl.MethodMutator(type, method, name);
            MUTATOR_CACHE.put(key, mutator);
        }
        return mutator;
    }

    private static class PropertyInfoKey {
        private final Class<?> initialType;
        private final String propertyName;
        private final Configuration configuration;

        PropertyInfoKey(Class<?> initialType, String propertyName, Configuration configuration) {
            this.initialType = initialType;
            this.propertyName = propertyName;
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyInfoKey)) {
                return false;
            }
            PropertyInfoKey other = (PropertyInfoKey)o;
            return this.initialType.equals(other.initialType) && this.propertyName.equals(other.propertyName) && this.configuration.equals(other.configuration);
        }

        public int hashCode() {
            int result = 31 + this.initialType.hashCode();
            result = 31 * result + this.propertyName.hashCode();
            result = 31 * result + this.configuration.hashCode();
            return result;
        }
    }
}

