/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.cleanup.cleaner.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import liquibase.repackaged.net.sf.jsqlparser.parser.CCJSqlParserUtil;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.OracleCodec;
import org.owasp.esapi.reference.DefaultEncoder;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.exceptions.internal.TdmDeleteRowException;
import org.qubership.atp.tdm.model.cleanup.cleaner.TestDataCleaner;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.utils.TestDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SqlTestDataCleaner
implements TestDataCleaner {
    private static final Logger log = LoggerFactory.getLogger(SqlTestDataCleaner.class);
    private static final Pattern COLUMN_PATTERN = Pattern.compile("\\$\\{'([^']+)'}");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]{0,63}$");
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private int queryTimeout;
    private final Connection connection;
    private String query;
    private final Encoder esapiEncoder = DefaultEncoder.getInstance();
    private final OracleCodec oracleCodec = new OracleCodec();

    public SqlTestDataCleaner(@Nonnull Connection connection, @Nullable String query, int queryTimeout) {
        this.connection = connection;
        this.query = query;
        this.queryTimeout = queryTimeout;
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> runCleanup(@Nonnull TestDataTable testDataTable) throws Exception {
        Matcher m = COLUMN_PATTERN.matcher(this.query);
        ArrayList<String> columns = new ArrayList<String>();
        log.info("Original cleanup query: {}", (Object)this.query);
        while (m.find()) {
            String target = m.group();
            String column = m.group(1);
            this.validateIdentifier(column);
            int index = TestDataUtils.getIndexHeaderColumnByName(testDataTable, column);
            if (index < 0) {
                throw new IllegalArgumentException("Column '" + column + "' doesn't exist");
            }
            this.query = this.query.replace(target, "?").trim().toUpperCase(Locale.ROOT);
            Statement statement = CCJSqlParserUtil.parse((String)this.query);
            if (!(statement instanceof Select)) {
                throw new SecurityException("Only SELECT statements are allowed!");
            }
            log.debug("This is a SELECT query.");
            if (this.query.contains(";") || this.query.contains("--") || this.query.contains("/*")) {
                throw new SecurityException("Potentially dangerous SQL syntax");
            }
            String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, column);
            columns.add(sanitizedColumnName);
        }
        List<Map<String, Object>> rows = testDataTable.getData();
        if (rows.isEmpty()) {
            log.warn("Table body has no rows");
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> rowsToBeDeleted = new ArrayList<Map<String, Object>>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(this.query);){
            log.info("Cleanup query: {}", (Object)this.query);
            for (Map<String, Object> row : rows) {
                log.debug("Processing row #{}", row.get("ROW_ID"));
                for (int i = 0; i < columns.size(); ++i) {
                    String columnName = (String)columns.get(i);
                    preparedStatement.setString(i + 1, this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, String.valueOf(row.get(columnName))));
                }
                Map mdcContext = MDC.getCopyOfContextMap();
                try {
                    ResultSet rs = this.executorService.submit(() -> {
                        MdcUtils.setContextMap((Map)mdcContext);
                        return preparedStatement.executeQuery();
                    }).get(this.queryTimeout, TimeUnit.SECONDS);
                    try {
                        if (!rs.next()) {
                            log.debug("Row with id: {} will be marked for deleting", row.get("ROW_ID"));
                            rowsToBeDeleted.add(row);
                            continue;
                        }
                        log.debug("Row with id: {} will be skipped", row.get("ROW_ID"));
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                catch (TimeoutException e) {
                    throw new TimeoutException("SQL execution has been stopped as maximum time of execution in " + this.queryTimeout + " sec is exceeded.");
                }
                catch (SQLSyntaxErrorException e) {
                    throw new SQLSyntaxErrorException("Incorrect SQL syntax.", e);
                }
                catch (Exception e) {
                    log.error(String.format("Error while deleting row with id: %s from table: %s", row.get("ROW_ID"), testDataTable.getName()), (Throwable)e);
                    throw new TdmDeleteRowException(row.get("ROW_ID").toString(), testDataTable.getName());
                }
            }
            ArrayList<Map<String, Object>> arrayList = rowsToBeDeleted;
            return arrayList;
        }
    }

    private void validateIdentifier(String input) {
        if (!IDENTIFIER_PATTERN.matcher(input).matches()) {
            throw new IllegalArgumentException("Invalid SQL identifier: " + input);
        }
    }

    public SqlTestDataCleaner(Connection connection) {
        this.connection = connection;
    }
}

