/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.scheduler;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.qubership.atp.tdm.repo.DeletedTablesHistoryRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CleanRemovingHistoryJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CleanRemovingHistoryJob.class);
    @Autowired
    private DeletedTablesHistoryRepository deletedTablesHistoryRepository;
    @Value(value="${default.clean.removed.tables.months}")
    private int defaultHistoryExpirationMonths;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date dt = new Date();
        this.deletedTablesHistoryRepository.deleteByDeleteDateBefore(CleanRemovingHistoryJob.minusMonths(dt, this.defaultHistoryExpirationMonths));
    }

    private static Date minusMonths(Date dt, long days) {
        LocalDate localDate = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate newDate = localDate.minusMonths(days);
        return Date.from(newDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

