/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.model.scheduler;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.qubership.atp.integration.configuration.mdc.MdcField;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.service.mailsender.StatisticsMailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class StatisticsMailJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(StatisticsMailJob.class);
    @Autowired
    private StatisticsMailSender statisticsMailSender;

    public void execute(JobExecutionContext context) {
        MDC.clear();
        String projectId = context.getJobDetail().getKey().getName();
        try {
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (String)projectId);
            log.info("Running scheduled monitoring statistics job for project: {}", (Object)projectId);
            this.statisticsMailSender.send(projectId);
        }
        catch (Exception e) {
            log.error("An error occurred while running monitoring statistics job for project: {}", (Object)projectId, (Object)e);
        }
    }
}

