/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomExpression;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import com.healthmarketscience.sqlbuilder.custom.postgresql.PgBinaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.hibernate.boot.model.naming.IllegalIdentifierException;
import org.jetbrains.annotations.NotNull;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.codecs.Codec;
import org.owasp.esapi.codecs.OracleCodec;
import org.owasp.esapi.reference.DefaultEncoder;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.exceptions.TdmInternalException;
import org.qubership.atp.tdm.exceptions.db.TdmDbExecuteQueryException;
import org.qubership.atp.tdm.exceptions.db.TdmDbRowNotFoundException;
import org.qubership.atp.tdm.exceptions.file.TdmImportExcelTestDataException;
import org.qubership.atp.tdm.exceptions.file.TdmWriteFileException;
import org.qubership.atp.tdm.exceptions.internal.TdmCreateTestDataTableException;
import org.qubership.atp.tdm.exceptions.internal.TdmInsertDataException;
import org.qubership.atp.tdm.exceptions.internal.TdmTestDataOccupiedException;
import org.qubership.atp.tdm.model.ColumnValues;
import org.qubership.atp.tdm.model.DateFormatter;
import org.qubership.atp.tdm.model.ExportFileType;
import org.qubership.atp.tdm.model.ImportTestDataStatistic;
import org.qubership.atp.tdm.model.QueryInfo;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.model.table.TestDataTableFilter;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.model.table.conditions.factories.SearchConditionFactory;
import org.qubership.atp.tdm.model.table.conditions.search.SearchCondition;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.SqlRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.repo.impl.SystemColumns;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataExtractorProvider;
import org.qubership.atp.tdm.repo.impl.loader.TestDataExcelLoader;
import org.qubership.atp.tdm.utils.DataUtils;
import org.qubership.atp.tdm.utils.QueryEvaluator;
import org.qubership.atp.tdm.utils.TestDataTableCreator;
import org.qubership.atp.tdm.utils.TestDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class TestDataTableRepositoryImpl
implements TestDataTableRepository {
    private static final Logger log = LoggerFactory.getLogger(TestDataTableRepositoryImpl.class);
    private static final String ALTER_COLUMN_HARD_MODE = "hard";
    private static final Pattern INDEX_COLUMN_PATTERN = Pattern.compile("\\$\\{'([^']+)'}");
    private static final Integer UPDATE_TEST_DATA_LIMIT = 100;
    private static final String EXCEL_IMPORT_FILE_MASK = "ExcelForImport_%s.xlsx";
    private final JdbcTemplate jdbcTemplate;
    private final PlatformTransactionManager transactionManager;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private final SqlRepository sqlRepository;
    private final ImportInfoRepository importInfoRepository;
    private final TestDataExtractorProvider extractorProvider;
    private final QueryEvaluator queryEvaluator;
    private final CatalogRepository catalogRepository;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final LockManager lockManager;
    private ConcurrentHashMap<String, String> cacheLastUsageTable = new ConcurrentHashMap();
    @Value(value="${alter.column.mode}")
    private String alterColumnMode;
    @Value(value="${excel.import.directory}")
    private String excelImportDirectory;
    private final Encoder esapiEncoder = DefaultEncoder.getInstance();
    private final OracleCodec oracleCodec = new OracleCodec();

    @Autowired
    public TestDataTableRepositoryImpl(@Nonnull JdbcTemplate jdbcTemplate, @Nonnull PlatformTransactionManager transactionManager, @Nonnull SqlRepository sqlRepository, @Nonnull ImportInfoRepository importInfoRepository, @Nonnull TestDataExtractorProvider extractorProvider, @Nonnull QueryEvaluator queryEvaluator, @Nonnull CatalogRepository catalogRepository, @Nonnull CleanupConfigRepository cleanupConfigRepository, @Nonnull LockManager lockManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionManager = transactionManager;
        this.sqlRepository = sqlRepository;
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.importInfoRepository = importInfoRepository;
        this.extractorProvider = extractorProvider;
        this.queryEvaluator = queryEvaluator;
        this.catalogRepository = catalogRepository;
        this.cleanupConfigRepository = cleanupConfigRepository;
        this.lockManager = lockManager;
    }

    @Override
    public ImportTestDataStatistic importExcelTestData(@Nonnull String tableName, boolean exists, @Nonnull MultipartFile file) {
        DataUtils.checkTableName(tableName);
        long currentTimeMillis = System.currentTimeMillis();
        File destination = new File(this.excelImportDirectory + "/" + String.format(EXCEL_IMPORT_FILE_MASK, currentTimeMillis));
        this.writeFileOnDiscSpace(file, destination);
        try {
            ImportTestDataStatistic importTestDataStatistic;
            block13: {
                OPCPackage opcPackage = OPCPackage.open((File)destination);
                try {
                    log.debug("File: {} successfully opened.", (Object)destination.getName());
                    TestDataExcelLoader loader = new TestDataExcelLoader(opcPackage);
                    importTestDataStatistic = this.importTestData(tableName, exists, loader.process());
                    if (opcPackage == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (opcPackage != null) {
                            try {
                                opcPackage.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException | BadSqlGrammarException ex) {
                        log.error(String.format("Error occurred while execute sql-request. %s", ex.getMessage()), ex);
                        throw new TdmDbExecuteQueryException(ex.getMessage());
                    }
                    catch (TdmInternalException tdmInternalException) {
                        throw tdmInternalException;
                    }
                    catch (Exception e) {
                        log.error("Error occurred while working with excel file. %s", (Throwable)e);
                        throw new TdmImportExcelTestDataException(e.getMessage());
                    }
                }
                opcPackage.close();
            }
            return importTestDataStatistic;
        }
        finally {
            destination.delete();
        }
    }

    private void writeFileOnDiscSpace(MultipartFile sourceFile, File destinationFile) {
        log.debug("Writing file:{} to: {}", (Object)sourceFile.getName(), (Object)destinationFile.getName());
        try (FileOutputStream fileOutputStream = new FileOutputStream(destinationFile);){
            ((OutputStream)fileOutputStream).write(sourceFile.getBytes());
            log.debug("File writing success");
            sourceFile.getInputStream().close();
        }
        catch (Exception e) {
            log.error(String.format("Error while writing file: %s to: %s.  %s", sourceFile.getName(), destinationFile.getName(), e.getMessage()), (Throwable)e);
            throw new TdmWriteFileException(sourceFile.getName(), destinationFile.getName(), e.getMessage());
        }
    }

    @Override
    @Transactional
    public ImportTestDataStatistic importSqlTestData(final @Nonnull String tableName, final boolean exists, @Nonnull String query, @Nonnull Integer queryTimeout, @Nonnull Server server) {
        DataUtils.checkQuery(query);
        DataUtils.checkTableName(tableName);
        JdbcTemplate jdbcTemplate = this.sqlRepository.createJdbcTemplate(server, queryTimeout);
        final int batchSize = 100;
        final ArrayList<String> col = new ArrayList<String>();
        final ArrayList<Map<String, Object>> rowsBuf = new ArrayList<Map<String, Object>>();
        final AtomicReference<Integer> refRows = new AtomicReference<Integer>(0);
        try {
            jdbcTemplate.query(query, new RowCallbackHandler(){

                public void processRow(ResultSet resSet) throws SQLException {
                    if (col.isEmpty()) {
                        ResultSetMetaData metData = resSet.getMetaData();
                        int columnCount = metData.getColumnCount();
                        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                            col.add(metData.getColumnName(columnIndex));
                        }
                    }
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    for (String column : col) {
                        row.put(column, resSet.getObject(column));
                    }
                    rowsBuf.add(row);
                    if (rowsBuf.size() == batchSize) {
                        if ((Integer)refRows.get() > 0) {
                            TestDataTableRepositoryImpl.this.saveTestData(tableName, true, col, rowsBuf, false);
                        } else {
                            TestDataTableRepositoryImpl.this.saveTestData(tableName, exists, col, rowsBuf, true);
                        }
                        refRows.updateAndGet(v -> v + batchSize);
                        rowsBuf.clear();
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Error occurred while execute sql-request. %s", (Throwable)e);
            throw new TdmDbExecuteQueryException(e.getMessage());
        }
        if (!rowsBuf.isEmpty()) {
            this.saveTestData(tableName, exists || refRows.get() > 0, col, rowsBuf, refRows.get() > 0);
            refRows.updateAndGet(v -> v + rowsBuf.size());
        }
        if (refRows.get() == 0) {
            log.info("Import by sql. SQL request return 0 row. Table didn't create!");
            throw new TdmDbRowNotFoundException();
        }
        ImportTestDataStatistic statistic = new ImportTestDataStatistic();
        statistic.setProcessedRows(refRows.get());
        return statistic;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImportTestDataStatistic updateTableBySql(@Nonnull String tableName, @Nonnull String query, @Nonnull Integer queryTimeout, @Nonnull Server server) {
        log.info("Update test data table:[{}]. Query:[{}]", (Object)tableName, (Object)query);
        DataUtils.checkQuery(query);
        DataUtils.checkTableName(tableName);
        ImportTestDataStatistic statistic = new ImportTestDataStatistic();
        String conditionColumnNamePattern = "";
        String conditionColumnName = "";
        Matcher indexColumnMatcher = INDEX_COLUMN_PATTERN.matcher(query);
        while (indexColumnMatcher.find()) {
            conditionColumnNamePattern = indexColumnMatcher.group();
            conditionColumnName = indexColumnMatcher.group(1);
        }
        if (!conditionColumnNamePattern.equals("")) {
            List<String> queryColumnNames = TestDataUtils.getColumnsNamesFromQuery(query);
            List<String> existingColumns = this.getTableColumns(tableName);
            for (String queryColumnName : queryColumnNames) {
                if (existingColumns.contains(queryColumnName)) continue;
                String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
                String sanitizedQueryColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, queryColumnName);
                log.debug("Table:[{}]. Alter new column:[{}]", (Object)tableName, (Object)queryColumnName);
                this.jdbcTemplate.execute(String.format("ALTER TABLE %s ADD COLUMN IF NOT EXISTS \"%s\" VARCHAR", sanitizedTableName, sanitizedQueryColumnName));
            }
            Long rows = this.getTestDataSize(tableName, TestDataType.ALL);
            log.debug("Update test data. Column pattern:[{}], Column name:[{}]", (Object)conditionColumnNamePattern, (Object)conditionColumnName);
            try {
                Connection connection = this.sqlRepository.createConnection(server);
                try {
                    int countOfUpdatedRows = 0;
                    int offset = 0;
                    while ((long)offset < rows) {
                        TestDataTable testDataTable = this.getTestData(tableName, TestDataType.AVAILABLE, (Integer)offset, UPDATE_TEST_DATA_LIMIT, null, null);
                        for (Map<String, Object> row : testDataTable.getData()) {
                            String evaluatedQuery = query.replace(conditionColumnNamePattern, String.valueOf(row.get(conditionColumnName)));
                            try (CallableStatement statement = connection.prepareCall(evaluatedQuery);){
                                ExecutorService executorService = Executors.newSingleThreadExecutor();
                                Map mdcContext = MDC.getCopyOfContextMap();
                                try (ResultSet rs = executorService.submit(() -> {
                                    MdcUtils.setContextMap((Map)mdcContext);
                                    return statement.executeQuery();
                                }).get(queryTimeout.intValue(), TimeUnit.SECONDS);){
                                    while (rs.next()) {
                                        for (String columnName : queryColumnNames) {
                                            String value = rs.getString(columnName);
                                            row.put(columnName, value);
                                        }
                                    }
                                }
                            }
                            catch (TimeoutException e) {
                                statistic = new ImportTestDataStatistic();
                                String message = "SQL execution has been stopped as maximum time of execution in " + queryTimeout + " sec is exceeded.";
                                statistic.setError(message);
                                ImportTestDataStatistic importTestDataStatistic = statistic;
                                if (connection != null) {
                                    connection.close();
                                }
                                return importTestDataStatistic;
                            }
                            countOfUpdatedRows = (int)((long)countOfUpdatedRows + this.updateTableRow(tableName, queryColumnNames, row));
                        }
                        offset += UPDATE_TEST_DATA_LIMIT.intValue();
                    }
                    statistic.setProcessedRows(countOfUpdatedRows);
                }
                finally {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable) {
                            Throwable countOfUpdatedRows;
                            countOfUpdatedRows.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (Exception e) {
                statistic = new ImportTestDataStatistic();
                String message = "Error while updating table: " + tableName;
                log.error(message, (Throwable)e);
                statistic.setError(message + ". " + e.getMessage());
            }
            log.info("The update completed successfully.");
            return statistic;
        }
        statistic = new ImportTestDataStatistic();
        String message = "Error while updating table: " + tableName + ". You need to specify all new columns (select IMSI, OBJECT_ID) and column, which will be used to compare (where object_id=${'OBJECT_ID'}).";
        statistic.setError(message);
        return statistic;
    }

    private long updateTableRow(@Nonnull String tableName, @Nonnull List<String> columns, @Nonnull Map<String, Object> row) {
        UpdateQuery updateQuery = new UpdateQuery((Object)this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName));
        CustomSql customSql = new CustomSql((Object)("\"" + SystemColumns.ROW_ID.getName() + "\""));
        BinaryCondition binaryCondition = PgBinaryCondition.equalTo((Object)customSql, (Object)String.valueOf(row.get(SystemColumns.ROW_ID.getName())));
        updateQuery.addCondition((Condition)binaryCondition);
        for (String column : columns) {
            String value = TestDataUtils.escapeCharacters(String.valueOf(row.get(column)));
            updateQuery.addCustomSetClause((Object)new CustomSql((Object)("\"" + this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, column) + "\"")), (Object)this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, value));
        }
        return this.jdbcTemplate.update(updateQuery.toString());
    }

    private ImportTestDataStatistic importTestData(@Nonnull String tableName, boolean exists, @Nonnull TestDataTable testDataTable) {
        ImportTestDataStatistic statistic = new ImportTestDataStatistic();
        this.lockManager.executeWithLockWithUniqueLockKey("importTestData" + tableName, () -> {
            statistic.setProcessedRows(testDataTable.getData().size());
            this.saveTestData(tableName, exists, testDataTable);
        });
        return statistic;
    }

    @Override
    public TestDataTable getTestData(@Nonnull Boolean isOccupied, @Nonnull String tableName, @Nullable Integer offset, @Nullable Integer limit, @Nullable List<TestDataTableFilter> filters, @Nullable TestDataTableOrder order) {
        DataUtils.checkTableName(tableName);
        TestDataType testDataType = isOccupied != false ? TestDataType.OCCUPIED : TestDataType.AVAILABLE;
        return this.getTestData(tableName, testDataType, offset, limit, filters, order);
    }

    private TestDataTable getTestData(@Nonnull String tableName, @Nonnull TestDataType testDataType, @Nullable Integer offset, @Nullable Integer limit, @Nullable List<TestDataTableFilter> filters, @Nullable TestDataTableOrder testDataTableOrder) {
        TestDataTable table;
        QueryInfo.Builder queryInfoBuilder = QueryInfo.newBuilder(tableName, testDataType);
        if (Objects.nonNull(offset)) {
            queryInfoBuilder.setOffset(offset);
        }
        if (Objects.nonNull(limit)) {
            queryInfoBuilder.setLimit(limit);
        }
        if (Objects.nonNull(filters)) {
            queryInfoBuilder.setFilters(filters);
        }
        if (Objects.nonNull(testDataTableOrder)) {
            queryInfoBuilder.setOrder(testDataTableOrder);
        }
        QueryInfo queryInfo = queryInfoBuilder.build();
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        try {
            log.debug("Start DB query.");
            table = (TestDataTable)this.jdbcTemplate.query(queryInfo.getQuery().toString(), (ResultSetExtractor)this.extractorProvider.simpleExtractor(sanitizedTableName, queryInfo.getCountQuery().toString(), testDataType, testDataTableOrder));
            log.debug("Stop DB query.");
        }
        catch (Exception e) {
            log.error("Error occurred while execute sql-request. %s", (Throwable)e);
            throw new TdmDbExecuteQueryException(e.getMessage());
        }
        Optional testDataTableInfo = this.importInfoRepository.findById(sanitizedTableName);
        assert (table != null);
        testDataTableInfo.ifPresent(dataTableInfo -> {
            table.setQuery(dataTableInfo.getTableQuery());
            table.setUpdateByQuery(dataTableInfo.getUpdateByQuery());
        });
        table.setName(tableName);
        table.setType(testDataType);
        return table;
    }

    @Override
    public TestDataTable getTestData(@Nonnull String tableName, @Nonnull List<String> columnNames, @Nullable List<TestDataTableFilter> filters) {
        DataUtils.checkTableName(tableName);
        columnNames.forEach(DataUtils::checkColumnName);
        QueryInfo.Builder queryInfoBuilder = QueryInfo.newBuilder(tableName, columnNames, TestDataType.ALL);
        if (Objects.nonNull(filters)) {
            queryInfoBuilder.setFilters(filters);
        }
        QueryInfo queryInfo = queryInfoBuilder.build();
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        return (TestDataTable)this.jdbcTemplate.query(queryInfo.getQuery().toString(), (ResultSetExtractor)this.extractorProvider.simpleExtractor(sanitizedTableName, queryInfo.getCountQuery().toString(), TestDataType.ALL, null));
    }

    @Override
    public TestDataTable getTestDataMultiple(@Nonnull String tableName, @Nullable List<TestDataTableFilter> filters) {
        TestDataTable table;
        DataUtils.checkTableName(tableName);
        QueryInfo.Builder queryInfoBuilder = QueryInfo.newBuilder(tableName, TestDataType.AVAILABLE);
        queryInfoBuilder.setLimit(1);
        if (Objects.nonNull(filters)) {
            queryInfoBuilder.setFilters(filters);
        }
        QueryInfo queryInfo = queryInfoBuilder.build();
        try {
            log.debug("Start DB query.");
            table = (TestDataTable)this.jdbcTemplate.query(queryInfo.getQuery().toString(), (ResultSetExtractor)this.extractorProvider.multipleExtractor(tableName, TestDataType.AVAILABLE));
            log.debug("Finish DB query.");
        }
        catch (Exception e) {
            log.error("Error occurred while execute sql-request. %s", (Throwable)e);
            throw new TdmDbExecuteQueryException(e.getMessage());
        }
        assert (table != null);
        table.setName(tableName);
        return table;
    }

    @Override
    public TestDataTable getFullTestData(@Nonnull String tableName) {
        DataUtils.checkTableName(tableName);
        return this.getTestData(tableName, TestDataType.ALL, null, null, null, null);
    }

    @Override
    public File getTestDataTableAsExcel(@Nonnull String tableName, @Nullable Integer offset, @Nullable Integer limit, @Nullable List<TestDataTableFilter> filters) {
        QueryInfo queryInfo = QueryInfo.newBuilder(tableName, TestDataType.ALL).build();
        this.updateLastUsage(tableName);
        return (File)this.jdbcTemplate.query(queryInfo.getQuery().toString(), (ResultSetExtractor)this.extractorProvider.fileExtractor(tableName, ExportFileType.EXCEL));
    }

    @Override
    public File getTestDataTableAsCsv(@Nonnull String tableName, @Nullable Integer offset, @Nullable Integer limit, @Nullable List<TestDataTableFilter> filters) {
        QueryInfo queryInfo = QueryInfo.newBuilder(tableName, TestDataType.ALL).build();
        this.updateLastUsage(tableName);
        return (File)this.jdbcTemplate.query(queryInfo.getQuery().toString(), (ResultSetExtractor)this.extractorProvider.fileExtractor(tableName, ExportFileType.CSV));
    }

    @Override
    public TestDataTable saveTestData(@Nonnull String tableName, boolean exists, @Nonnull TestDataTable testDataTable) {
        DataUtils.checkTableName(tableName);
        List<String> columns = testDataTable.getColumns().stream().map(c -> c.getIdentity().getColumnName()).collect(Collectors.toList());
        this.saveTestData(tableName, exists, columns, testDataTable.getData(), false);
        return testDataTable;
    }

    private void saveTestData(@Nonnull String tableName, boolean exists, List<String> columns, List<Map<String, Object>> rows, boolean skipSchemaUpdate) {
        boolean systemColumnsExists;
        if (skipSchemaUpdate) {
            log.info("Saving test data to a database table with the name: [{}]", (Object)tableName);
        }
        if (exists && !skipSchemaUpdate) {
            this.alterMissingColumns(tableName, columns, "ALTER TABLE %s ADD COLUMN IF NOT EXISTS \"%s\" VARCHAR");
        }
        TestDataTableCreator tableCreator = new TestDataTableCreator(tableName);
        HashMap<String, DbColumn> dbColumns = new HashMap<String, DbColumn>();
        ArrayList<String> sanitizedColumns = new ArrayList<String>();
        for (String columnName : columns) {
            String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
            sanitizedColumns.add(sanitizedColumnName);
            dbColumns.put(sanitizedColumnName, tableCreator.buildColumn(sanitizedColumnName));
        }
        if (!exists) {
            log.info("Creating test data table with the name: [{}]", (Object)tableName);
            this.jdbcTemplate.execute(tableCreator.createTableQuery());
        }
        if (systemColumnsExists = this.isSystemColumnsExists(rows)) {
            List<String> columnNames = SystemColumns.getColumnNames();
            columnNames.forEach(c -> dbColumns.put((String)c, tableCreator.getDbColumns().get(c)));
        }
        if (!skipSchemaUpdate) {
            log.info("Saving test data. Processing rows. Table name: [{}]", (Object)tableName);
        }
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.jdbcTemplate.batchUpdate(TestDataUtils.generateInsertTemplate(sanitizedTableName, sanitizedColumns, systemColumnsExists), rows, Math.min(rows.size(), 100), (ps, row) -> {
            for (int ind = 1; ind <= columns.size(); ++ind) {
                Object rowValue = row.get(columns.get(ind - 1));
                if (rowValue instanceof String && !rowValue.equals("null")) {
                    ps.setObject(ind, String.valueOf(rowValue));
                    continue;
                }
                if (!(rowValue instanceof String) && rowValue != null) {
                    ps.setObject(ind, TestDataUtils.convertToJsonString(rowValue));
                    continue;
                }
                ps.setObject(ind, "");
            }
        });
        if (!skipSchemaUpdate) {
            log.info("Test data table saved.");
        }
    }

    private boolean isSystemColumnsExists(List<Map<String, Object>> rows) {
        if (rows.isEmpty()) {
            log.error("There is no data for TestDataTable creation.");
            throw new TdmCreateTestDataTableException();
        }
        return rows.get(0).containsKey(SystemColumns.ROW_ID.getName());
    }

    @Override
    public String occupyTestData(@Nonnull String tableName, @Nonnull String occupiedBy, @Nonnull List<UUID> rows) {
        DataUtils.checkColumnName(tableName);
        String date = DateFormatter.DB_DATE_FORMATTER.format(new Timestamp(new Date().getTime()));
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", rows);
        parameters.addValue("user", (Object)this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, occupiedBy));
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        try {
            int updatedRowsCount = this.namedParameterJdbcTemplate.update(String.format("update %s set \"SELECTED\" = true, \"OCCUPIED_BY\" = :user, \"OCCUPIED_DATE\" = '%s' where \"SELECTED\" = false and \"ROW_ID\" IN (:ids)", sanitizedTableName, date), (SqlParameterSource)parameters);
            if (updatedRowsCount == 0) {
                throw new TdmTestDataOccupiedException();
            }
        }
        catch (TdmInternalException atpTdmException) {
            throw atpTdmException;
        }
        catch (Exception e) {
            log.error("Error occurred while execute sql-request. %s", (Throwable)e);
            throw new TdmDbExecuteQueryException(e.getMessage());
        }
        return DateFormatter.DB_DATE_FORMATTER.format(new Timestamp(new Date().getTime()));
    }

    @Override
    public void releaseTestData(@Nonnull String tableName, @Nonnull List<UUID> rows) {
        DataUtils.checkColumnName(tableName);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("ids", rows);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.namedParameterJdbcTemplate.update(String.format("update %s set \"SELECTED\" = false, \"OCCUPIED_BY\" = '' where \"ROW_ID\" IN (:ids)", sanitizedTableName), (SqlParameterSource)parameters);
        this.updateLastUsage(sanitizedTableName);
    }

    @Override
    public void insertRows(@Nonnull String tableName, boolean exists, @Nonnull List<Map<String, Object>> rows, boolean skipSchemaUpdate) {
        DataUtils.checkTableName(tableName);
        ArrayList<String> columns = new ArrayList<String>(((Map)rows.stream().findFirst().orElseThrow(() -> new TdmInsertDataException())).keySet());
        this.saveTestData(tableName, exists, columns, rows, skipSchemaUpdate);
    }

    @Override
    public int updateRows(@Nonnull String tableName, @Nonnull List<TestDataTableFilter> filters, @Nonnull Map<String, String> dataForUpdate) {
        log.info("Updating rows in table with name: [{}]", (Object)tableName);
        DataUtils.checkTableName(tableName);
        UpdateQuery query = new UpdateQuery((Object)tableName);
        this.setWhereCondition(query, filters);
        for (String key : dataForUpdate.keySet()) {
            query.addCustomSetClause((Object)new CustomSql((Object)("\"" + key + "\"")), (Object)dataForUpdate.get(key));
        }
        return this.jdbcTemplate.update(query.toString());
    }

    @Override
    public int addInfoToRow(@Nonnull String tableName, @Nonnull List<TestDataTableFilter> filters, @Nonnull Map<String, String> dataForUpdate) {
        log.info("Adding info to row in table with name: [{}]", (Object)tableName);
        DataUtils.checkTableName(tableName);
        UpdateQuery query = new UpdateQuery((Object)tableName);
        this.setWhereCondition(query, filters);
        for (String key : dataForUpdate.keySet()) {
            query.addCustomSetClause((Object)new CustomSql((Object)("\"" + key + "\"")), (Object)new CustomExpression((Object)("CONCAT(\"" + key + "\",'\r\n" + dataForUpdate.get(key) + "')")));
        }
        return this.jdbcTemplate.update(query.toString());
    }

    @Override
    public void deleteRows(@Nonnull String tableName, @Nonnull List<UUID> rows) {
        log.info("Deleting rows from table with name: [{}]", (Object)tableName);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        DataUtils.checkColumnName(tableName);
        parameters.addValue("ids", rows);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.namedParameterJdbcTemplate.update(String.format("DELETE FROM %s where \"ROW_ID\" IN (:ids)", sanitizedTableName), (SqlParameterSource)parameters);
    }

    @Override
    public void deleteAllRows(@Nonnull String tableName) {
        log.info("Deleting all rows from table with name: [{}]", (Object)tableName);
        DataUtils.checkColumnName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.jdbcTemplate.execute(String.format("DELETE FROM %s", sanitizedTableName));
    }

    @Override
    public int deleteRowsByDate(@Nonnull String tableName, @Nonnull LocalDate date) {
        log.info("Deleting rows from table with name [{}] by date", (Object)tableName);
        DataUtils.checkColumnName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        return this.jdbcTemplate.update(String.format("DELETE FROM %s WHERE \"CREATED_WHEN\" <= TIMESTAMP '%s 23:59:59'", sanitizedTableName, date));
    }

    @Override
    public int getCountRows(@NotNull String tableName) {
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        return (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(*) FROM %s", sanitizedTableName), Integer.class);
    }

    @Override
    public void deleteUnoccupiedRows(@Nonnull String tableName) {
        log.info("Deleting unoccupied rows from table with name: [{}]", (Object)tableName);
        DataUtils.checkColumnName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.jdbcTemplate.execute(String.format("DELETE FROM %s where \"SELECTED\" = false", sanitizedTableName));
    }

    @Override
    public void alterCreatedWhenColumn(List<String> tableNames) {
        for (String tableName : tableNames) {
            DataUtils.checkTableName(tableName);
            this.alterMissingColumns(tableName, Collections.singletonList(SystemColumns.CREATED_WHEN.getName()), "ALTER TABLE %s ADD COLUMN IF NOT EXISTS \"%s\" TIMESTAMP");
        }
    }

    @Override
    public String evaluateQuery(@Nonnull String tableName, @Nonnull String query) {
        DataUtils.checkTableName(tableName);
        DataUtils.checkQuery(query);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        return this.queryEvaluator.evaluate(sanitizedTableName, query);
    }

    @Override
    public void dropTable(@Nonnull String tableName) {
        log.info("Dropping a table with name: [{}]", (Object)tableName);
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.jdbcTemplate.execute(String.format("DROP TABLE IF EXISTS %s CASCADE", sanitizedTableName));
    }

    @Override
    public void truncateTable(@Nonnull String tableName) {
        log.info("Truncating a table with name: [{}]", (Object)tableName);
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        this.jdbcTemplate.execute(String.format("TRUNCATE TABLE %s", sanitizedTableName));
    }

    @Override
    public void alterOccupiedByColumn(List<String> tableNames) {
        for (String tableName : tableNames) {
            DataUtils.checkTableName(tableName);
            String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
            this.alterMissingColumns(sanitizedTableName, Collections.singletonList("OCCUPIED_BY"), "ALTER TABLE %s ADD COLUMN IF NOT EXISTS \"%s\" VARCHAR");
        }
    }

    @Override
    public ColumnValues getColumnDistinctValues(@Nonnull String tableName, @Nonnull String columnName, Boolean occupied) {
        DataUtils.checkColumnName(columnName);
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
        if (occupied == null) {
            log.debug("GET_COLUMN_DISTINCT_VALUES");
            return new ColumnValues(this.jdbcTemplate.queryForList(String.format("SELECT DISTINCT \"%s\" FROM %s", sanitizedColumnName, sanitizedTableName), String.class));
        }
        log.debug("GET_COLUMN_DISTINCT_VALUES_BY_OCCUPIED");
        return new ColumnValues(this.jdbcTemplate.queryForList(String.format("SELECT DISTINCT \"%s\" FROM %s WHERE \"SELECTED\" = ?", sanitizedColumnName, sanitizedTableName), String.class, new Object[]{occupied}));
    }

    @Override
    public int getColumnDistinctValuesCount(@Nonnull String tableName, @Nonnull String columnName, String columnType, Boolean occupied) {
        DataUtils.checkColumnName(columnName);
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
        try {
            Integer columnValueSize;
            if (columnType.equals("varchar") && (columnValueSize = (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT character_length(\"%s\") FROM %s LIMIT 1", sanitizedColumnName, sanitizedTableName), Integer.class)) != null && columnValueSize > 50000) {
                return 50;
            }
        }
        catch (Exception e) {
            log.debug(String.format("Error by get character length for column: %s. Message: %s", columnName, e.getMessage()));
        }
        if (occupied == null) {
            log.debug("GET_COLUMN_DISTINCT_VALUES");
            return (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(DISTINCT \"%s\") FROM %s", sanitizedColumnName, sanitizedTableName), Integer.class);
        }
        return (Integer)this.jdbcTemplate.queryForObject(String.format("SELECT COUNT(DISTINCT \"%s\") FROM %s WHERE \"SELECTED\" = ?", sanitizedColumnName, sanitizedTableName), Integer.class, new Object[]{occupied});
    }

    @Override
    public TestDataTable getTableByCreatedWhen(@Nonnull String tableName, @Nonnull LocalDate dateFrom, @Nonnull LocalDate dateTo) {
        DataUtils.checkTableName(tableName);
        ArrayList<TestDataTableFilter> filters = new ArrayList<TestDataTableFilter>();
        TestDataTableFilter filterFrom = new TestDataTableFilter("CREATED_WHEN", "From", Collections.singletonList(dateFrom.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))), false);
        TestDataTableFilter filterTo = new TestDataTableFilter("CREATED_WHEN", "To", Collections.singletonList(dateTo.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))), false);
        filters.add(filterFrom);
        filters.add(filterTo);
        return this.getTestData(tableName, TestDataType.ALL, null, null, filters, null);
    }

    @Override
    public boolean changeTestDataTitle(@Nonnull String tableName, @Nullable String tableTitle) {
        log.info("Changing  test data table title. Table name: [{}], new title: [{}]", (Object)tableName, (Object)tableTitle);
        this.updateLastUsage(tableName);
        DataUtils.checkColumnName(tableTitle);
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("table_name", (Object)tableName);
        parameters.addValue("table_title", (Object)tableTitle);
        if (this.namedParameterJdbcTemplate.update("UPDATE test_data_table_catalog SET table_title = :table_title WHERE table_name = :table_name", (SqlParameterSource)parameters) > 0) {
            log.info("Test data title successfully changed.");
            return true;
        }
        log.warn("Test data title was not changed.");
        return false;
    }

    @Override
    public Long getTestDataSize(@Nonnull String tableName, @Nonnull TestDataType dataType) {
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        QueryInfo.Builder queryInfoBuilder = QueryInfo.newBuilder(sanitizedTableName, dataType);
        try {
            return (Long)this.jdbcTemplate.queryForObject(queryInfoBuilder.build().getCountQuery().toString(), Long.class);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private void setWhereCondition(UpdateQuery query, List<TestDataTableFilter> filters) {
        for (TestDataTableFilter filter : filters) {
            SearchCondition searchCondition = SearchConditionFactory.getCondition(filter.getSearchCondition(), filter.isCaseSensitive());
            CustomSql column = new CustomSql((Object)("\"" + filter.getColumn() + "\""));
            if (filter.getValues().isEmpty()) {
                throw new IllegalIdentifierException("There is no values in filter: " + filter);
            }
            String filterValue = filter.getValues().get(0);
            BinaryCondition binaryCondition = searchCondition.create(column, filterValue);
            query.addCondition((Condition)binaryCondition);
        }
    }

    private void alterMissingColumns(@Nonnull String tableName, @Nonnull List<String> columns, @Nonnull String query) {
        log.info("Checking for missing columns. Table: {}", (Object)tableName);
        List<String> existedColumnNames = this.getTableColumns(tableName);
        existedColumnNames.removeAll(SystemColumns.getColumnNames());
        ArrayList<String> columnsBuff = new ArrayList<String>(columns);
        columnsBuff.removeAll(existedColumnNames);
        if (!columnsBuff.isEmpty()) {
            log.info("Were found missing columns: {}", columnsBuff);
            if (ALTER_COLUMN_HARD_MODE.equals(this.alterColumnMode)) {
                this.recreateTable(tableName, columns);
            } else {
                columnsBuff.forEach(columnName -> {
                    String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
                    String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
                    String preparedQuery = String.format(query, sanitizedTableName, sanitizedColumnName);
                    this.jdbcTemplate.execute(preparedQuery);
                });
            }
            log.info("Missing columns successfully added.");
        }
    }

    private List<String> getTableColumns(@Nonnull String tableName) {
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        return this.jdbcTemplate.queryForList("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE UPPER(TABLE_NAME) = UPPER(?)", String.class, new Object[]{sanitizedTableName});
    }

    private void recreateTable(final @Nonnull String tableName, final @Nonnull List<String> columns) {
        log.info("Recreate Table: [{}], columns: [{}]", (Object)tableName, columns);
        final List<String> currentColumns = this.getTableColumns(tableName);
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            public void doInTransactionWithoutResult(@NotNull TransactionStatus status) {
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute("BEGIN WORK;");
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute(String.format("LOCK TABLE %s IN SHARE ROW EXCLUSIVE MODE;", tableName));
                String tmpTableName = tableName + "_";
                TestDataTableCreator tableCreator = new TestDataTableCreator(tmpTableName);
                columns.forEach(tableCreator::buildColumn);
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute(tableCreator.createTableQuery());
                String currentColumnNames = String.join((CharSequence)"\" , \"", currentColumns);
                String insertQuery = String.format("insert into %s (\"%s\") select \"%s\" from %s", tmpTableName, currentColumnNames, currentColumnNames, tableName);
                log.debug("Recreating table:[{}], data insert query:[{}]", (Object)tableName, (Object)insertQuery);
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute(insertQuery);
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute(String.format("DROP TABLE IF EXISTS %s CASCADE", tableName));
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute(String.format("ALTER TABLE %s RENAME TO %s;", tmpTableName, tableName));
                TestDataTableRepositoryImpl.this.jdbcTemplate.execute("COMMIT WORK;");
            }
        });
        log.info("Table: [{}] recreated.", (Object)tableName);
    }

    @Override
    public List<String> getTestDataTableCatalogDiscrepancyTestDataFlagsTable() {
        return this.jdbcTemplate.queryForList("select tc.table_name from test_data_table_catalog tc left join test_data_flags_table tf on tf.table_name = tc.table_name where tf.table_name is null", String.class);
    }

    @Override
    public List<String> getTestDataFlagsTableDiscrepancyTestDataTableCatalog() {
        return this.jdbcTemplate.queryForList("select tf.table_name from test_data_table_catalog tc right join test_data_flags_table tf on tf.table_name = tc.table_name where tc.table_name is null", String.class);
    }

    @Override
    public void saveTestDataTableCatalog(String tableName, String tableTitle, UUID projectId, UUID systemId, UUID environmentId) {
        TestDataTableCatalog tableCatalog = new TestDataTableCatalog(tableName, projectId, environmentId, systemId, tableTitle);
        tableCatalog.setLastUsage(new Date());
        this.getCleanupConfig(projectId, tableTitle).ifPresent(config -> tableCatalog.setCleanupConfigId(config.getId()));
        this.catalogRepository.save(tableCatalog);
    }

    private Optional<TestDataCleanupConfig> getCleanupConfig(@Nonnull UUID projectId, @Nonnull String tableTitle) {
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndTableTitleAndCleanupConfigIdIsNotNull(projectId, tableTitle);
        return catalogList.stream().map(c -> this.cleanupConfigRepository.findById(c.getCleanupConfigId()).orElse(new TestDataCleanupConfig())).filter(TestDataCleanupConfig::isShared).findFirst();
    }

    @Override
    public String getFirstRecordFromDataStorageTable(@Nonnull String tableName, @Nonnull String columnName) {
        DataUtils.checkColumnName(columnName);
        DataUtils.checkTableName(tableName);
        String sanitizedTableName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, tableName);
        String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
        return (String)this.jdbcTemplate.queryForObject(String.format("select \"%s\" from %s limit 1", sanitizedColumnName, sanitizedTableName), String.class);
    }

    @Override
    public void updateLastUsage(@Nonnull String tableName) {
        DataUtils.checkTableName(tableName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String currentDate = simpleDateFormat.format(new Date());
        if (this.cacheLastUsageTable.size() == 2000) {
            this.cacheLastUsageTable.clear();
        }
        if (!this.cacheLastUsageTable.containsKey(tableName) || !this.cacheLastUsageTable.get(tableName).equals(currentDate)) {
            Date lastUsage = this.catalogRepository.findByTableName(tableName).getLastUsage();
            if (lastUsage == null || !simpleDateFormat.format(lastUsage).equals(currentDate)) {
                this.catalogRepository.updateLastUsageByTableName(new Date(), tableName);
            }
            this.cacheLastUsageTable.put(tableName, currentDate);
        }
    }

    @Override
    public List<String> getTablesBySystemIdAndExistingColumn(@Nonnull UUID systemId, @Nonnull UUID environmentId, @Nonnull String columnName) {
        DataUtils.checkColumnName(columnName);
        String sanitizedColumnName = this.esapiEncoder.encodeForSQL((Codec)this.oracleCodec, columnName);
        return this.jdbcTemplate.queryForList("SELECT table_name FROM information_schema.COLUMNS WHERE table_name IN (SELECT LOWER(table_name) FROM test_data_table_catalog WHERE system_id = ? AND environment_id = ?) AND column_name = ?", String.class, new Object[]{systemId, environmentId, sanitizedColumnName});
    }

    @Override
    public List<String> getAllColumnNamesBySystemId(@NotNull UUID systemId) {
        return this.jdbcTemplate.queryForList("SELECT DISTINCT column_name FROM information_schema.COLUMNS WHERE table_name IN (SELECT LOWER(table_name) FROM test_data_table_catalog WHERE system_id = ?)", String.class, new Object[]{systemId});
    }
}

