/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.repo.impl.extractors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.tdm.model.ExportFileType;
import org.qubership.atp.tdm.model.table.TestDataTableOrder;
import org.qubership.atp.tdm.model.table.TestDataType;
import org.qubership.atp.tdm.repo.impl.extractors.ConsumedStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.GeneralStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.OutdatedStatisticsExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataTableAsFileExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataTableExtractor;
import org.qubership.atp.tdm.repo.impl.extractors.TestDataTableMultipleExtractor;
import org.qubership.atp.tdm.service.ColumnService;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class TestDataExtractorProvider {
    private final JdbcTemplate jdbcTemplate;
    private final ColumnService columnService;

    public TestDataTableExtractor simpleExtractor(@Nonnull String tableName, @Nonnull String countQuery) {
        return new TestDataTableExtractor(this.columnService, this.jdbcTemplate, tableName, countQuery);
    }

    public TestDataTableExtractor simpleExtractor(@Nonnull String tableName, @Nonnull String countQuery, @Nonnull TestDataType testDataType, @Nullable TestDataTableOrder testDataTableOrder) {
        return new TestDataTableExtractor(this.columnService, this.jdbcTemplate, tableName, countQuery, testDataType, testDataTableOrder);
    }

    public TestDataTableMultipleExtractor multipleExtractor(@Nonnull String tableName, @Nonnull TestDataType testDataType) {
        return new TestDataTableMultipleExtractor(this.columnService, tableName, testDataType);
    }

    public TestDataTableAsFileExtractor fileExtractor(@Nonnull String tableName, ExportFileType exportFileType) {
        return new TestDataTableAsFileExtractor(this.columnService, tableName, exportFileType);
    }

    public GeneralStatisticsExtractor generalStatisticsExtractor(@Nonnull String tableTitle) {
        return new GeneralStatisticsExtractor(tableTitle);
    }

    public OutdatedStatisticsExtractor outdatedStatisticsExtractor() {
        return new OutdatedStatisticsExtractor();
    }

    public ConsumedStatisticsExtractor consumedStatisticsExtractor() {
        return new ConsumedStatisticsExtractor();
    }

    public TestDataExtractorProvider(JdbcTemplate jdbcTemplate, ColumnService columnService) {
        this.jdbcTemplate = jdbcTemplate;
        this.columnService = columnService;
    }
}

