/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.impl;

import com.google.common.base.Preconditions;
import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.tdm.env.configurator.model.LazySystem;
import org.qubership.atp.tdm.env.configurator.model.Server;
import org.qubership.atp.tdm.env.configurator.service.EnvironmentsService;
import org.qubership.atp.tdm.exceptions.internal.TdmRunCleanupException;
import org.qubership.atp.tdm.exceptions.internal.TdmSearchCleanupConfigException;
import org.qubership.atp.tdm.exceptions.internal.TdmUndefinedCleanupCriteriaException;
import org.qubership.atp.tdm.mdc.MdcField;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.model.TestDataTableCatalog;
import org.qubership.atp.tdm.model.cleanup.CleanupResults;
import org.qubership.atp.tdm.model.cleanup.CleanupSettings;
import org.qubership.atp.tdm.model.cleanup.CleanupType;
import org.qubership.atp.tdm.model.cleanup.TestDataCleanupConfig;
import org.qubership.atp.tdm.model.cleanup.cleaner.TestDataCleaner;
import org.qubership.atp.tdm.model.cleanup.cleaner.impl.SqlTestDataCleaner;
import org.qubership.atp.tdm.model.scheduler.DataCleanupJob;
import org.qubership.atp.tdm.model.table.TestDataTable;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.repo.CleanupConfigRepository;
import org.qubership.atp.tdm.repo.ImportInfoRepository;
import org.qubership.atp.tdm.repo.SqlRepository;
import org.qubership.atp.tdm.repo.TestDataTableRepository;
import org.qubership.atp.tdm.service.CleanupService;
import org.qubership.atp.tdm.service.SchedulerService;
import org.qubership.atp.tdm.service.impl.MetricService;
import org.qubership.atp.tdm.utils.DataUtils;
import org.qubership.atp.tdm.utils.ValidateCronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CleanupServiceImpl
implements CleanupService {
    private static final Logger log = LoggerFactory.getLogger(CleanupServiceImpl.class);
    private static final String EMPTY_NAME = "EMPTY";
    private static final String SCHED_GROUP = "cleanup";
    @Value(value="${external.query.max.timeout:3600}")
    private Integer maxQueryTimeout;
    @Value(value="${external.query.default.timeout:1800}")
    private Integer defaultQueryTimeout;
    private final EnvironmentsService environmentsService;
    private final SchedulerService schedulerService;
    private final CleanupConfigRepository cleanupConfigRepository;
    private final TestDataTableRepository testDataTableRepository;
    private final CatalogRepository catalogRepository;
    private final SqlRepository sqlRepository;
    private final DataSource dataSource;
    private final ImportInfoRepository importInfoRepository;
    private final MetricService metricService;
    private final TdmMdcHelper tdmMdcHelper;
    private final Map<String, Class<? extends TestDataCleaner>> CLASS_METHOD_WHITE_LIST = new HashMap<String, Class<? extends TestDataCleaner>>();

    @Autowired
    public CleanupServiceImpl(@Nonnull EnvironmentsService environmentsService, @Nonnull SchedulerService schedulerService, @Nonnull CleanupConfigRepository repository, @Nonnull TestDataTableRepository testDataTableRepository, @Nonnull CatalogRepository catalogRepository, @Nonnull SqlRepository sqlRepository, @Nonnull DataSource dataSource, @Nonnull ImportInfoRepository importInfoRepository, @Nonnull MetricService metricService, TdmMdcHelper helper, List<TestDataCleaner> implementations) {
        this.environmentsService = environmentsService;
        this.schedulerService = schedulerService;
        this.cleanupConfigRepository = repository;
        this.testDataTableRepository = testDataTableRepository;
        this.catalogRepository = catalogRepository;
        this.sqlRepository = sqlRepository;
        this.dataSource = dataSource;
        this.importInfoRepository = importInfoRepository;
        this.metricService = metricService;
        this.tdmMdcHelper = helper;
        for (TestDataCleaner impl : implementations) {
            this.CLASS_METHOD_WHITE_LIST.put(impl.getClass().getSimpleName(), impl.getClass());
        }
    }

    @Override
    public TestDataCleanupConfig getCleanupConfig(@Nonnull UUID id) {
        return (TestDataCleanupConfig)this.cleanupConfigRepository.findById(id).orElseThrow(() -> new TdmSearchCleanupConfigException(id.toString()));
    }

    @Override
    public CleanupSettings getCleanupSettings(@Nonnull UUID id) {
        TestDataCleanupConfig cleanupConfig = this.getCleanupConfig(id);
        List<UUID> envId = this.catalogRepository.findAllByCleanupConfigId(id).stream().map(TestDataTableCatalog::getEnvironmentId).collect(Collectors.toList());
        return new CleanupSettings(cleanupConfig, envId, null);
    }

    @Override
    public CleanupSettings saveCleanupConfig(@Nonnull CleanupSettings cleanupSettings) throws Exception {
        log.info("Saving cleanup for table with name: {}", (Object)cleanupSettings.getTableName());
        TestDataCleanupConfig config = cleanupSettings.getTestDataCleanupConfig();
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)cleanupSettings.getTableName()), (Object)"Table Name is null");
        Preconditions.checkArgument((config.getQueryTimeout() != null && config.getQueryTimeout() > 0 && config.getQueryTimeout() <= this.maxQueryTimeout ? 1 : 0) != 0, (Object)"The timeout is not within the allowed range.\nRange: [1:3600]");
        ValidateCronExpression.validate(config.getSchedule());
        if (CleanupType.CLASS.equals((Object)config.getType())) {
            String searchClass = config.getSearchClass();
            if (this.CLASS_METHOD_WHITE_LIST.containsKey(searchClass)) {
                this.initCleaner(searchClass);
            } else {
                throw new SecurityException("Current search Class is not allowed here " + config.getSearchClass());
            }
        }
        if (CleanupType.SQL.equals((Object)config.getType())) {
            Preconditions.checkArgument((boolean)this.checkSqlAvailability(cleanupSettings.getTableName()), (Object)"Environment ins't set up properly to execute SQL queries");
        }
        log.info("Cleanup saved.");
        return this.saveCleanupConfiguration(cleanupSettings);
    }

    private CleanupSettings saveCleanupConfiguration(@Nonnull CleanupSettings cleanupSettings) {
        TestDataTableCatalog tableCatalog = this.catalogRepository.findByTableName(cleanupSettings.getTableName());
        TestDataCleanupConfig config = cleanupSettings.getTestDataCleanupConfig();
        if (Objects.nonNull(tableCatalog.getCleanupConfigId()) && config.isShared()) {
            config.setId(tableCatalog.getCleanupConfigId());
        } else {
            config.setId(UUID.randomUUID());
        }
        List<String> tablesWithSameName = this.getTablesByTableNameAndEnvironmentsListWithSameSystemName(cleanupSettings.getEnvironmentsList(), cleanupSettings.getTableName());
        tablesWithSameName.forEach(tableName -> {
            TestDataTableCatalog table = this.catalogRepository.findByTableName((String)tableName);
            if (config.isShared()) {
                this.setSharedCleanupConfig(table.getProjectId(), table.getTableTitle(), config.getId());
            }
            this.setCleanupConfig(table, config.getId());
        });
        this.cleanupConfigRepository.delete(config);
        this.cleanupConfigRepository.save(config);
        this.removeUnused();
        this.schedule(Collections.singletonList(config));
        return cleanupSettings;
    }

    private void setCleanupConfig(@Nonnull TestDataTableCatalog tableCatalog, @Nonnull UUID cleanupConfigId) {
        tableCatalog.setCleanupConfigId(cleanupConfigId);
        this.catalogRepository.save(tableCatalog);
    }

    private void setSharedCleanupConfig(@Nonnull UUID projectId, @Nonnull String tableTitle, @Nonnull UUID cleanupConfigId) {
        log.info("Setting shared cleanup for table with title: {}", (Object)tableTitle);
        List<TestDataTableCatalog> catalogList = this.catalogRepository.findAllByProjectIdAndTableTitle(projectId, tableTitle);
        catalogList.forEach(tableCatalog -> {
            tableCatalog.setCleanupConfigId(cleanupConfigId);
            this.catalogRepository.save(tableCatalog);
        });
        log.info("Shared cleanup saved.");
    }

    @Override
    public List<CleanupResults> runCleanup(@Nonnull UUID configId) throws Exception {
        TestDataCleanupConfig config;
        List<TestDataTableCatalog> catalogs = this.catalogRepository.findAllByCleanupConfigId(configId);
        Optional firstTable = catalogs.stream().findFirst();
        if (firstTable.isPresent()) {
            MdcUtils.put((String)MdcField.PROJECT_ID.toString(), (UUID)((TestDataTableCatalog)firstTable.get()).getProjectId());
            this.tdmMdcHelper.putConfigFields((TestDataTableCatalog)firstTable.get());
            this.metricService.executeCleanupJob(configId.toString(), ((TestDataTableCatalog)firstTable.get()).getProjectId(), ((TestDataTableCatalog)firstTable.get()).getTableTitle());
        }
        if ((config = this.getCleanupConfig(configId)).isEnabled()) {
            ArrayList<CleanupResults> cleanupResults = new ArrayList<CleanupResults>();
            ArrayList connectionRefusedEnvs = new ArrayList();
            catalogs.forEach(catalog -> {
                UUID environmentId = catalog.getEnvironmentId();
                try {
                    String tableName = catalog.getTableName();
                    if (!connectionRefusedEnvs.contains(environmentId)) {
                        log.info("Preparing to clean up with ID {}. Table: {}", (Object)configId, (Object)tableName);
                        cleanupResults.add(this.runCleanup(tableName, config));
                    } else {
                        log.warn("Can not establish connection for envId: {}, table: {}, cleanup ID: {}", new Object[]{environmentId, tableName, configId});
                    }
                }
                catch (Exception e) {
                    log.error("Error during scheduled clean up with ID: {}. Table: {}", new Object[]{configId, catalog.getTableName(), e});
                    connectionRefusedEnvs.add(environmentId);
                    cleanupResults.add(new CleanupResults(catalog.getTableName(), e.getMessage(), 0, 0));
                }
            });
            log.info("Cleanup has been finished.");
            return cleanupResults;
        }
        return new ArrayList<CleanupResults>();
    }

    @Override
    public List<CleanupResults> runCleanup(@Nonnull CleanupSettings cleanupSettings) {
        ArrayList<CleanupResults> cleanupResults = new ArrayList<CleanupResults>();
        ArrayList<UUID> connectionRefusedEnvs = new ArrayList<UUID>();
        List<String> cleanupTableNames = this.getTablesByTableNameAndEnvironmentsListWithSameSystemName(cleanupSettings.getEnvironmentsList(), cleanupSettings.getTableName());
        for (String cleanupTableName : cleanupTableNames) {
            this.testDataTableRepository.updateLastUsage(cleanupTableName);
            TestDataTableCatalog table = this.catalogRepository.findByTableName(cleanupTableName);
            UUID envId = table.getEnvironmentId();
            try {
                if (!connectionRefusedEnvs.contains(envId)) {
                    log.info("Preparing to clean up. Table: {}", (Object)cleanupTableName);
                    cleanupResults.add(this.runCleanup(cleanupTableName, cleanupSettings.getTestDataCleanupConfig()));
                    continue;
                }
                log.warn("Can not establish connection for envId: {}, table: {}, cleanup ID", (Object)envId, (Object)cleanupTableName);
            }
            catch (Exception e) {
                log.error("Error during scheduled clean up. Table: {}", (Object)cleanupTableName, (Object)e);
                connectionRefusedEnvs.add(envId);
                cleanupResults.add(new CleanupResults(cleanupTableName, e.getMessage(), 0, 0));
            }
        }
        return cleanupResults;
    }

    @Override
    public CleanupResults runCleanup(@Nonnull String tableName, @Nonnull TestDataCleanupConfig config) throws Exception {
        if (CleanupType.SQL.equals((Object)config.getType())) {
            CleanupResults cleanupResults;
            block13: {
                Server server = this.sqlRepository.getServer(tableName, this.catalogRepository, this.environmentsService);
                Connection connection = this.sqlRepository.createConnection(server);
                try {
                    if (config.getQueryTimeout() == null) {
                        int queryTimeout = (Integer)ObjectUtils.defaultIfNull((Object)this.importInfoRepository.findByTableName(tableName).getQueryTimeout(), (Object)this.defaultQueryTimeout);
                        config.setQueryTimeout(queryTimeout);
                    }
                    cleanupResults = this.runCleanup(tableName, new SqlTestDataCleaner(connection, config.getSearchSql(), config.getQueryTimeout()));
                    if (connection == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        log.error("Error while run cleanup.", (Throwable)ex);
                        throw new TdmRunCleanupException(ex.getMessage());
                    }
                }
                connection.close();
            }
            return cleanupResults;
        }
        if (CleanupType.CLASS.equals((Object)config.getType())) {
            String searchClass = config.getSearchClass();
            if (this.CLASS_METHOD_WHITE_LIST.containsKey(searchClass)) {
                TestDataCleaner cleaner = this.initCleaner(searchClass);
                return this.runCleanup(tableName, cleaner);
            }
            throw new SecurityException("Current search Class is not allowed here " + config.getSearchClass());
        }
        if (CleanupType.DATE.equals((Object)config.getType())) {
            LocalDate cleanupDate = DataUtils.calculateExpiredData(config.getSearchDate());
            return this.runCleanupByDate(tableName, cleanupDate);
        }
        log.error(String.format("Undefined cleanup search criteria for table: %s", tableName));
        throw new TdmUndefinedCleanupCriteriaException(tableName);
    }

    @Nonnull
    private CleanupResults runCleanup(@Nonnull String tableName, @Nonnull TestDataCleaner cleaner) throws Exception {
        CleanupResults results = new CleanupResults();
        TestDataTable table = this.testDataTableRepository.getFullTestData(tableName);
        results.setTableName(tableName);
        results.setRecordsTotal(table.getData().size());
        List<Map<String, Object>> cleanedRows = cleaner.runCleanup(table);
        if (cleanedRows.isEmpty()) {
            log.info("Nothing to clean up");
        } else {
            results.setRecordsRemoved(cleanedRows.size());
            log.info("Following data to be removed from database:\n" + cleanedRows.stream().map((Function<Map, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/util/Map;)Ljava/lang/String;)()).collect(Collectors.joining("; ")));
            List<UUID> rows = cleanedRows.stream().map(row -> UUID.fromString(String.valueOf(row.get("ROW_ID")))).collect(Collectors.toList());
            if (!rows.isEmpty()) {
                this.testDataTableRepository.deleteRows(tableName, rows);
            } else {
                log.info("There are no rows to delete.");
            }
        }
        return results;
    }

    @Nonnull
    private CleanupResults runCleanupByDate(@Nonnull String tableName, @Nonnull LocalDate cleanupDate) {
        CleanupResults results = new CleanupResults();
        results.setTableName(tableName);
        results.setRecordsTotal(this.testDataTableRepository.getCountRows(tableName));
        results.setRecordsRemoved(this.testDataTableRepository.deleteRowsByDate(tableName, cleanupDate));
        return results;
    }

    @Override
    public String getNextScheduledRun(String cronExpression) throws ParseException {
        CronExpression ce = new CronExpression(cronExpression);
        return ce.getNextValidTimeAfter(new Date()).toString();
    }

    @Override
    public void removeUnused() {
        this.cleanupConfigRepository.findAll().stream().map(TestDataCleanupConfig::getId).forEach(id -> {
            if (this.catalogRepository.findAllByCleanupConfigId((UUID)id).isEmpty()) {
                this.cleanupConfigRepository.deleteById(id);
                this.removeJob((UUID)id);
            }
        });
    }

    public void removeJob(@Nonnull UUID configId) {
        log.info("Removing active refresh job for config with id: {}", (Object)configId);
        JobKey jobKey = new JobKey(configId.toString(), SCHED_GROUP);
        this.schedulerService.deleteJob(jobKey);
        log.info("Stored refresh job with id [{}] successfully removed.", (Object)configId);
    }

    @Override
    public void fillCleanupTypeColumn() {
        this.cleanupConfigRepository.findAll().forEach(config -> {
            log.info("Trying to update cleanup type for cleanup: {}", (Object)config.getId());
            if (Objects.nonNull(config.getSearchDate())) {
                config.setType(CleanupType.DATE);
            } else if (Objects.nonNull(config.getSearchSql())) {
                config.setType(CleanupType.SQL);
            } else if (Objects.nonNull(config.getSearchClass())) {
                config.setType(CleanupType.CLASS);
            }
            this.cleanupConfigRepository.save(config);
            log.info("Updated cleanup type for cleanup: {}", (Object)config.getId());
        });
    }

    private boolean checkSqlAvailability(@Nonnull String tableName) {
        Server server = this.sqlRepository.getServer(tableName, this.catalogRepository, this.environmentsService);
        this.sqlRepository.createJdbcTemplate(server);
        return true;
    }

    private void schedule(@Nonnull List<TestDataCleanupConfig> configs) {
        log.info("Processing [{}] cleanup schedule request(s)", (Object)configs.size());
        for (TestDataCleanupConfig config : configs) {
            UUID configId = config.getId();
            log.info("Scheduling cleanup config " + config.toString());
            JobDetail job = JobBuilder.newJob(DataCleanupJob.class).withIdentity(configId.toString(), SCHED_GROUP).build();
            this.schedulerService.reschedule(job, config, SCHED_GROUP);
        }
        log.info("Cleanup scheduling successfully finished.");
    }

    @Nonnull
    private TestDataCleaner initCleaner(@Nullable String className) throws IllegalAccessException, InstantiationException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)className), (Object)"Class name is null or empty");
        Class<? extends TestDataCleaner> clazz = this.CLASS_METHOD_WHITE_LIST.get(className);
        if (!TestDataCleaner.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class '" + className + "' doesn't implement TestDataCleaner interface");
        }
        return clazz.newInstance();
    }

    public void initSchedules() {
        log.info("Starting jobs for stored cleanup configurations.");
        List<TestDataCleanupConfig> storedRequests = this.cleanupConfigRepository.findAll().stream().filter(TestDataCleanupConfig::isEnabled).collect(Collectors.toList());
        this.schedule(storedRequests);
        log.info("Stored cleanup jobs successfully started.");
    }

    @Override
    public List<String> getTablesByTableNameAndEnvironmentsListWithSameSystemName(@Nonnull List<UUID> environmentsList, @Nonnull String tableName) {
        TestDataTableCatalog testDataTable = this.catalogRepository.findByTableName(tableName);
        LazySystem sourceSystem = this.environmentsService.getLazySystemById(testDataTable.getSystemId());
        if (sourceSystem == null) {
            log.error("Cannot get system by ID {}", (Object)testDataTable.getSystemId());
            return Collections.emptyList();
        }
        List systemByProject = this.environmentsService.getLazySystemsByProjectWithEnvIds(testDataTable.getProjectId());
        List<UUID> systemsWithSameName = systemByProject.stream().filter(system -> system.getEnvironmentIds().stream().anyMatch(environmentsList::contains) && system.getName().equals(sourceSystem.getName())).map(LazySystem::getId).collect(Collectors.toList());
        List<String> tableNamesWithSameSystem = this.catalogRepository.findAllByProjectIdAndTableTitleAndSystemIdIn(testDataTable.getProjectId(), testDataTable.getTableTitle(), systemsWithSameName).stream().map(TestDataTableCatalog::getTableName).collect(Collectors.toList());
        return tableNamesWithSameSystem;
    }
}

