/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.service.notification.environments;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.qubership.atp.tdm.exceptions.kafka.TdmKafkaListenerReadEventException;
import org.qubership.atp.tdm.mdc.TdmMdcHelper;
import org.qubership.atp.tdm.repo.CatalogRepository;
import org.qubership.atp.tdm.service.TestDataService;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentEvent;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentEventListener;
import org.qubership.atp.tdm.service.notification.environments.EnvironmentEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.kafka.annotation.KafkaListener;

public class EnvironmentsEventKafkaListener
implements EnvironmentEventListener {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsEventKafkaListener.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TestDataService testDataService;
    private final CatalogRepository catalogRepository;
    private final TdmMdcHelper tdmMdcHelper;

    public EnvironmentsEventKafkaListener(@Nonnull TestDataService testDataService, @Nonnull CatalogRepository catalogRepository, TdmMdcHelper tdmMdcHelper) {
        this.testDataService = testDataService;
        this.catalogRepository = catalogRepository;
        this.tdmMdcHelper = tdmMdcHelper;
    }

    @Override
    @KafkaListener(topics={"${kafka.environments.topic}"})
    public void listen(String event) {
        EnvironmentEvent environmentEvent;
        MDC.clear();
        log.info("Kafka environment event: {}", (Object)event);
        try {
            environmentEvent = (EnvironmentEvent)this.objectMapper.readValue(event, EnvironmentEvent.class);
        }
        catch (IOException e) {
            log.error(String.format("Can't read event [ %s ]", event), (Throwable)e);
            throw new TdmKafkaListenerReadEventException(event);
        }
        this.tdmMdcHelper.putEnvironmentEventFields(environmentEvent);
        if (EnvironmentEventType.DELETE.equals((Object)environmentEvent.getEventType())) {
            log.info("Environment '{}' was deleted", (Object)environmentEvent.getId());
            this.catalogRepository.findByEnvironmentId(environmentEvent.getId()).forEach(x -> this.testDataService.deleteTestData(x.getTableName()));
        }
    }
}

