/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.qubership.atp.tdm.utils.DataUtils;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;

public class HttpUtils {
    private static final String TMP_DIR = "/tmp";

    public static ResponseEntity<InputStreamResource> buildFileResponseEntity(File file, String contentType) throws FileNotFoundException {
        if (file == null || !file.isFile()) {
            throw new FileNotFoundException(file == null ? "null" : file.getPath());
        }
        Path baseDir = Paths.get(TMP_DIR, new String[0]).toAbsolutePath().normalize();
        Path safePath = baseDir.resolve(file.getName()).normalize();
        if (!safePath.startsWith(baseDir)) {
            throw new SecurityException("Bad filename");
        }
        File safeFile = safePath.toFile();
        ResponseEntity body = ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Access-Control-Expose-Headers", new String[]{"Content-Disposition"})).header("Content-Disposition", new String[]{safeFile.getName()})).header("Content-Type", new String[]{contentType})).body((Object)new InputStreamResource((InputStream)new FileInputStream(file)));
        DataUtils.deleteFile(file.toPath());
        return body;
    }
}

