/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.tdm.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.qubership.atp.tdm.exceptions.file.TdmBuildCvsFileException;
import org.qubership.atp.tdm.model.table.column.TestDataTableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataTableConvertor {
    private static final Logger log = LoggerFactory.getLogger(TestDataTableConvertor.class);
    private static final String TEST_TABLE_NAME_PREFIX = "TDM_";
    private static final String EXCEL_EXT = ".xlsx";
    private static final String CSV_EXT = ".csv";
    private static final int NUM_OF_BODY_ROW = 2;
    private static final int BATCH_SIZE = 200;

    public static String generateTestDataTableName() {
        return TEST_TABLE_NAME_PREFIX + UUID.randomUUID().toString().replace("-", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertTableToExcelFile(String tableName, List<TestDataTableColumn> columns, ResultSet resultSet) throws IOException, SQLException {
        File file = new File(Files.createTempFile(tableName, EXCEL_EXT, new FileAttribute[0]).toString());
        try (FileOutputStream outputStream = new FileOutputStream(file);
             SXSSFWorkbook workbook = new SXSSFWorkbook();){
            SXSSFSheet sheet = workbook.createSheet();
            sheet.setRandomAccessWindowSize(100);
            while (resultSet.next()) {
                SXSSFRow row;
                int rowCount = resultSet.getRow();
                if (rowCount - 1 == 0) {
                    row = sheet.createRow(rowCount - 1);
                    TestDataTableConvertor.formExcelRow(rowCount - 1, columns, (Row)row, resultSet);
                }
                row = sheet.createRow(rowCount);
                TestDataTableConvertor.formExcelRow(rowCount + 2, columns, (Row)row, resultSet);
            }
            workbook.write((OutputStream)outputStream);
        }
        finally {
            file.deleteOnExit();
        }
        return file;
    }

    private static void formExcelRow(int rowCount, List<TestDataTableColumn> columns, Row row, ResultSet resultSet) throws SQLException {
        for (int colCount = 1; colCount < columns.size(); ++colCount) {
            Cell cell = row.createCell(colCount - 1);
            Consumer<String> consumer = arg_0 -> ((Cell)cell).setCellValue(arg_0);
            String columnName = columns.get(colCount).getIdentity().getColumnName();
            TestDataTableConvertor.setCellsForExcelFile(rowCount, columnName, resultSet, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertTableToCsvFile(String tableName, List<TestDataTableColumn> columns, ResultSet resultSet) throws IOException, SQLException {
        File file = new File(Files.createTempFile(tableName, CSV_EXT, new FileAttribute[0]).toString());
        try (CSVPrinter printer = new CSVPrinter((Appendable)new FileWriter(file), CSVFormat.EXCEL);){
            while (resultSet.next()) {
                int rowCount = resultSet.getRow();
                if (rowCount - 1 == 0) {
                    TestDataTableConvertor.formCsvRow(columns, rowCount - 1, resultSet, printer, tableName);
                    printer.println();
                }
                TestDataTableConvertor.formCsvRow(columns, rowCount + 2, resultSet, printer, tableName);
                printer.println();
                if (rowCount % 200 != 0) continue;
                printer.flush();
            }
        }
        finally {
            file.deleteOnExit();
        }
        return file;
    }

    private static void formCsvRow(List<TestDataTableColumn> columns, int rowCount, ResultSet resultSet, CSVPrinter printer, String tableName) throws SQLException {
        for (int colCount = 1; colCount < columns.size(); ++colCount) {
            String columnName = columns.get(colCount).getIdentity().getColumnName();
            TestDataTableConvertor.setCellsForCsvFile(rowCount, colCount, columnName, resultSet, value -> {
                try {
                    printer.print(value);
                }
                catch (IOException e) {
                    log.error(String.format("An error occurred while building csv file for table {%s}.", tableName), (Throwable)e);
                    throw new TdmBuildCvsFileException(tableName);
                }
            });
        }
    }

    private static void setCellsForExcelFile(int rowCount, String columnName, ResultSet resultSet, Consumer<String> consumer) throws SQLException {
        if (rowCount == 0) {
            TestDataTableConvertor.setBodyCellsForFile(columnName, consumer);
        } else {
            String cellValue = "";
            if (Objects.nonNull(resultSet.getObject(columnName))) {
                cellValue = resultSet.getObject(columnName).toString();
            }
            TestDataTableConvertor.setBodyCellsForFile(cellValue, consumer);
        }
    }

    private static void setCellsForCsvFile(int rowCount, int colCount, String columnName, ResultSet resultSet, Consumer<String> consumer) throws SQLException {
        if (rowCount == 0 && colCount > 0) {
            TestDataTableConvertor.setBodyCellsForFile(columnName, consumer);
        } else {
            String cellValue = "";
            if (Objects.nonNull(resultSet.getObject(columnName))) {
                cellValue = resultSet.getObject(columnName).toString();
            }
            TestDataTableConvertor.setBodyCellsForFile(cellValue, consumer);
        }
    }

    private static void setBodyCellsForFile(String cellValue, Consumer<String> consumer) {
        consumer.accept(cellValue);
    }

    public static String replaceParams(Map<String, Object> hashMap, String template) {
        return hashMap.entrySet().stream().reduce(template, (s, e) -> String.valueOf(s).replace("${" + (String)e.getKey() + "}", String.valueOf(e.getValue())), (s, s2) -> s);
    }
}

